/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.rangeValue;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.project.Project;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrowserBackedRangeValueSynchronizer
extends RangeValueSynchronizer {
    private String lastSyncedValue;
    protected final Project project;
    protected boolean dirty;

    protected BrowserBackedRangeValueSynchronizer(Project project) {
        this.project = project;
    }

    @Override
    public final void sync(CharSequence value) {
        this.dirty = true;
        this.doSync(value);
    }

    @Override
    public void sync(@NotNull LookupElement item, @NotNull Lookup lookup, boolean closed) {
        if (item == null) {
            BrowserBackedRangeValueSynchronizer.$$$reportNull$$$0(0);
        }
        if (lookup == null) {
            BrowserBackedRangeValueSynchronizer.$$$reportNull$$$0(1);
        }
        this.dirty = true;
        String itemLookupString = item.getLookupString();
        if (itemLookupString.equals(this.lastSyncedValue)) {
            return;
        }
        CharSequence value = this.itemToString(item, itemLookupString, lookup, closed);
        if (value != null) {
            this.doSync(value);
            this.lastSyncedValue = itemLookupString;
        }
    }

    @Nullable
    protected CharSequence itemToString(@NotNull LookupElement item, @NotNull String itemLookupString, @NotNull Lookup lookup, boolean closed) {
        if (item == null) {
            BrowserBackedRangeValueSynchronizer.$$$reportNull$$$0(2);
        }
        if (itemLookupString == null) {
            BrowserBackedRangeValueSynchronizer.$$$reportNull$$$0(3);
        }
        if (lookup == null) {
            BrowserBackedRangeValueSynchronizer.$$$reportNull$$$0(4);
        }
        return itemLookupString;
    }

    @Nullable
    protected static CharSequence getEffectiveText(@NotNull LookupElement item, @NotNull String itemLookupString, int valueStart, int valueEnd, @NotNull Lookup lookup, boolean closed) {
        if (item == null) {
            BrowserBackedRangeValueSynchronizer.$$$reportNull$$$0(5);
        }
        if (itemLookupString == null) {
            BrowserBackedRangeValueSynchronizer.$$$reportNull$$$0(6);
        }
        if (lookup == null) {
            BrowserBackedRangeValueSynchronizer.$$$reportNull$$$0(7);
        }
        if (closed) {
            return lookup.getEditor().getDocument().getImmutableCharSequence().subSequence(valueStart, valueEnd);
        }
        int caretOffset = lookup.getEditor().getCaretModel().getOffset();
        int end = caretOffset - ((LookupImpl)lookup).getPrefixLength(item);
        if (end <= valueStart && valueEnd <= caretOffset) {
            return itemLookupString;
        }
        StringBuilder builder = new StringBuilder();
        CharSequence chars = lookup.getEditor().getDocument().getImmutableCharSequence();
        if (end > valueStart) {
            builder.append(chars, valueStart, end);
        }
        builder.append(itemLookupString);
        if (valueEnd > caretOffset) {
            builder.append(chars, caretOffset, valueEnd);
        }
        return builder;
    }

    protected abstract void doSync(@NotNull CharSequence var1);

    @Override
    public void revert() {
        if (this.dirty) {
            this.lastSyncedValue = null;
            this.doRevert();
        }
    }

    protected abstract void doRevert();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemLookupString";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/liveEdit/rangeValue/BrowserBackedRangeValueSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "sync";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "itemToString";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getEffectiveText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

