/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.nodeJs;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.openapi.util.Ref;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.SemVer;
import com.intellij.xdebugger.XDebugProcess;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.UpdatePolicy;
import com.jetbrains.liveEdit.update.UpdateConfiguration;
import com.jetbrains.liveEdit.update.UpdateConfigurationProvider;
import com.jetbrains.nodeJs.NodeChromeDebugProcess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NodeJsUpdateConfigurationProvider
extends UpdateConfigurationProvider {
    private static final UpdateConfiguration UPDATE_CONFIGURATION = new NodeUpdateConfiguration();
    private static final UpdateConfiguration UPDATE_ADD_HEADER_CONFIGURATION = new NodeUpdateConfiguration(){
        private static final String S = "(function (exports, require, module, __filename, __dirname) { ";
        private static final String E = "\n});";

        @Override
        @NotNull
        public CharSequence preprocessSource(@NotNull CharSequence text) {
            if (text == null) {
                1.$$$reportNull$$$0(0);
            }
            return new MergingCharSequence((CharSequence)new MergingCharSequence((CharSequence)S, text), (CharSequence)E);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/debugger/nodeJs/NodeJsUpdateConfigurationProvider$1", "preprocessSource"));
        }
    };

    NodeJsUpdateConfigurationProvider() {
    }

    @Override
    @Nullable
    public UpdateConfiguration getConfiguration(@NotNull XDebugProcess debugProcess) {
        if (debugProcess == null) {
            NodeJsUpdateConfigurationProvider.$$$reportNull$$$0(0);
        }
        if (debugProcess instanceof NodeChromeDebugProcess) {
            SemVer version;
            Ref versionRef;
            NodeJsInterpreter interpreter;
            RunProfile profile = debugProcess.getSession().getRunProfile();
            if (profile instanceof NodeDebugRunConfiguration && (interpreter = ((NodeDebugRunConfiguration)profile).getInterpreter()) != null && (versionRef = interpreter.getCachedVersion()) != null && (version = (SemVer)versionRef.get()) != null) {
                boolean withoutHeader;
                boolean bl = withoutHeader = version.getMajor() == 10 && version.isGreaterOrEqualThan(10, 16, 0) || version.getMajor() == 11 && version.isGreaterOrEqualThan(11, 11, 0) || version.isGreaterOrEqualThan(12, 0, 0);
                if (!withoutHeader) {
                    return UPDATE_ADD_HEADER_CONFIGURATION;
                }
            }
            return UPDATE_CONFIGURATION;
        }
        return null;
    }

    @Override
    public boolean isSupported(@NotNull RunProfile runProfile) {
        if (runProfile == null) {
            NodeJsUpdateConfigurationProvider.$$$reportNull$$$0(1);
        }
        return runProfile instanceof NodeDebugRunConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProfile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/debugger/nodeJs/NodeJsUpdateConfigurationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NodeUpdateConfiguration
    extends UpdateConfiguration {
        private NodeUpdateConfiguration() {
        }

        @Override
        @NotNull
        public UpdatePolicy getPolicy() {
            UpdatePolicy updatePolicy = LiveEditOptions.getInstance().isNodeUpdateOnChanges() ? UpdatePolicy.AUTO : UpdatePolicy.MANUAL;
            if (updatePolicy == null) {
                NodeUpdateConfiguration.$$$reportNull$$$0(0);
            }
            return updatePolicy;
        }

        @Override
        public int getAutoDelay() {
            return LiveEditOptions.getInstance().getNodeAutoDelay();
        }

        @Override
        public boolean includeHtmlInAutoUpdate() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/nodeJs/NodeJsUpdateConfigurationProvider$NodeUpdateConfiguration", "getPolicy"));
        }
    }
}

