/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 55083575714736L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(620223240 - (char)-8760, -620092170 + -((char)-777), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(620223240 - (char)-8761, -620223240 - -((char)-6756), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 26629991071066L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.G();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1193785560 + 27344, 1193785560 + 27807, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1193785560 + 27345, -1193785560 + -20815, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1193785560 + 27350, 1193785560 + 20171, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                ActionTimestamp[] actionTimestampArray;
                l2 = 124163896813343L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    actionTimestampArray = SshAgentIpcService.G();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(687331080 - (char)-8930, 687200010 + (char)-21264, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(687331080 - (char)-8929, -687200010 + -((char)-3057), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(687331080 - (char)-8928, -687200010 + -((char)-18735), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(687331080 - (char)-8927, 687200010 + (char)-9505, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(687331080 - (char)-8926, 687331080 - (char)-4205, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(687331080 - (char)-8928, -687200010 + -((char)-18735), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(687331080 - (char)-8925, -687331080 - -((char)-7612), (int)l2));
            if (ActionTimestamp.G() == null) {
                SshAgentIpcService.G(new ActionTimestamp[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 82242482844720L;
                    actionTimestampArray = SshAgentIpcService.G();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block27: {
            block28: {
                l2 = 4490964567483L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.G();
                this.assertConnectionThread();
                actionTimestampArray = actionTimestampArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-616), 1571267160 - (char)-23081, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-604), 1571267160 - (char)-11817, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-609), -1571267160 - -((char)-20056), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-604), 1571267160 - (char)-11817, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-610), -1571136090 + -((char)-8384), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-616), 1571267160 - (char)-23081, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-604), 1571267160 - (char)-11817, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-611), 1571267160 - (char)-1036, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-616), 1571267160 - (char)-23081, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-604), 1571267160 - (char)-11817, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-612), 1571136090 + (char)-8202, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-604), 1571267160 - (char)-11817, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-589), 1571267160 - (char)-2918, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-604), 1571267160 - (char)-11817, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-610), -1571136090 + -((char)-8384), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-616), 1571267160 - (char)-23081, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-604), 1571267160 - (char)-11817, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1571267160 - -((char)-590), -1571267160 - -((char)-14424), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 54315076567386L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-920111400 + -26800, 920111400 + (char)-26602, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 13968107562860L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-873843690 + -((char)-13321), -873843690 + -((char)-10627), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "C\u00fe\u00d7z\u00c7\u0099\u00fad\u0092i<x\u001c\u007f\u00bbD\u001fh\u00eb\u0014\"f\u00fboY\u00f9T\u00ed\u00c5^\u0013J;\u00c0\u009e8V!\u00c5 ";
                        var4_3 = "C\u00fe\u00d7z\u00c7\u0099\u00fad\u0092i<x\u001c\u007f\u00bbD\u001fh\u00eb\u0014\"f\u00fboY\u00f9T\u00ed\u00c5^\u0013J;\u00c0\u009e8V!\u00c5 ".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 67;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 115;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 1;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 46;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 46;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 36;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 40;
                                        break;
                                    }
                                    default: {
                                        v11 = 123;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFF8F72) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 97;
                            case 1 -> 95;
                            case 2 -> 238;
                            case 3 -> 9;
                            case 4 -> 164;
                            case 5 -> 40;
                            case 6 -> 227;
                            case 7 -> 8;
                            case 8 -> 48;
                            case 9 -> 159;
                            case 10 -> 213;
                            case 11 -> 139;
                            case 12 -> 177;
                            case 13 -> 223;
                            case 14 -> 120;
                            case 15 -> 251;
                            case 16 -> 180;
                            case 17 -> 245;
                            case 18 -> 121;
                            case 19 -> 152;
                            case 20 -> 255;
                            case 21 -> 168;
                            case 22 -> 64;
                            case 23 -> 205;
                            case 24 -> 78;
                            case 25 -> 30;
                            case 26 -> 1;
                            case 27 -> 70;
                            case 28 -> 118;
                            case 29 -> 10;
                            case 30 -> 246;
                            case 31 -> 195;
                            case 32 -> 127;
                            case 33 -> 25;
                            case 34 -> 217;
                            case 35 -> 173;
                            case 36 -> 92;
                            case 37 -> 254;
                            case 38 -> 219;
                            case 39 -> 20;
                            case 40 -> 197;
                            case 41 -> 153;
                            case 42 -> 181;
                            case 43 -> 101;
                            case 44 -> 52;
                            case 45 -> 244;
                            case 46 -> 50;
                            case 47 -> 6;
                            case 48 -> 147;
                            case 49 -> 236;
                            case 50 -> 135;
                            case 51 -> 226;
                            case 52 -> 47;
                            case 53 -> 80;
                            case 54 -> 67;
                            case 55 -> 98;
                            case 56 -> 218;
                            case 57 -> 108;
                            case 58 -> 32;
                            case 59 -> 150;
                            case 60 -> 243;
                            case 61 -> 224;
                            case 62 -> 56;
                            case 63 -> 104;
                            case 64 -> 225;
                            case 65 -> 76;
                            case 66 -> 91;
                            case 67 -> 128;
                            case 68 -> 86;
                            case 69 -> 4;
                            case 70 -> 231;
                            case 71 -> 5;
                            case 72 -> 130;
                            case 73 -> 220;
                            case 74 -> 45;
                            case 75 -> 185;
                            case 76 -> 35;
                            case 77 -> 169;
                            case 78 -> 252;
                            case 79 -> 155;
                            case 80 -> 83;
                            case 81 -> 109;
                            case 82 -> 201;
                            case 83 -> 250;
                            case 84 -> 17;
                            case 85 -> 144;
                            case 86 -> 131;
                            case 87 -> 166;
                            case 88 -> 3;
                            case 89 -> 212;
                            case 90 -> 230;
                            case 91 -> 117;
                            case 92 -> 19;
                            case 93 -> 12;
                            case 94 -> 209;
                            case 95 -> 183;
                            case 96 -> 149;
                            case 97 -> 239;
                            case 98 -> 157;
                            case 99 -> 187;
                            case 100 -> 172;
                            case 101 -> 2;
                            case 102 -> 249;
                            case 103 -> 229;
                            case 104 -> 102;
                            case 105 -> 126;
                            case 106 -> 114;
                            case 107 -> 198;
                            case 108 -> 27;
                            case 109 -> 199;
                            case 110 -> 59;
                            case 111 -> 132;
                            case 112 -> 186;
                            case 113 -> 93;
                            case 114 -> 237;
                            case 115 -> 71;
                            case 116 -> 203;
                            case 117 -> 151;
                            case 118 -> 13;
                            case 119 -> 170;
                            case 120 -> 46;
                            case 121 -> 110;
                            case 122 -> 140;
                            case 123 -> 26;
                            case 124 -> 167;
                            case 125 -> 188;
                            case 126 -> 190;
                            case 127 -> 184;
                            case 128 -> 33;
                            case 129 -> 116;
                            case 130 -> 53;
                            case 131 -> 174;
                            case 132 -> 24;
                            case 133 -> 58;
                            case 134 -> 103;
                            case 135 -> 211;
                            case 136 -> 202;
                            case 137 -> 11;
                            case 138 -> 196;
                            case 139 -> 233;
                            case 140 -> 215;
                            case 141 -> 204;
                            case 142 -> 62;
                            case 143 -> 21;
                            case 144 -> 160;
                            case 145 -> 55;
                            case 146 -> 193;
                            case 147 -> 123;
                            case 148 -> 115;
                            case 149 -> 16;
                            case 150 -> 85;
                            case 151 -> 216;
                            case 152 -> 141;
                            case 153 -> 165;
                            case 154 -> 41;
                            case 155 -> 214;
                            case 156 -> 113;
                            case 157 -> 253;
                            case 158 -> 74;
                            case 159 -> 36;
                            case 160 -> 79;
                            case 161 -> 44;
                            case 162 -> 51;
                            case 163 -> 106;
                            case 164 -> 154;
                            case 165 -> 158;
                            case 166 -> 28;
                            case 167 -> 134;
                            case 168 -> 208;
                            case 169 -> 124;
                            case 170 -> 143;
                            case 171 -> 43;
                            case 172 -> 138;
                            case 173 -> 88;
                            case 174 -> 54;
                            case 175 -> 241;
                            case 176 -> 137;
                            case 177 -> 206;
                            case 178 -> 38;
                            case 179 -> 161;
                            case 180 -> 207;
                            case 181 -> 63;
                            case 182 -> 247;
                            case 183 -> 242;
                            case 184 -> 107;
                            case 185 -> 57;
                            case 186 -> 232;
                            case 187 -> 87;
                            case 188 -> 34;
                            case 189 -> 176;
                            case 190 -> 105;
                            case 191 -> 65;
                            case 192 -> 42;
                            case 193 -> 248;
                            case 194 -> 200;
                            case 195 -> 122;
                            case 196 -> 148;
                            case 197 -> 194;
                            case 198 -> 119;
                            case 199 -> 0;
                            case 200 -> 145;
                            case 201 -> 81;
                            case 202 -> 77;
                            case 203 -> 37;
                            case 204 -> 94;
                            case 205 -> 15;
                            case 206 -> 90;
                            case 207 -> 178;
                            case 208 -> 240;
                            case 209 -> 68;
                            case 210 -> 73;
                            case 211 -> 18;
                            case 212 -> 111;
                            case 213 -> 60;
                            case 214 -> 179;
                            case 215 -> 221;
                            case 216 -> 66;
                            case 217 -> 228;
                            case 218 -> 235;
                            case 219 -> 99;
                            case 220 -> 142;
                            case 221 -> 89;
                            case 222 -> 14;
                            case 223 -> 125;
                            case 224 -> 61;
                            case 225 -> 7;
                            case 226 -> 31;
                            case 227 -> 39;
                            case 228 -> 189;
                            case 229 -> 191;
                            case 230 -> 100;
                            case 231 -> 156;
                            case 232 -> 75;
                            case 233 -> 72;
                            case 234 -> 96;
                            case 235 -> 163;
                            case 236 -> 133;
                            case 237 -> 129;
                            case 238 -> 192;
                            case 239 -> 171;
                            case 240 -> 146;
                            case 241 -> 175;
                            case 242 -> 23;
                            case 243 -> 234;
                            case 244 -> 84;
                            case 245 -> 29;
                            case 246 -> 136;
                            case 247 -> 82;
                            case 248 -> 69;
                            case 249 -> 182;
                            case 250 -> 222;
                            case 251 -> 210;
                            case 252 -> 49;
                            case 253 -> 112;
                            case 254 -> 162;
                            default -> 22;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (actionTimestampArray == null) {
                ActionTimestamp.G("ZDdjQb");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 136845661835566L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.G();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-586145040 - -11493, 586145040 + 2820, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-586145040 - -11497, 586145040 - 6396, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-586145040 - -11484, -586145040 - -17721, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-586145040 - -11493, 586145040 + 2820, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-586145040 - -11497, 586145040 - 6396, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-586145040 - -11485, 586145040 - 1823, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 55794381543856L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.G();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1538630730 - -11166, -1538630730 - -((char)-28915), (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1538630730 - -11167, -1538630730 - -((char)-31202), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 94877523604120L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.G();
                this.assertConnectionThread();
                actionTimestampArray = actionTimestampArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1696045800 - 28293, -1696045800 - -9866, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1696045800 - 28281, -1696045800 - -17034, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1696045800 - 28266, 1696045800 - 24187, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1696045800 - 28281, -1696045800 - -17034, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1696045800 - 28291, 1696045800 - (char)-28253, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1696045800 - 28293, -1696045800 - -9866, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1696045800 - 28281, -1696045800 - -17034, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1696045800 - 28265, -1696045800 - -10144, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1696045800 - 28293, -1696045800 - -9866, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1696045800 - 28281, -1696045800 - -17034, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1696045800 - 28280, -1696045800 - -29928, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1696045800 - 28293, -1696045800 - -9866, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1696045800 - 28281, -1696045800 - -17034, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1696045800 - 28279, 1696045800 - 29101, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 85104472997228L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.G();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-303951330 + -11911, 303951330 + 22132, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-303951330 + -11907, 303951330 + 31348, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-303951330 + -11928, -303951330 + -10836, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-303951330 + -11927, 303951330 + 14283, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-303951330 + -11911, 303951330 + 22132, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-303951330 + -11907, 303951330 + 31348, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-303951330 + -11934, -303951330 + -24252, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-303951330 + -11911, 303951330 + 22132, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-303951330 + -11907, 303951330 + 31348, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-303951330 + -11933, 303951330 + 29578, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-303951330 + -11911, 303951330 + 22132, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-303951330 + -11907, 303951330 + 31348, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-303951330 + -11932, 303951330 + 25101, (int)l2));
                    if (actionTimestampArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-303951330 + -11911, 303951330 + 22132, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-303951330 + -11907, 303951330 + 31348, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-303951330 + -11931, 303951330 + 8333, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u00fe^\u00d1fWR\u00bd\u00d9\u0014\u001d\u00e3\u00956!\u00d0\u00dc\u0093\u001c\u0087\u0000\u009e\u00fd#\u0093\u00dc\u0087\u00c7\u008fN\u0006\u00b0\u00f6\u0018s\u0004\u00b1\u0018\u00c0\u00e6N\u00a6\u00d8\u0007\u00e1\u00a9s\u00bd\u00e2\u00a9\u00c7:\u0086}\u008c\u009a\u00c0x\u00dc\u00d3\u0006\u008e\t0\u00c9\u00ce\u00f2\u00a3\u0012\u0096C\u00a1\u0005F\u00e8\u00c6\u00b0\u00c5\b\u00b7|\u00f8S \u00d2U+\u00057\u00ff\u00e8R\u0000\u001e\u00fc\u00b2\u0084\u009f\u0010\u00e4Z\u00af\u00a1i\u00f3\u00b4\u00a9\u00b9\u00e9i\u0080\u0089\u0093\u00ee\u001a.\u00d2\u00fc\u008eTx\u00a0\u00f7\u00a8\u0010\u009c\u00c0l\u0014Z\u00a7\u00e5>+\u00e9/Y4Q\u00f5\u00eb\t\u0098\u007f\r5\u0088\u00cd\u00d5''\u0010\u00fe\u00c9 5\u00d3\u0083\u00d4\u00ba\ry\u00ebK\u00ac\u0013\u00e6\u00a3?\u0087\b\u00e3\u00c8\u00f1\u0007\u00e3\u00bf\u00e7\u00ba~5\u00a7\u007f\u0015\u0088\u00da\u00d0\u00a5\u0000R\u00a1\u00a0k\u00d0N\u00beW\u0018\u0000\u0084\u00daq2\u001f\u0090r\u00f9\u00b1_\u008f9\u008da\u00d0\u0083\u0095\u0091i\u001fi\u00cd\u00cb\u0085\u00f2\u00992\u00a8\u0016\u00e5\u000f\u00a2_\b[\u00cbe\u00a5\u0093\f#\u00f0\f\u0084\u00b6\u008e\u0011\u00f3\u00f8\u00c1i\u0086K\u00c8\tF\u000f\u0005\u00ffg\u00dd6\u0004\u00b0>|\u00d5+D\u00b4v\u00d7J\\\u00b7>\u00024\u00a9\u00eb\u00c7u\u00af;\u0085\u00a4\rr|\u0091|\u00c5\u00c4\u001e\u00ccg\u00b3+\u0081\u00d8\u008f1*\u00bay\u0082\r\u00d4\u00a80\u00884\u00e2i\u009aa\u00ad[W7\u00c1B-\u008a\u00b9\t\u001f\u00fe3\u00c4\u00af\u0018\u00e2[o\u0081q\u00f7\u00b7)\u00c4\u00f2w\u0098\u00a2\u00edA\u001e[\u0085\u00f9\u0005$\u001eb&\u0001{\u000b\u0087&\u00ee\u0003\u00ff\u00ba@!\u00b6N\u00c4\u00150\u00c8\u0018\u00dd&\t\u0097*r\u00cf\u0094\u00ab\u00fb\u00eb\u00b5\u00c4\u008b@Rd\u00df)\u008c\u00cf\u008a0\u00d1\u0011b\u0011\u00a6\u00be\u0013N\u00b1\u00f1\u007f\u00d4v^\u00eby.$E\u000er\u0093'\u00ec.$\u00f8\\<\u00f1\u0012D\u00173=k.\u0007\u00a7\u0011\u00e5\u00f1\u0018t\u00c0\u0007\u00d6\u009e\u00afl\u00b6(\u0003(\u008c\u0018\u00c6\u00eb\u00e8\u0000\u00b3\u0014\u00ec\u00c9p\u0096\u00fek\u00d4\u0004\u0004\u00e9\u000b\u00ccS\u00ac\u0085\u00d4\u00fat\u0080k\u00ed\u00b4[W\u00b3\u00fb}\u00a8@\u00d3D\u0084\u000fC\u0003q\u00a1\u00f6%\u00d5sU\u00a8\u00e6\u00eb\u008c\u0090\u0004\"\u0082\u00fcKV\u00e9\u00dde\u0088F\u008d\u000f(11\u000b\u0002\u0013\u00ad\u00cdE\u0000\u00a3 \u00aeM\u00d3\r:O\u00ccvF\u00c3A\u000e\u0005#\u00b9\u00a5\u00ef\u00a5\u00f6c1\u00aaj\u00ab\u0011\u0092\u001bW\u00f5\u00f4z\u00bd\u00eb)\u00f6\u009d\u009fr\fBPC8\u00b2@Dd\n\u00b3\u0012\n@*\u00f9\n\u008e\u00cd\u000bzV\u000f\u0087@\u00e3+\u0018\u001ep\u00dd\u00c7\u0099\u00e0\u008c\u00c97\u00b1\u00e5V\tH\u00d6\u001aw\u0005+\u00b5\u009f\u00c2\u00fbw)\u00e8Z\u0006\u0082@GP\u00db\u00e0\u00e7\u00dbe\u00ac\u009dC\"\u008f\u00f5\u000b\u00c9\b\"\u00c8\u00c2\u00b6\u0098\"a\u00dd\u00c9=p\u00a1\u00aat\u00bb\u0005\u00e8\u007f\u0010f";
                var4_3 = "\u00fe^\u00d1fWR\u00bd\u00d9\u0014\u001d\u00e3\u00956!\u00d0\u00dc\u0093\u001c\u0087\u0000\u009e\u00fd#\u0093\u00dc\u0087\u00c7\u008fN\u0006\u00b0\u00f6\u0018s\u0004\u00b1\u0018\u00c0\u00e6N\u00a6\u00d8\u0007\u00e1\u00a9s\u00bd\u00e2\u00a9\u00c7:\u0086}\u008c\u009a\u00c0x\u00dc\u00d3\u0006\u008e\t0\u00c9\u00ce\u00f2\u00a3\u0012\u0096C\u00a1\u0005F\u00e8\u00c6\u00b0\u00c5\b\u00b7|\u00f8S \u00d2U+\u00057\u00ff\u00e8R\u0000\u001e\u00fc\u00b2\u0084\u009f\u0010\u00e4Z\u00af\u00a1i\u00f3\u00b4\u00a9\u00b9\u00e9i\u0080\u0089\u0093\u00ee\u001a.\u00d2\u00fc\u008eTx\u00a0\u00f7\u00a8\u0010\u009c\u00c0l\u0014Z\u00a7\u00e5>+\u00e9/Y4Q\u00f5\u00eb\t\u0098\u007f\r5\u0088\u00cd\u00d5''\u0010\u00fe\u00c9 5\u00d3\u0083\u00d4\u00ba\ry\u00ebK\u00ac\u0013\u00e6\u00a3?\u0087\b\u00e3\u00c8\u00f1\u0007\u00e3\u00bf\u00e7\u00ba~5\u00a7\u007f\u0015\u0088\u00da\u00d0\u00a5\u0000R\u00a1\u00a0k\u00d0N\u00beW\u0018\u0000\u0084\u00daq2\u001f\u0090r\u00f9\u00b1_\u008f9\u008da\u00d0\u0083\u0095\u0091i\u001fi\u00cd\u00cb\u0085\u00f2\u00992\u00a8\u0016\u00e5\u000f\u00a2_\b[\u00cbe\u00a5\u0093\f#\u00f0\f\u0084\u00b6\u008e\u0011\u00f3\u00f8\u00c1i\u0086K\u00c8\tF\u000f\u0005\u00ffg\u00dd6\u0004\u00b0>|\u00d5+D\u00b4v\u00d7J\\\u00b7>\u00024\u00a9\u00eb\u00c7u\u00af;\u0085\u00a4\rr|\u0091|\u00c5\u00c4\u001e\u00ccg\u00b3+\u0081\u00d8\u008f1*\u00bay\u0082\r\u00d4\u00a80\u00884\u00e2i\u009aa\u00ad[W7\u00c1B-\u008a\u00b9\t\u001f\u00fe3\u00c4\u00af\u0018\u00e2[o\u0081q\u00f7\u00b7)\u00c4\u00f2w\u0098\u00a2\u00edA\u001e[\u0085\u00f9\u0005$\u001eb&\u0001{\u000b\u0087&\u00ee\u0003\u00ff\u00ba@!\u00b6N\u00c4\u00150\u00c8\u0018\u00dd&\t\u0097*r\u00cf\u0094\u00ab\u00fb\u00eb\u00b5\u00c4\u008b@Rd\u00df)\u008c\u00cf\u008a0\u00d1\u0011b\u0011\u00a6\u00be\u0013N\u00b1\u00f1\u007f\u00d4v^\u00eby.$E\u000er\u0093'\u00ec.$\u00f8\\<\u00f1\u0012D\u00173=k.\u0007\u00a7\u0011\u00e5\u00f1\u0018t\u00c0\u0007\u00d6\u009e\u00afl\u00b6(\u0003(\u008c\u0018\u00c6\u00eb\u00e8\u0000\u00b3\u0014\u00ec\u00c9p\u0096\u00fek\u00d4\u0004\u0004\u00e9\u000b\u00ccS\u00ac\u0085\u00d4\u00fat\u0080k\u00ed\u00b4[W\u00b3\u00fb}\u00a8@\u00d3D\u0084\u000fC\u0003q\u00a1\u00f6%\u00d5sU\u00a8\u00e6\u00eb\u008c\u0090\u0004\"\u0082\u00fcKV\u00e9\u00dde\u0088F\u008d\u000f(11\u000b\u0002\u0013\u00ad\u00cdE\u0000\u00a3 \u00aeM\u00d3\r:O\u00ccvF\u00c3A\u000e\u0005#\u00b9\u00a5\u00ef\u00a5\u00f6c1\u00aaj\u00ab\u0011\u0092\u001bW\u00f5\u00f4z\u00bd\u00eb)\u00f6\u009d\u009fr\fBPC8\u00b2@Dd\n\u00b3\u0012\n@*\u00f9\n\u008e\u00cd\u000bzV\u000f\u0087@\u00e3+\u0018\u001ep\u00dd\u00c7\u0099\u00e0\u008c\u00c97\u00b1\u00e5V\tH\u00d6\u001aw\u0005+\u00b5\u009f\u00c2\u00fbw)\u00e8Z\u0006\u0082@GP\u00db\u00e0\u00e7\u00dbe\u00ac\u009dC\"\u008f\u00f5\u000b\u00c9\b\"\u00c8\u00c2\u00b6\u0098\"a\u00dd\u00c9=p\u00a1\u00aat\u00bb\u0005\u00e8\u007f\u0010f".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 105;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0089v\u00b9\u009c\u0082\u00a1Tg<\u001d\u00e1_\u00b1\u00b4 \u0017\u00caG%\u00e2\u00f5S\u00ff\u00cd\u00bf\u00be\u0086\u00fc\u00ec\u00fa7\u00edJs\u00db$\u0088%\u008e";
                    var4_3 = "\u0089v\u00b9\u009c\u0082\u00a1Tg<\u001d\u00e1_\u00b1\u00b4 \u0017\u00caG%\u00e2\u00f5S\u00ff\u00cd\u00bf\u00be\u0086\u00fc\u00ec\u00fa7\u00edJs\u00db$\u0088%\u008e".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 125;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 57;
                            break;
                        }
                        case 1: {
                            v15 = 77;
                            break;
                        }
                        case 2: {
                            v15 = 99;
                            break;
                        }
                        case 3: {
                            v15 = 97;
                            break;
                        }
                        case 4: {
                            v15 = 107;
                            break;
                        }
                        case 5: {
                            v15 = 94;
                            break;
                        }
                        default: {
                            v15 = 80;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x5EF0) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 168;
                case 1 -> 11;
                case 2 -> 43;
                case 3 -> 106;
                case 4 -> 2;
                case 5 -> 199;
                case 6 -> 228;
                case 7 -> 105;
                case 8 -> 151;
                case 9 -> 215;
                case 10 -> 188;
                case 11 -> 172;
                case 12 -> 101;
                case 13 -> 123;
                case 14 -> 76;
                case 15 -> 73;
                case 16 -> 107;
                case 17 -> 253;
                case 18 -> 216;
                case 19 -> 247;
                case 20 -> 206;
                case 21 -> 1;
                case 22 -> 127;
                case 23 -> 200;
                case 24 -> 28;
                case 25 -> 182;
                case 26 -> 124;
                case 27 -> 57;
                case 28 -> 81;
                case 29 -> 5;
                case 30 -> 46;
                case 31 -> 120;
                case 32 -> 148;
                case 33 -> 60;
                case 34 -> 128;
                case 35 -> 117;
                case 36 -> 230;
                case 37 -> 196;
                case 38 -> 208;
                case 39 -> 189;
                case 40 -> 178;
                case 41 -> 163;
                case 42 -> 229;
                case 43 -> 160;
                case 44 -> 91;
                case 45 -> 248;
                case 46 -> 94;
                case 47 -> 194;
                case 48 -> 7;
                case 49 -> 155;
                case 50 -> 99;
                case 51 -> 244;
                case 52 -> 84;
                case 53 -> 161;
                case 54 -> 88;
                case 55 -> 195;
                case 56 -> 158;
                case 57 -> 166;
                case 58 -> 234;
                case 59 -> 225;
                case 60 -> 59;
                case 61 -> 24;
                case 62 -> 44;
                case 63 -> 69;
                case 64 -> 102;
                case 65 -> 242;
                case 66 -> 42;
                case 67 -> 74;
                case 68 -> 75;
                case 69 -> 162;
                case 70 -> 78;
                case 71 -> 63;
                case 72 -> 33;
                case 73 -> 58;
                case 74 -> 13;
                case 75 -> 41;
                case 76 -> 245;
                case 77 -> 32;
                case 78 -> 154;
                case 79 -> 34;
                case 80 -> 185;
                case 81 -> 116;
                case 82 -> 217;
                case 83 -> 203;
                case 84 -> 223;
                case 85 -> 52;
                case 86 -> 232;
                case 87 -> 250;
                case 88 -> 177;
                case 89 -> 70;
                case 90 -> 6;
                case 91 -> 181;
                case 92 -> 61;
                case 93 -> 137;
                case 94 -> 108;
                case 95 -> 134;
                case 96 -> 173;
                case 97 -> 53;
                case 98 -> 8;
                case 99 -> 79;
                case 100 -> 82;
                case 101 -> 80;
                case 102 -> 197;
                case 103 -> 35;
                case 104 -> 233;
                case 105 -> 14;
                case 106 -> 71;
                case 107 -> 170;
                case 108 -> 246;
                case 109 -> 220;
                case 110 -> 72;
                case 111 -> 198;
                case 112 -> 156;
                case 113 -> 93;
                case 114 -> 125;
                case 115 -> 47;
                case 116 -> 10;
                case 117 -> 45;
                case 118 -> 89;
                case 119 -> 141;
                case 120 -> 26;
                case 121 -> 118;
                case 122 -> 184;
                case 123 -> 210;
                case 124 -> 201;
                case 125 -> 138;
                case 126 -> 175;
                case 127 -> 204;
                case 128 -> 67;
                case 129 -> 129;
                case 130 -> 77;
                case 131 -> 66;
                case 132 -> 115;
                case 133 -> 119;
                case 134 -> 111;
                case 135 -> 19;
                case 136 -> 25;
                case 137 -> 186;
                case 138 -> 104;
                case 139 -> 218;
                case 140 -> 109;
                case 141 -> 21;
                case 142 -> 153;
                case 143 -> 150;
                case 144 -> 211;
                case 145 -> 164;
                case 146 -> 240;
                case 147 -> 90;
                case 148 -> 3;
                case 149 -> 83;
                case 150 -> 152;
                case 151 -> 213;
                case 152 -> 187;
                case 153 -> 95;
                case 154 -> 22;
                case 155 -> 174;
                case 156 -> 9;
                case 157 -> 20;
                case 158 -> 202;
                case 159 -> 130;
                case 160 -> 64;
                case 161 -> 37;
                case 162 -> 12;
                case 163 -> 110;
                case 164 -> 29;
                case 165 -> 100;
                case 166 -> 121;
                case 167 -> 171;
                case 168 -> 251;
                case 169 -> 212;
                case 170 -> 16;
                case 171 -> 149;
                case 172 -> 96;
                case 173 -> 31;
                case 174 -> 113;
                case 175 -> 98;
                case 176 -> 4;
                case 177 -> 131;
                case 178 -> 193;
                case 179 -> 221;
                case 180 -> 87;
                case 181 -> 146;
                case 182 -> 252;
                case 183 -> 135;
                case 184 -> 126;
                case 185 -> 224;
                case 186 -> 165;
                case 187 -> 65;
                case 188 -> 169;
                case 189 -> 183;
                case 190 -> 68;
                case 191 -> 18;
                case 192 -> 222;
                case 193 -> 205;
                case 194 -> 62;
                case 195 -> 144;
                case 196 -> 85;
                case 197 -> 15;
                case 198 -> 0;
                case 199 -> 231;
                case 200 -> 49;
                case 201 -> 38;
                case 202 -> 209;
                case 203 -> 92;
                case 204 -> 191;
                case 205 -> 140;
                case 206 -> 122;
                case 207 -> 143;
                case 208 -> 237;
                case 209 -> 48;
                case 210 -> 176;
                case 211 -> 239;
                case 212 -> 241;
                case 213 -> 238;
                case 214 -> 214;
                case 215 -> 254;
                case 216 -> 39;
                case 217 -> 55;
                case 218 -> 159;
                case 219 -> 51;
                case 220 -> 249;
                case 221 -> 139;
                case 222 -> 207;
                case 223 -> 243;
                case 224 -> 157;
                case 225 -> 133;
                case 226 -> 56;
                case 227 -> 142;
                case 228 -> 179;
                case 229 -> 192;
                case 230 -> 54;
                case 231 -> 27;
                case 232 -> 167;
                case 233 -> 227;
                case 234 -> 40;
                case 235 -> 36;
                case 236 -> 255;
                case 237 -> 112;
                case 238 -> 86;
                case 239 -> 180;
                case 240 -> 136;
                case 241 -> 145;
                case 242 -> 226;
                case 243 -> 219;
                case 244 -> 190;
                case 245 -> 97;
                case 246 -> 114;
                case 247 -> 236;
                case 248 -> 132;
                case 249 -> 235;
                case 250 -> 30;
                case 251 -> 23;
                case 252 -> 147;
                case 253 -> 103;
                case 254 -> 50;
                default -> 17;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 27582273209854L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-6815640 - -((char)-11605), -6815640 - -((char)-30567), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 1256484073985L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.G();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1941408840 - -((char)-3787), 1941408840 - (char)-14162, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1941408840 - -((char)-3786), -1941408840 - -((char)-13603), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1941408840 - -((char)-3785), 1941408840 - (char)-6377, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00068U\u00ab\nAxT\u0010\fH\u00e5\u0004\u00a6\u000f\u0014\u00c4\u00f3-5\f\u00dd\u0095'\u0095";
                    var4_3 = "\u00068U\u00ab\nAxT\u0010\fH\u00e5\u0004\u00a6\u000f\u0014\u00c4\u00f3-5\f\u00dd\u0095'\u0095".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 29;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "@ydz\u00a55\u00ed$\u00c6\u00bd#\u00f8EhW\u00fa\u00ca\u00cf,\u00fe\u00e5\u008b\u00b8\u0081J\u00e8$/\u00dd\u008c\u00e6)4\u0006\u00cf\u0005\u00cd\u00c5\u0090>\u00b0F]k\u00e8RG \u0015\u00b5\u00f4\n\u00d7a\u0002\u00e1\bUZ";
                        var4_3 = "@ydz\u00a55\u00ed$\u00c6\u00bd#\u00f8EhW\u00fa\u00ca\u00cf,\u00fe\u00e5\u008b\u00b8\u0081J\u00e8$/\u00dd\u008c\u00e6)4\u0006\u00cf\u0005\u00cd\u00c5\u0090>\u00b0F]k\u00e8RG \u0015\u00b5\u00f4\n\u00d7a\u0002\u00e1\bUZ".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 35;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 98;
                                break;
                            }
                            case 1: {
                                v15 = 26;
                                break;
                            }
                            case 2: {
                                v15 = 105;
                                break;
                            }
                            case 3: {
                                v15 = 112;
                                break;
                            }
                            case 4: {
                                v15 = 29;
                                break;
                            }
                            case 5: {
                                v15 = 44;
                                break;
                            }
                            default: {
                                v15 = 10;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x16ED) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 44;
                    case 1 -> 35;
                    case 2 -> 138;
                    case 3 -> 9;
                    case 4 -> 251;
                    case 5 -> 37;
                    case 6 -> 132;
                    case 7 -> 28;
                    case 8 -> 3;
                    case 9 -> 34;
                    case 10 -> 195;
                    case 11 -> 42;
                    case 12 -> 128;
                    case 13 -> 52;
                    case 14 -> 229;
                    case 15 -> 221;
                    case 16 -> 157;
                    case 17 -> 85;
                    case 18 -> 32;
                    case 19 -> 193;
                    case 20 -> 61;
                    case 21 -> 26;
                    case 22 -> 39;
                    case 23 -> 50;
                    case 24 -> 179;
                    case 25 -> 97;
                    case 26 -> 80;
                    case 27 -> 117;
                    case 28 -> 77;
                    case 29 -> 23;
                    case 30 -> 71;
                    case 31 -> 145;
                    case 32 -> 93;
                    case 33 -> 20;
                    case 34 -> 245;
                    case 35 -> 87;
                    case 36 -> 123;
                    case 37 -> 171;
                    case 38 -> 250;
                    case 39 -> 149;
                    case 40 -> 10;
                    case 41 -> 200;
                    case 42 -> 69;
                    case 43 -> 30;
                    case 44 -> 162;
                    case 45 -> 91;
                    case 46 -> 247;
                    case 47 -> 159;
                    case 48 -> 139;
                    case 49 -> 18;
                    case 50 -> 115;
                    case 51 -> 152;
                    case 52 -> 31;
                    case 53 -> 118;
                    case 54 -> 156;
                    case 55 -> 84;
                    case 56 -> 111;
                    case 57 -> 165;
                    case 58 -> 90;
                    case 59 -> 64;
                    case 60 -> 198;
                    case 61 -> 232;
                    case 62 -> 173;
                    case 63 -> 230;
                    case 64 -> 180;
                    case 65 -> 105;
                    case 66 -> 107;
                    case 67 -> 141;
                    case 68 -> 76;
                    case 69 -> 219;
                    case 70 -> 17;
                    case 71 -> 169;
                    case 72 -> 72;
                    case 73 -> 191;
                    case 74 -> 181;
                    case 75 -> 188;
                    case 76 -> 94;
                    case 77 -> 220;
                    case 78 -> 54;
                    case 79 -> 158;
                    case 80 -> 7;
                    case 81 -> 58;
                    case 82 -> 100;
                    case 83 -> 74;
                    case 84 -> 205;
                    case 85 -> 53;
                    case 86 -> 43;
                    case 87 -> 244;
                    case 88 -> 119;
                    case 89 -> 133;
                    case 90 -> 233;
                    case 91 -> 150;
                    case 92 -> 36;
                    case 93 -> 239;
                    case 94 -> 176;
                    case 95 -> 183;
                    case 96 -> 79;
                    case 97 -> 130;
                    case 98 -> 95;
                    case 99 -> 49;
                    case 100 -> 203;
                    case 101 -> 148;
                    case 102 -> 197;
                    case 103 -> 196;
                    case 104 -> 226;
                    case 105 -> 126;
                    case 106 -> 109;
                    case 107 -> 96;
                    case 108 -> 8;
                    case 109 -> 142;
                    case 110 -> 131;
                    case 111 -> 29;
                    case 112 -> 241;
                    case 113 -> 70;
                    case 114 -> 178;
                    case 115 -> 135;
                    case 116 -> 215;
                    case 117 -> 187;
                    case 118 -> 224;
                    case 119 -> 75;
                    case 120 -> 120;
                    case 121 -> 246;
                    case 122 -> 185;
                    case 123 -> 4;
                    case 124 -> 134;
                    case 125 -> 255;
                    case 126 -> 167;
                    case 127 -> 252;
                    case 128 -> 210;
                    case 129 -> 218;
                    case 130 -> 83;
                    case 131 -> 108;
                    case 132 -> 112;
                    case 133 -> 63;
                    case 134 -> 164;
                    case 135 -> 11;
                    case 136 -> 214;
                    case 137 -> 231;
                    case 138 -> 146;
                    case 139 -> 227;
                    case 140 -> 217;
                    case 141 -> 102;
                    case 142 -> 249;
                    case 143 -> 82;
                    case 144 -> 113;
                    case 145 -> 194;
                    case 146 -> 67;
                    case 147 -> 73;
                    case 148 -> 59;
                    case 149 -> 207;
                    case 150 -> 89;
                    case 151 -> 114;
                    case 152 -> 121;
                    case 153 -> 222;
                    case 154 -> 254;
                    case 155 -> 60;
                    case 156 -> 238;
                    case 157 -> 184;
                    case 158 -> 103;
                    case 159 -> 41;
                    case 160 -> 186;
                    case 161 -> 33;
                    case 162 -> 253;
                    case 163 -> 242;
                    case 164 -> 216;
                    case 165 -> 168;
                    case 166 -> 124;
                    case 167 -> 106;
                    case 168 -> 22;
                    case 169 -> 190;
                    case 170 -> 92;
                    case 171 -> 14;
                    case 172 -> 154;
                    case 173 -> 110;
                    case 174 -> 137;
                    case 175 -> 177;
                    case 176 -> 129;
                    case 177 -> 223;
                    case 178 -> 225;
                    case 179 -> 140;
                    case 180 -> 161;
                    case 181 -> 240;
                    case 182 -> 160;
                    case 183 -> 57;
                    case 184 -> 13;
                    case 185 -> 209;
                    case 186 -> 243;
                    case 187 -> 155;
                    case 188 -> 68;
                    case 189 -> 143;
                    case 190 -> 125;
                    case 191 -> 19;
                    case 192 -> 62;
                    case 193 -> 170;
                    case 194 -> 45;
                    case 195 -> 237;
                    case 196 -> 46;
                    case 197 -> 12;
                    case 198 -> 228;
                    case 199 -> 202;
                    case 200 -> 136;
                    case 201 -> 5;
                    case 202 -> 236;
                    case 203 -> 235;
                    case 204 -> 201;
                    case 205 -> 182;
                    case 206 -> 151;
                    case 207 -> 204;
                    case 208 -> 0;
                    case 209 -> 213;
                    case 210 -> 104;
                    case 211 -> 27;
                    case 212 -> 47;
                    case 213 -> 65;
                    case 214 -> 206;
                    case 215 -> 212;
                    case 216 -> 88;
                    case 217 -> 174;
                    case 218 -> 66;
                    case 219 -> 99;
                    case 220 -> 175;
                    case 221 -> 1;
                    case 222 -> 166;
                    case 223 -> 56;
                    case 224 -> 51;
                    case 225 -> 116;
                    case 226 -> 6;
                    case 227 -> 2;
                    case 228 -> 127;
                    case 229 -> 21;
                    case 230 -> 208;
                    case 231 -> 144;
                    case 232 -> 163;
                    case 233 -> 55;
                    case 234 -> 122;
                    case 235 -> 24;
                    case 236 -> 48;
                    case 237 -> 81;
                    case 238 -> 78;
                    case 239 -> 248;
                    case 240 -> 172;
                    case 241 -> 234;
                    case 242 -> 15;
                    case 243 -> 16;
                    case 244 -> 98;
                    case 245 -> 192;
                    case 246 -> 38;
                    case 247 -> 40;
                    case 248 -> 25;
                    case 249 -> 199;
                    case 250 -> 147;
                    case 251 -> 86;
                    case 252 -> 153;
                    case 253 -> 101;
                    case 254 -> 211;
                    default -> 189;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 116690089954578L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u001b\u0014PHK:_B\t\u001c\u001eCB\u0006xB^X";
                    var5_4 = "\u001b\u0014PHK:_B\t\u001c\u001eCB\u0006xB^X".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 1;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 113;
                                    break;
                                }
                                case 1: {
                                    v11 = 112;
                                    break;
                                }
                                case 2: {
                                    v11 = 35;
                                    break;
                                }
                                case 3: {
                                    v11 = 39;
                                    break;
                                }
                                case 4: {
                                    v11 = 47;
                                    break;
                                }
                                case 5: {
                                    v11 = 87;
                                    break;
                                }
                                default: {
                                    v11 = 109;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 30703883611330L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "_ZCg\bF\b\u0004YDO}\nU[D}\u0004D\u0010\u007fZM\tU[D}\u0004D\u0010sP\rR]Yp\u000eI\nsW^z\u000f@";
                    var5_4 = "_ZCg\bF\b\u0004YDO}\nU[D}\u0004D\u0010\u007fZM\tU[D}\u0004D\u0010sP\rR]Yp\u000eI\nsW^z\u000f@".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 74;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "'*7\u0012z;q\u0006'*7\u0012v1";
                        var5_4 = "'*7\u0012z;q\u0006'*7\u0012v1".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 56;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 92;
                                break;
                            }
                            case 1: {
                                v15 = 126;
                                break;
                            }
                            case 2: {
                                v15 = 96;
                                break;
                            }
                            case 3: {
                                v15 = 89;
                                break;
                            }
                            case 4: {
                                v15 = 43;
                                break;
                            }
                            case 5: {
                                v15 = 109;
                                break;
                            }
                            default: {
                                v15 = 46;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 91230261997561L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-861654180 + -4319, 861654180 - 5267, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 100800172146179L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "4\"\u00e8\u008b\u0006\u0003\u00a9\u00fc\u00ef\u0005\u0004\u0006\u00c8\u00cb\u00e1\r\u008d\u0084\u00cf\u00d1\u00f4#G9%\u00cb\u00ab\u00b5\u00eb\u0010\u009a\u00d9\u00ea\u0091o\u00be\u001f\u00b7\u00e7\u009e\u0010Rzl\u0096\u00df\u0005\u0011_j\u00e0\u00b53\u001a5\u001a\u00da\u00a4\u0093V\u0006\u00b3U\u0011\u0002\u009c7f\u00ab\u00dc\u00c0`:\r\u00cf\u0012<\u008aq\u00aa\u0090\u001e\u00ef\u00ec\u009b\u00a4\u00a9\u001dc\u009e\u00a9~\u00d1\u00f2\u00c1\u000e7\u00c2v\u00ae>o\u0086\u00d9";
                    var4_3 = "4\"\u00e8\u008b\u0006\u0003\u00a9\u00fc\u00ef\u0005\u0004\u0006\u00c8\u00cb\u00e1\r\u008d\u0084\u00cf\u00d1\u00f4#G9%\u00cb\u00ab\u00b5\u00eb\u0010\u009a\u00d9\u00ea\u0091o\u00be\u001f\u00b7\u00e7\u009e\u0010Rzl\u0096\u00df\u0005\u0011_j\u00e0\u00b53\u001a5\u001a\u00da\u00a4\u0093V\u0006\u00b3U\u0011\u0002\u009c7f\u00ab\u00dc\u00c0`:\r\u00cf\u0012<\u008aq\u00aa\u0090\u001e\u00ef\u00ec\u009b\u00a4\u00a9\u001dc\u009e\u00a9~\u00d1\u00f2\u00c1\u000e7\u00c2v\u00ae>o\u0086\u00d9".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 83;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0080~\u0087K\u00ec\u00cbA7\u0002\u00a0\u0082\u00bb\u0006\u007f7\u0093LLa\u00e9b\u000b&\u00d3\u00e4\u00d9IU?\u00f2a:)|o\u00a5\u0017\u00f3 \u00c9M\u00fc\u009ao\u0005r:\u00a0`\u0013\u0016\u00b4\u00a6\u00b7\u00e1O\u0090\u00cc:(\u001b=\u0003\u00b4\u0086\u00f0\u008b\u00ec\u0086\u00dc\u00fehv\u00e1<\u00cb\u00c6K9\r\u008aB\u009d/\u00db\u00d7\u0006\u00c8\u0015\u00cd\u00d7\u009e\u0097";
                        var4_3 = "\u0080~\u0087K\u00ec\u00cbA7\u0002\u00a0\u0082\u00bb\u0006\u007f7\u0093LLa\u00e9b\u000b&\u00d3\u00e4\u00d9IU?\u00f2a:)|o\u00a5\u0017\u00f3 \u00c9M\u00fc\u009ao\u0005r:\u00a0`\u0013\u0016\u00b4\u00a6\u00b7\u00e1O\u0090\u00cc:(\u001b=\u0003\u00b4\u0086\u00f0\u008b\u00ec\u0086\u00dc\u00fehv\u00e1<\u00cb\u00c6K9\r\u008aB\u009d/\u00db\u00d7\u0006\u00c8\u0015\u00cd\u00d7\u009e\u0097".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 49;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 8;
                                break;
                            }
                            case 1: {
                                v15 = 107;
                                break;
                            }
                            case 2: {
                                v15 = 126;
                                break;
                            }
                            case 3: {
                                v15 = 126;
                                break;
                            }
                            case 4: {
                                v15 = 80;
                                break;
                            }
                            case 5: {
                                v15 = 105;
                                break;
                            }
                            default: {
                                v15 = 22;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCD84) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 71;
                    case 1 -> 37;
                    case 2 -> 51;
                    case 3 -> 177;
                    case 4 -> 11;
                    case 5 -> 213;
                    case 6 -> 90;
                    case 7 -> 135;
                    case 8 -> 228;
                    case 9 -> 169;
                    case 10 -> 156;
                    case 11 -> 174;
                    case 12 -> 17;
                    case 13 -> 222;
                    case 14 -> 189;
                    case 15 -> 100;
                    case 16 -> 212;
                    case 17 -> 55;
                    case 18 -> 67;
                    case 19 -> 182;
                    case 20 -> 14;
                    case 21 -> 122;
                    case 22 -> 50;
                    case 23 -> 176;
                    case 24 -> 254;
                    case 25 -> 107;
                    case 26 -> 81;
                    case 27 -> 103;
                    case 28 -> 31;
                    case 29 -> 184;
                    case 30 -> 74;
                    case 31 -> 251;
                    case 32 -> 117;
                    case 33 -> 194;
                    case 34 -> 35;
                    case 35 -> 143;
                    case 36 -> 92;
                    case 37 -> 91;
                    case 38 -> 155;
                    case 39 -> 127;
                    case 40 -> 99;
                    case 41 -> 152;
                    case 42 -> 3;
                    case 43 -> 125;
                    case 44 -> 158;
                    case 45 -> 223;
                    case 46 -> 157;
                    case 47 -> 64;
                    case 48 -> 73;
                    case 49 -> 186;
                    case 50 -> 70;
                    case 51 -> 183;
                    case 52 -> 249;
                    case 53 -> 195;
                    case 54 -> 167;
                    case 55 -> 30;
                    case 56 -> 94;
                    case 57 -> 88;
                    case 58 -> 219;
                    case 59 -> 150;
                    case 60 -> 38;
                    case 61 -> 165;
                    case 62 -> 49;
                    case 63 -> 240;
                    case 64 -> 98;
                    case 65 -> 211;
                    case 66 -> 27;
                    case 67 -> 199;
                    case 68 -> 148;
                    case 69 -> 138;
                    case 70 -> 245;
                    case 71 -> 18;
                    case 72 -> 216;
                    case 73 -> 234;
                    case 74 -> 56;
                    case 75 -> 23;
                    case 76 -> 108;
                    case 77 -> 247;
                    case 78 -> 227;
                    case 79 -> 36;
                    case 80 -> 248;
                    case 81 -> 48;
                    case 82 -> 4;
                    case 83 -> 142;
                    case 84 -> 121;
                    case 85 -> 154;
                    case 86 -> 224;
                    case 87 -> 171;
                    case 88 -> 144;
                    case 89 -> 118;
                    case 90 -> 173;
                    case 91 -> 76;
                    case 92 -> 203;
                    case 93 -> 9;
                    case 94 -> 136;
                    case 95 -> 32;
                    case 96 -> 205;
                    case 97 -> 106;
                    case 98 -> 40;
                    case 99 -> 217;
                    case 100 -> 210;
                    case 101 -> 180;
                    case 102 -> 190;
                    case 103 -> 196;
                    case 104 -> 85;
                    case 105 -> 28;
                    case 106 -> 52;
                    case 107 -> 238;
                    case 108 -> 192;
                    case 109 -> 105;
                    case 110 -> 172;
                    case 111 -> 218;
                    case 112 -> 244;
                    case 113 -> 97;
                    case 114 -> 243;
                    case 115 -> 232;
                    case 116 -> 233;
                    case 117 -> 200;
                    case 118 -> 201;
                    case 119 -> 179;
                    case 120 -> 168;
                    case 121 -> 53;
                    case 122 -> 59;
                    case 123 -> 187;
                    case 124 -> 246;
                    case 125 -> 161;
                    case 126 -> 39;
                    case 127 -> 29;
                    case 128 -> 34;
                    case 129 -> 8;
                    case 130 -> 43;
                    case 131 -> 149;
                    case 132 -> 68;
                    case 133 -> 214;
                    case 134 -> 109;
                    case 135 -> 230;
                    case 136 -> 0;
                    case 137 -> 133;
                    case 138 -> 79;
                    case 139 -> 22;
                    case 140 -> 145;
                    case 141 -> 139;
                    case 142 -> 126;
                    case 143 -> 226;
                    case 144 -> 235;
                    case 145 -> 153;
                    case 146 -> 191;
                    case 147 -> 225;
                    case 148 -> 72;
                    case 149 -> 231;
                    case 150 -> 178;
                    case 151 -> 75;
                    case 152 -> 120;
                    case 153 -> 1;
                    case 154 -> 116;
                    case 155 -> 95;
                    case 156 -> 60;
                    case 157 -> 115;
                    case 158 -> 102;
                    case 159 -> 93;
                    case 160 -> 220;
                    case 161 -> 63;
                    case 162 -> 104;
                    case 163 -> 113;
                    case 164 -> 82;
                    case 165 -> 185;
                    case 166 -> 16;
                    case 167 -> 147;
                    case 168 -> 239;
                    case 169 -> 24;
                    case 170 -> 131;
                    case 171 -> 25;
                    case 172 -> 101;
                    case 173 -> 206;
                    case 174 -> 146;
                    case 175 -> 221;
                    case 176 -> 41;
                    case 177 -> 129;
                    case 178 -> 46;
                    case 179 -> 236;
                    case 180 -> 123;
                    case 181 -> 61;
                    case 182 -> 2;
                    case 183 -> 130;
                    case 184 -> 170;
                    case 185 -> 65;
                    case 186 -> 128;
                    case 187 -> 253;
                    case 188 -> 87;
                    case 189 -> 13;
                    case 190 -> 12;
                    case 191 -> 89;
                    case 192 -> 6;
                    case 193 -> 20;
                    case 194 -> 80;
                    case 195 -> 69;
                    case 196 -> 10;
                    case 197 -> 193;
                    case 198 -> 66;
                    case 199 -> 114;
                    case 200 -> 242;
                    case 201 -> 54;
                    case 202 -> 202;
                    case 203 -> 19;
                    case 204 -> 252;
                    case 205 -> 44;
                    case 206 -> 255;
                    case 207 -> 112;
                    case 208 -> 119;
                    case 209 -> 188;
                    case 210 -> 86;
                    case 211 -> 15;
                    case 212 -> 208;
                    case 213 -> 140;
                    case 214 -> 77;
                    case 215 -> 96;
                    case 216 -> 160;
                    case 217 -> 204;
                    case 218 -> 151;
                    case 219 -> 111;
                    case 220 -> 137;
                    case 221 -> 181;
                    case 222 -> 166;
                    case 223 -> 162;
                    case 224 -> 209;
                    case 225 -> 215;
                    case 226 -> 26;
                    case 227 -> 58;
                    case 228 -> 175;
                    case 229 -> 164;
                    case 230 -> 124;
                    case 231 -> 110;
                    case 232 -> 62;
                    case 233 -> 7;
                    case 234 -> 33;
                    case 235 -> 198;
                    case 236 -> 78;
                    case 237 -> 45;
                    case 238 -> 241;
                    case 239 -> 159;
                    case 240 -> 21;
                    case 241 -> 197;
                    case 242 -> 229;
                    case 243 -> 207;
                    case 244 -> 5;
                    case 245 -> 163;
                    case 246 -> 141;
                    case 247 -> 57;
                    case 248 -> 134;
                    case 249 -> 47;
                    case 250 -> 83;
                    case 251 -> 84;
                    case 252 -> 237;
                    case 253 -> 132;
                    case 254 -> 42;
                    default -> 250;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 73319458007305L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(71302080 - 2771, -71302080 - -26304, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 94575728037977L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.G();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(548134740 + (char)-21912, 548134740 + (char)-10919, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 96170890603574L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00dfn:L\r\u0003\u0005z7";
                var4_3 = "\u00dfn:L\r\u0003\u0005z7".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 93;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 35;
                                break;
                            }
                            case 1: {
                                v11 = 109;
                                break;
                            }
                            case 2: {
                                v11 = 123;
                                break;
                            }
                            case 3: {
                                v11 = 63;
                                break;
                            }
                            case 4: {
                                v11 = 110;
                                break;
                            }
                            case 5: {
                                v11 = 76;
                                break;
                            }
                            default: {
                                v11 = 60;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x19E4) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 189;
                    case 1 -> 186;
                    case 2 -> 145;
                    case 3 -> 240;
                    case 4 -> 207;
                    case 5 -> 233;
                    case 6 -> 40;
                    case 7 -> 111;
                    case 8 -> 74;
                    case 9 -> 61;
                    case 10 -> 122;
                    case 11 -> 118;
                    case 12 -> 185;
                    case 13 -> 172;
                    case 14 -> 78;
                    case 15 -> 123;
                    case 16 -> 219;
                    case 17 -> 194;
                    case 18 -> 213;
                    case 19 -> 17;
                    case 20 -> 171;
                    case 21 -> 37;
                    case 22 -> 255;
                    case 23 -> 198;
                    case 24 -> 184;
                    case 25 -> 245;
                    case 26 -> 46;
                    case 27 -> 151;
                    case 28 -> 208;
                    case 29 -> 39;
                    case 30 -> 176;
                    case 31 -> 91;
                    case 32 -> 65;
                    case 33 -> 170;
                    case 34 -> 86;
                    case 35 -> 135;
                    case 36 -> 116;
                    case 37 -> 47;
                    case 38 -> 108;
                    case 39 -> 134;
                    case 40 -> 10;
                    case 41 -> 169;
                    case 42 -> 58;
                    case 43 -> 5;
                    case 44 -> 82;
                    case 45 -> 173;
                    case 46 -> 4;
                    case 47 -> 60;
                    case 48 -> 181;
                    case 49 -> 16;
                    case 50 -> 174;
                    case 51 -> 159;
                    case 52 -> 25;
                    case 53 -> 30;
                    case 54 -> 139;
                    case 55 -> 2;
                    case 56 -> 232;
                    case 57 -> 14;
                    case 58 -> 223;
                    case 59 -> 64;
                    case 60 -> 157;
                    case 61 -> 33;
                    case 62 -> 244;
                    case 63 -> 3;
                    case 64 -> 195;
                    case 65 -> 140;
                    case 66 -> 1;
                    case 67 -> 45;
                    case 68 -> 90;
                    case 69 -> 98;
                    case 70 -> 67;
                    case 71 -> 0;
                    case 72 -> 215;
                    case 73 -> 197;
                    case 74 -> 152;
                    case 75 -> 248;
                    case 76 -> 81;
                    case 77 -> 209;
                    case 78 -> 36;
                    case 79 -> 34;
                    case 80 -> 110;
                    case 81 -> 20;
                    case 82 -> 42;
                    case 83 -> 70;
                    case 84 -> 69;
                    case 85 -> 76;
                    case 86 -> 221;
                    case 87 -> 115;
                    case 88 -> 121;
                    case 89 -> 6;
                    case 90 -> 7;
                    case 91 -> 117;
                    case 92 -> 54;
                    case 93 -> 95;
                    case 94 -> 133;
                    case 95 -> 124;
                    case 96 -> 137;
                    case 97 -> 187;
                    case 98 -> 250;
                    case 99 -> 162;
                    case 100 -> 103;
                    case 101 -> 237;
                    case 102 -> 8;
                    case 103 -> 27;
                    case 104 -> 205;
                    case 105 -> 107;
                    case 106 -> 225;
                    case 107 -> 88;
                    case 108 -> 24;
                    case 109 -> 144;
                    case 110 -> 147;
                    case 111 -> 56;
                    case 112 -> 87;
                    case 113 -> 234;
                    case 114 -> 188;
                    case 115 -> 203;
                    case 116 -> 52;
                    case 117 -> 38;
                    case 118 -> 100;
                    case 119 -> 31;
                    case 120 -> 32;
                    case 121 -> 97;
                    case 122 -> 53;
                    case 123 -> 236;
                    case 124 -> 231;
                    case 125 -> 212;
                    case 126 -> 224;
                    case 127 -> 12;
                    case 128 -> 150;
                    case 129 -> 11;
                    case 130 -> 28;
                    case 131 -> 251;
                    case 132 -> 180;
                    case 133 -> 178;
                    case 134 -> 66;
                    case 135 -> 127;
                    case 136 -> 84;
                    case 137 -> 62;
                    case 138 -> 80;
                    case 139 -> 156;
                    case 140 -> 193;
                    case 141 -> 216;
                    case 142 -> 148;
                    case 143 -> 168;
                    case 144 -> 120;
                    case 145 -> 48;
                    case 146 -> 175;
                    case 147 -> 26;
                    case 148 -> 23;
                    case 149 -> 79;
                    case 150 -> 214;
                    case 151 -> 242;
                    case 152 -> 119;
                    case 153 -> 167;
                    case 154 -> 19;
                    case 155 -> 131;
                    case 156 -> 49;
                    case 157 -> 92;
                    case 158 -> 177;
                    case 159 -> 235;
                    case 160 -> 154;
                    case 161 -> 73;
                    case 162 -> 199;
                    case 163 -> 85;
                    case 164 -> 211;
                    case 165 -> 239;
                    case 166 -> 165;
                    case 167 -> 227;
                    case 168 -> 29;
                    case 169 -> 179;
                    case 170 -> 13;
                    case 171 -> 106;
                    case 172 -> 101;
                    case 173 -> 55;
                    case 174 -> 204;
                    case 175 -> 247;
                    case 176 -> 149;
                    case 177 -> 15;
                    case 178 -> 190;
                    case 179 -> 68;
                    case 180 -> 57;
                    case 181 -> 63;
                    case 182 -> 129;
                    case 183 -> 222;
                    case 184 -> 192;
                    case 185 -> 243;
                    case 186 -> 191;
                    case 187 -> 138;
                    case 188 -> 18;
                    case 189 -> 164;
                    case 190 -> 210;
                    case 191 -> 136;
                    case 192 -> 114;
                    case 193 -> 220;
                    case 194 -> 50;
                    case 195 -> 153;
                    case 196 -> 200;
                    case 197 -> 109;
                    case 198 -> 158;
                    case 199 -> 142;
                    case 200 -> 230;
                    case 201 -> 51;
                    case 202 -> 166;
                    case 203 -> 59;
                    case 204 -> 99;
                    case 205 -> 71;
                    case 206 -> 246;
                    case 207 -> 196;
                    case 208 -> 96;
                    case 209 -> 22;
                    case 210 -> 226;
                    case 211 -> 126;
                    case 212 -> 238;
                    case 213 -> 146;
                    case 214 -> 77;
                    case 215 -> 160;
                    case 216 -> 93;
                    case 217 -> 161;
                    case 218 -> 183;
                    case 219 -> 112;
                    case 220 -> 254;
                    case 221 -> 41;
                    case 222 -> 182;
                    case 223 -> 202;
                    case 224 -> 130;
                    case 225 -> 104;
                    case 226 -> 94;
                    case 227 -> 102;
                    case 228 -> 125;
                    case 229 -> 201;
                    case 230 -> 132;
                    case 231 -> 83;
                    case 232 -> 217;
                    case 233 -> 113;
                    case 234 -> 89;
                    case 235 -> 44;
                    case 236 -> 128;
                    case 237 -> 229;
                    case 238 -> 9;
                    case 239 -> 143;
                    case 240 -> 228;
                    case 241 -> 241;
                    case 242 -> 218;
                    case 243 -> 105;
                    case 244 -> 35;
                    case 245 -> 249;
                    case 246 -> 21;
                    case 247 -> 141;
                    case 248 -> 75;
                    case 249 -> 253;
                    case 250 -> 163;
                    case 251 -> 206;
                    case 252 -> 155;
                    case 253 -> 252;
                    case 254 -> 72;
                    default -> 43;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

