/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.devcontainers.cli;

import com.intellij.clouds.docker.devcontainers.cli.BuildDevcontainerCommand;
import com.intellij.clouds.docker.devcontainers.cli.logging.SLF4JServiceProviderImplKt;
import com.intellij.clouds.docker.devcontainers.cli.output.OutputStrategy;
import com.intellij.clouds.docker.devcontainers.cli.output.json.JsonOutputStrategy;
import com.intellij.clouds.docker.devcontainers.cli.output.text.TextOutputStrategy;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/clouds/docker/devcontainers/cli/Main;", "", "<init>", "()V", "USAGE_SYNTAX_PREFIX", "", "USAGE_SYNTAX", "USAGE_HEADER", "OPTION_CONFIG", "OPTION_CONFIG_LONG", "OPTION_FORMAT_LONG", "OUTPUT_FORMAT_VALUE_JSON", "OUTPUT_FORMAT_VALUE_TEXT", "EXIT_STATUS_USAGE_ERROR", "", "OUTPUT_FORMAT_STRATEGIES", "", "Lcom/intellij/clouds/docker/devcontainers/cli/output/OutputStrategy;", "main", "", "args", "", "([Ljava/lang/String;)V", "printUsages", "options", "Lorg/apache/commons/cli/Options;", "outputStream", "Ljava/io/OutputStream;", "intellij.clouds.docker.devcontainers.cli"})
public final class Main {
    @NotNull
    public static final Main INSTANCE = new Main();
    @NotNull
    private static final String USAGE_SYNTAX_PREFIX = "Usage: ";
    @NotNull
    private static final String USAGE_SYNTAX = "devc [OPTIONS] SOURCE";
    @NotNull
    private static final String USAGE_HEADER = "\nCreate Dev Container from local sources\n\nOptions:";
    @NotNull
    private static final String OPTION_CONFIG = "c";
    @NotNull
    private static final String OPTION_CONFIG_LONG = "config";
    @NotNull
    private static final String OPTION_FORMAT_LONG = "format";
    @NotNull
    private static final String OUTPUT_FORMAT_VALUE_JSON = "json";
    @NotNull
    private static final String OUTPUT_FORMAT_VALUE_TEXT = "text";
    private static final int EXIT_STATUS_USAGE_ERROR = 64;
    @NotNull
    private static final Map<String, OutputStrategy> OUTPUT_FORMAT_STRATEGIES;

    private Main() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Options options = new Options().addOption(Option.builder().option(OPTION_CONFIG).longOpt(OPTION_CONFIG_LONG).hasArg(true).desc("Explicitly define path to a devcontainer.json. The path is either absolute or relative to the source argument.").optionalArg(true).build()).addOption(Option.builder().longOpt(OPTION_FORMAT_LONG).hasArg(true).desc("Set the output format. Supported output formats: " + CollectionsKt.joinToString$default((Iterable)OUTPUT_FORMAT_STRATEGIES.keySet(), null, null, null, (int)0, null, null, (int)63, null) + ".").optionalArg(true).build());
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"addOption(...)");
        Options options2 = options;
        DefaultParser commandLineParser = new DefaultParser();
        try {
            CommandLine commandLine = commandLineParser.parse(options2, args);
            String[] stringArray = commandLine.getArgs();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getArgs(...)");
            String string = (String)ArraysKt.firstOrNull((Object[])stringArray);
            if (string == null) {
                throw new ParseException("Path to directory is missing");
            }
            String path = string;
            String format = commandLine.getOptionValue(OPTION_FORMAT_LONG);
            String string2 = format;
            if (string2 == null) {
                string2 = OUTPUT_FORMAT_VALUE_TEXT;
            }
            OutputStrategy outputStrategy = OUTPUT_FORMAT_STRATEGIES.get(string2);
            if (outputStrategy == null) {
                throw new ParseException("Unsupported output format " + format);
            }
            OutputStrategy outputStrategy2 = outputStrategy;
            SLF4JServiceProviderImplKt.initializeLogging(outputStrategy2.getLoggerFactory());
            new BuildDevcontainerCommand(path, commandLine.getOptionValue(OPTION_CONFIG_LONG), outputStrategy2.getEventLogger()).run();
        }
        catch (ParseException parseException) {
            PrintStream printStream = System.err;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
            INSTANCE.printUsages(options2, printStream);
            System.exit(64);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void printUsages(Options options, OutputStream outputStream) {
        HelpFormatter.Builder builder;
        HelpFormatter.Builder $this$printUsages_u24lambda_u240 = builder = HelpFormatter.builder();
        boolean bl = false;
        $this$printUsages_u24lambda_u240.setPrintWriter(new PrintWriter(outputStream));
        HelpFormatter.Builder $this$printUsages_u24lambda_u241 = builder = builder.get();
        boolean bl2 = false;
        $this$printUsages_u24lambda_u241.setSyntaxPrefix(USAGE_SYNTAX_PREFIX);
        builder.printHelp(USAGE_SYNTAX, USAGE_HEADER, options, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)OUTPUT_FORMAT_VALUE_JSON, (Object)JsonOutputStrategy.INSTANCE), TuplesKt.to((Object)OUTPUT_FORMAT_VALUE_TEXT, (Object)TextOutputStrategy.INSTANCE)};
        OUTPUT_FORMAT_STRATEGIES = MapsKt.mapOf((Pair[])pairArray);
    }
}

