/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.services.formatting;

import com.intellij.openapi.util.TextRange;
import com.jetbrains.rider.model.FormatterOperation;
import com.jetbrains.rider.razor.services.formatting.FormatterOperationWithRange;
import com.jetbrains.rider.razor.services.formatting.RiderIndentRegion;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/razor/services/formatting/RiderFormattingNode;", "Lcom/jetbrains/rider/model/FormatterOperation;", "range", "Lcom/intellij/openapi/util/TextRange;", "elements", "", "Lcom/jetbrains/rider/razor/services/formatting/FormatterOperationWithRange;", "<init>", "(Lcom/intellij/openapi/util/TextRange;Ljava/util/List;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getElements", "()Ljava/util/List;", "findByRange", "Lkotlin/Triple;", "", "intellij.rider.plugins.razor"})
public class RiderFormattingNode
extends FormatterOperation {
    @NotNull
    private final TextRange range;
    @NotNull
    private final List<FormatterOperationWithRange> elements;

    public RiderFormattingNode(@NotNull TextRange range, @NotNull List<FormatterOperationWithRange> elements) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.range = range;
        this.elements = elements;
    }

    @NotNull
    public final TextRange getRange() {
        return this.range;
    }

    @NotNull
    public final List<FormatterOperationWithRange> getElements() {
        return this.elements;
    }

    @NotNull
    public final Triple<RiderFormattingNode, Integer, Integer> findByRange(@NotNull TextRange range) {
        FormatterOperationWithRange op;
        FormatterOperation operation;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (!this.range.contains(range)) {
            return new Triple((Object)this, (Object)0, (Object)CollectionsKt.getLastIndex(this.elements));
        }
        int startIndex = CollectionsKt.binarySearch$default(this.elements, (int)0, (int)0, arg_0 -> RiderFormattingNode.findByRange$lambda$0(range, arg_0), (int)3, null);
        if (startIndex >= 0 && (operation = (op = this.elements.get(startIndex)).getOperation()) instanceof RiderIndentRegion && op.getRange().contains(range)) {
            return ((RiderIndentRegion)operation).findByRange(range);
        }
        startIndex = startIndex < 0 ? -(startIndex + 1) : startIndex;
        int endIndex = CollectionsKt.binarySearch$default(this.elements, (int)0, (int)0, arg_0 -> RiderFormattingNode.findByRange$lambda$1(range, arg_0), (int)3, null);
        endIndex = endIndex < 0 ? -(endIndex + 1) - 1 : endIndex;
        return new Triple((Object)this, (Object)startIndex, (Object)endIndex);
    }

    private static final int findByRange$lambda$0(TextRange $range, FormatterOperationWithRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRange().getEndOffset() <= $range.getStartOffset() ? -1 : (it.getRange().getStartOffset() > $range.getStartOffset() ? 1 : 0);
    }

    private static final int findByRange$lambda$1(TextRange $range, FormatterOperationWithRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRange().getEndOffset() <= $range.getEndOffset() ? -1 : (it.getRange().getStartOffset() >= $range.getEndOffset() ? 1 : 0);
    }
}

