/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.services.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.jetbrains.rider.model.ChangeInfo;
import com.jetbrains.rider.model.RdLineBreakChangeInfo;
import com.jetbrains.rider.model.RdWhitespaceChangeInfo;
import com.jetbrains.rider.razor.services.formatting.RazorTemplateBlock;
import com.jetbrains.rider.razor.services.formatting.RiderBlock;
import com.jetbrains.rider.razor.services.formatting.RiderSyntheticBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0003H\u0000\u001a\f\u0010\b\u001a\u00020\u0007*\u00020\u0003H\u0000\u001a\u000e\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u000bH\u0000\u001a\u001c\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0000\u00a8\u0006\u000f"}, d2={"getRiderSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "Lcom/intellij/formatting/Block;", "child2", "baseSpacing", "getFirstNode", "Lcom/intellij/lang/ASTNode;", "getLastNode", "isEmpty", "", "Lcom/intellij/formatting/Indent;", "areEqual", "indent1", "indent2", "intellij.rider.plugins.razor"})
public final class RiderFormatUtilsKt {
    @Nullable
    public static final Spacing getRiderSpacing(@Nullable Block child1, @NotNull Block child2, @Nullable Spacing baseSpacing) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        if (child2 instanceof RiderBlock) {
            ChangeInfo changeInfo = ((RiderBlock)child2).getResharperChangeInfo();
            if (changeInfo instanceof RdWhitespaceChangeInfo) {
                return Spacing.createSpacing((int)((RdWhitespaceChangeInfo)changeInfo).getWhitespace().getSpaces(), (int)((RdWhitespaceChangeInfo)changeInfo).getWhitespace().getSpaces(), (int)0, (boolean)false, (int)0);
            }
            if (changeInfo instanceof RdLineBreakChangeInfo) {
                return Spacing.createSpacing((int)0, (int)0, (int)((RdLineBreakChangeInfo)changeInfo).getLineBreaksNumber(), (boolean)false, (int)0);
            }
        }
        if ((child1 instanceof RiderSyntheticBlock || child1 instanceof RazorTemplateBlock) && (child2 instanceof RiderSyntheticBlock || child2 instanceof RazorTemplateBlock)) {
            return null;
        }
        return baseSpacing;
    }

    @NotNull
    public static final ASTNode getFirstNode(@NotNull Block $this$getFirstNode) {
        Intrinsics.checkNotNullParameter((Object)$this$getFirstNode, (String)"<this>");
        AbstractBlock abstractBlock = $this$getFirstNode instanceof AbstractBlock ? (AbstractBlock)$this$getFirstNode : null;
        if (abstractBlock == null || (abstractBlock = abstractBlock.getNode()) == null) {
            List list = $this$getFirstNode.getSubBlocks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSubBlocks(...)");
            Object object = CollectionsKt.first((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            abstractBlock = RiderFormatUtilsKt.getFirstNode((Block)object);
        }
        return abstractBlock;
    }

    @NotNull
    public static final ASTNode getLastNode(@NotNull Block $this$getLastNode) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastNode, (String)"<this>");
        AbstractBlock abstractBlock = $this$getLastNode instanceof AbstractBlock ? (AbstractBlock)$this$getLastNode : null;
        if (abstractBlock == null || (abstractBlock = abstractBlock.getNode()) == null) {
            List list = $this$getLastNode.getSubBlocks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSubBlocks(...)");
            Object object = CollectionsKt.last((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
            abstractBlock = RiderFormatUtilsKt.getLastNode((Block)object);
        }
        return abstractBlock;
    }

    public static final boolean isEmpty(@Nullable Indent $this$isEmpty) {
        return $this$isEmpty == null || Intrinsics.areEqual((Object)$this$isEmpty.getType(), (Object)Indent.Type.NONE) && $this$isEmpty instanceof IndentImpl && !((IndentImpl)$this$isEmpty).isAbsolute() && !((IndentImpl)$this$isEmpty).isRelativeToDirectParent() && !((IndentImpl)$this$isEmpty).isEnforceChildrenToBeRelativeToMe();
    }

    public static final boolean areEqual(@Nullable Indent indent1, @Nullable Indent indent2) {
        return indent1 == null && indent2 == null || indent1 instanceof IndentImpl && indent2 instanceof IndentImpl && Intrinsics.areEqual((Object)((IndentImpl)indent1).getType(), (Object)((IndentImpl)indent2).getType()) && ((IndentImpl)indent1).getSpaces() == ((IndentImpl)indent2).getSpaces() && ((IndentImpl)indent1).isAbsolute() == ((IndentImpl)indent2).isAbsolute() && ((IndentImpl)indent1).isRelativeToDirectParent() == ((IndentImpl)indent2).isRelativeToDirectParent() && ((IndentImpl)indent1).isEnforceIndentToChildren() == ((IndentImpl)indent2).isEnforceIndentToChildren() && ((IndentImpl)indent1).isEnforceChildrenToBeRelativeToMe() == ((IndentImpl)indent2).isEnforceChildrenToBeRelativeToMe();
    }
}

