/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.razor.psi.RazorFileElementTypes;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0014J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0004H\u0014R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0013j\b\u0012\u0004\u0012\u00020\n`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/razor/psi/RazorFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "manager", "Lcom/intellij/psi/PsiManager;", "physical", "", "language", "Lcom/intellij/lang/Language;", "templateLanguage", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/PsiManager;ZLcom/intellij/lang/Language;Lcom/intellij/lang/Language;)V", "_baseLanguage", "getBaseLanguage", "_templateDataLanguage", "getTemplateDataLanguage", "_languages", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getLanguages", "", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "cloneInner", "fileCopy", "intellij.rider.plugins.razor"})
public class RazorFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final Language _baseLanguage;
    @NotNull
    private final Language _templateDataLanguage;
    @NotNull
    private final HashSet<Language> _languages;

    public RazorFileViewProvider(@NotNull VirtualFile file, @NotNull PsiManager manager, boolean physical, @NotNull Language language, @NotNull Language templateLanguage) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)templateLanguage, (String)"templateLanguage");
        super(manager, file, physical);
        this._baseLanguage = language;
        this._templateDataLanguage = templateLanguage;
        Object[] objectArray = new Language[]{this._baseLanguage, this._templateDataLanguage, CSharpLanguage.INSTANCE};
        this._languages = SetsKt.hashSetOf((Object[])objectArray);
    }

    @NotNull
    public Language getBaseLanguage() {
        return this._baseLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        return this._templateDataLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        return this._languages;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        if (lang == this.getTemplateDataLanguage()) {
            Object object = LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            Intrinsics.checkNotNull((Object)object);
            PsiFile psiFile = ((ParserDefinition)object).createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl file = (PsiFileImpl)psiFile;
            file.setContentElementType((IElementType)RazorFileElementTypes.RAZOR_TEMPLATE_DATA);
            return (PsiFile)file;
        }
        if (Intrinsics.areEqual((Object)lang, (Object)CSharpLanguage.INSTANCE)) {
            Object object = LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            Intrinsics.checkNotNull((Object)object);
            PsiFile psiFile = ((ParserDefinition)object).createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl file = (PsiFileImpl)psiFile;
            file.setContentElementType((IElementType)RazorFileElementTypes.RAZOR_CODE_DATA);
            return (PsiFile)file;
        }
        if (lang.isKindOf(this.getBaseLanguage())) {
            Object object = LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            Intrinsics.checkNotNull((Object)object);
            return ((ParserDefinition)object).createFile((FileViewProvider)this);
        }
        return null;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        return new RazorFileViewProvider(fileCopy, (PsiManager)psiManagerEx, false, this.getBaseLanguage(), this.getTemplateDataLanguage());
    }
}

