/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.jsdebugger.blazor.wasm.wip;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.wip.BlazorWasmWipLogger;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.protocol.CommandResponse;
import org.jetbrains.wip.protocol.Event;
import org.jetbrains.wip.protocol.IncomingMessage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B.\u0012%\u0010\u0002\u001a!\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\u00020\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\rH\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/wip/TrackableWipCommandProcessor;", "Lorg/jetbrains/wip/WipCommandProcessor;", "writer", "Lkotlin/Function1;", "Lorg/jetbrains/jsonProtocol/Request;", "Lkotlin/ParameterName;", "name", "message", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "messageIdToMethodName", "", "", "", "readResult", "RESULT", "readMethodName", "successResponse", "Lorg/jetbrains/wip/protocol/CommandResponse;", "(Ljava/lang/String;Lorg/jetbrains/wip/protocol/CommandResponse;)Ljava/lang/Object;", "write", "acceptNonSequence", "", "incoming", "Lorg/jetbrains/wip/protocol/IncomingMessage;", "readIfHasSequence", "trackMessage", "id", "methodName", "releaseMessage", "getMethodName", "Companion", "intellij.rider.plugins.razor.jsdebugger"})
public class TrackableWipCommandProcessor
extends WipCommandProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Integer, String> messageIdToMethodName;
    @NotNull
    private static final ObjectMapper json = ExtensionsKt.jacksonObjectMapper();
    @NotNull
    private static final BlazorWasmWipLogger logger = BlazorWasmWipLogger.Companion.getInstance();

    public TrackableWipCommandProcessor(@NotNull Function1<? super Request<?>, Boolean> writer) {
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        super(writer);
        this.messageIdToMethodName = new LinkedHashMap();
    }

    @Nullable
    public <RESULT> RESULT readResult(@NotNull String readMethodName, @NotNull CommandResponse successResponse) {
        Intrinsics.checkNotNullParameter((Object)readMethodName, (String)"readMethodName");
        Intrinsics.checkNotNullParameter((Object)successResponse, (String)"successResponse");
        Object object = successResponse.result();
        if (object == null || (object = object.getSourceSequence()) == null || (object = object.toString()) == null) {
            object = "{}";
        }
        Object messageRaw = object;
        JsonNode messageJson = json.readTree((String)messageRaw);
        JsonNode jsonNode = messageJson.get("id");
        int id = jsonNode != null ? jsonNode.intValue() : -1;
        Object object2 = messageJson.get("result");
        if (object2 == null || (object2 = object2.toString()) == null) {
            object2 = "{}";
        }
        logger.logResultResponseMessage(id, readMethodName, (String)object2);
        this.releaseMessage(id);
        return (RESULT)super.readResult(readMethodName, successResponse);
    }

    public boolean write(@NotNull Request<?> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        String methodName = message.getMethodName();
        JsonNode messageJson = json.readTree(message.getBuffer().toString(Charsets.UTF_8));
        JsonNode jsonNode = messageJson.get("id");
        int id = jsonNode != null ? jsonNode.intValue() : -1;
        Object object = messageJson.get("params");
        if (object == null || (object = object.toString()) == null) {
            object = "{}";
        }
        logger.logRequestMessage(id, methodName, (String)object);
        boolean success = false;
        try {
            success = super.write(message);
            if (success) {
                this.trackMessage(id, methodName);
            }
        }
        catch (Throwable e) {
            this.releaseMessage(id);
        }
        return success;
    }

    public void acceptNonSequence(@NotNull IncomingMessage incoming) {
        JsonNode messageJson;
        Object object;
        Intrinsics.checkNotNullParameter((Object)incoming, (String)"incoming");
        Event notification = incoming.asNotification();
        String methodName = notification.method();
        Object object2 = notification.params();
        if (object2 == null || (object2 = object2.getSourceSequence()) == null || (object2 = object2.toString()) == null) {
            object2 = "{}";
        }
        if ((object = (messageJson = json.readTree((String)object2)).get("params")) == null || (object = object.toString()) == null) {
            object = "{}";
        }
        logger.logEventMessage(methodName, (String)object);
        super.acceptNonSequence(incoming);
    }

    @Nullable
    public CommandResponse readIfHasSequence(@NotNull IncomingMessage incoming) {
        Intrinsics.checkNotNullParameter((Object)incoming, (String)"incoming");
        CommandResponse commandResponse = super.readIfHasSequence(incoming);
        if (commandResponse == null) {
            return null;
        }
        CommandResponse response = commandResponse;
        CommandResponse.ErrorInfo error = response.error();
        if (error != null) {
            int id = incoming.id();
            String methodName = this.getMethodName(incoming.id());
            logger.logErrorResponseMessage(id, methodName, error);
            this.releaseMessage(id);
        }
        return response;
    }

    private final String trackMessage(int id, String methodName) {
        return this.messageIdToMethodName.put(id, methodName);
    }

    private final String releaseMessage(int id) {
        return this.messageIdToMethodName.remove(id);
    }

    private final String getMethodName(int id) {
        return this.messageIdToMethodName.getOrDefault(id, "");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/wip/TrackableWipCommandProcessor$Companion;", "", "<init>", "()V", "json", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "logger", "Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/wip/BlazorWasmWipLogger;", "intellij.rider.plugins.razor.jsdebugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

