/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.jsdebugger.blazor.wasm.pipeline;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JSDebugTabLayouter;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.ui.content.Content;
import com.intellij.util.ApplicationKt;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.rider.debugger.wasm.splash.SplashScreenPageManager;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.BlazorWasmDebugProcess;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.browser.BlazorWasmBrowserUtil;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.browser.BrowserSessionInfo;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.pipeline.BlazorWASMAppVersion;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.pipeline.BlazorWasmDebugInfo;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.stateMachine.BlazorWasmDebugState;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.stateMachine.BlazorWasmDebugStateNotifier;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.wip.BlazorWasmWipLogger;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.wip.connection.DotNet3WasmWipVmConnection;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.wip.connection.DotNetWasmWipVmConnection;
import com.jetbrains.rider.run.ProcessTerminationUtil;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfiguration;
import icons.RiderIcons;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.page.PageKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J>\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/pipeline/BlazorWasmDebugProcessProvider;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "blazorWipLogger", "Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/wip/BlazorWasmWipLogger;", "createStandaloneProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "launchSettingsConfiguration", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsConfiguration;", "debugInfo", "Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/pipeline/BlazorWasmDebugInfo;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "notifier", "Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/stateMachine/BlazorWasmDebugStateNotifier;", "createHostedProcess", "createDebugProcess", "connectionErrorHandler", "Lkotlin/Function1;", "", "", "createConnection", "Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/wip/connection/DotNetWasmWipVmConnection;", "project", "Lcom/intellij/openapi/project/Project;", "notifySessionStarting", "dotnetProjectPath", "", "intellij.rider.plugins.razor.jsdebugger"})
public final class BlazorWasmDebugProcessProvider {
    @NotNull
    public static final BlazorWasmDebugProcessProvider INSTANCE = new BlazorWasmDebugProcessProvider();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final BlazorWasmWipLogger blazorWipLogger;

    private BlazorWasmDebugProcessProvider() {
    }

    @NotNull
    public final XDebugProcess createStandaloneProcess(@NotNull LaunchSettingsConfiguration launchSettingsConfiguration, @NotNull BlazorWasmDebugInfo debugInfo, @NotNull XDebugSession session, @NotNull BlazorWasmDebugStateNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)launchSettingsConfiguration, (String)"launchSettingsConfiguration");
        Intrinsics.checkNotNullParameter((Object)debugInfo, (String)"debugInfo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        session.addSessionListener(new XDebugSessionListener(debugInfo){
            final /* synthetic */ BlazorWasmDebugInfo $debugInfo;
            {
                this.$debugInfo = $debugInfo;
            }

            public void sessionStopped() {
                ProcessHandler processHandler2 = this.$debugInfo.getDotnetHostProcessExecutionResult().getProcessHandler();
                Intrinsics.checkNotNullExpressionValue((Object)processHandler2, (String)"getProcessHandler(...)");
                ProcessTerminationUtil.INSTANCE.terminateProcessAndDescendants(processHandler2);
            }
        });
        return this.createDebugProcess(launchSettingsConfiguration, debugInfo, session, notifier, (Function1<? super Throwable, Unit>)((Function1)arg_0 -> BlazorWasmDebugProcessProvider.createStandaloneProcess$lambda$0(debugInfo, arg_0)));
    }

    @NotNull
    public final XDebugProcess createHostedProcess(@NotNull LaunchSettingsConfiguration launchSettingsConfiguration, @NotNull BlazorWasmDebugInfo debugInfo, @NotNull XDebugSession session, @NotNull BlazorWasmDebugStateNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)launchSettingsConfiguration, (String)"launchSettingsConfiguration");
        Intrinsics.checkNotNullParameter((Object)debugInfo, (String)"debugInfo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        return BlazorWasmDebugProcessProvider.createDebugProcess$default(this, launchSettingsConfiguration, debugInfo, session, notifier, null, 16, null);
    }

    private final XDebugProcess createDebugProcess(LaunchSettingsConfiguration launchSettingsConfiguration, BlazorWasmDebugInfo debugInfo, XDebugSession session, BlazorWasmDebugStateNotifier notifier, Function1<? super Throwable, Unit> connectionErrorHandler) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        BlazorWasmDebugStateNotifier.notify$default(notifier, BlazorWasmDebugState.DEBUG_SESSION_CREATED, null, 2, null);
        this.notifySessionStarting(launchSettingsConfiguration.getProjectFilePath());
        BrowserSessionInfo browserSessionInfo = debugInfo.getBrowserSessionInfo();
        int proxyPort = browserSessionInfo.component2();
        ProcessHandler browserProcessHandler = browserSessionInfo.component3();
        Project project = launchSettingsConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DotNetWasmWipVmConnection connection = this.createConnection(project, debugInfo, session, notifier);
        RemoteDebuggingFileFinder finder = new RemoteDebuggingFileFinder(null, (DebuggableFileFinder)new LocalFileSystemFileFinder(), 1, null);
        BlazorWasmDebugProcess debugProcess = new BlazorWasmDebugProcess(session, (DebuggableFileFinder)finder, (VmConnection<WipVm>)((VmConnection)connection), notifier);
        ExecutionResult dotnetProcess = debugInfo.getDotnetHostProcessExecutionResult();
        ExecutionConsole executionConsole = dotnetProcess.getExecutionConsole();
        if (executionConsole == null) {
            executionConsole = (ExecutionConsole)new TerminalExecutionConsole(launchSettingsConfiguration.getProject(), dotnetProcess.getProcessHandler());
        }
        ExecutionConsole consoleView = executionConsole;
        Disposer.register((Disposable)((Disposable)debugProcess), (Disposable)((Disposable)consoleView));
        session.addSessionListener(new XDebugSessionListener(browserProcessHandler){
            final /* synthetic */ ProcessHandler $browserProcessHandler;
            {
                this.$browserProcessHandler = $browserProcessHandler;
            }

            public void sessionStopped() {
                BlazorWasmDebugProcessProvider.access$getLogger$p().info("session stopped");
                if (ApplicationKt.getApplication().isUnitTestMode()) {
                    BlazorWasmDebugProcessProvider.access$getLogger$p().info("killing browser process");
                    ProcessTerminationUtil.INSTANCE.terminateProcessAndDescendants(this.$browserProcessHandler);
                }
            }
        });
        debugProcess.setLayouter((XDebugTabLayouter)new JSDebugTabLayouter(debugProcess, consoleView){
            final /* synthetic */ ExecutionConsole $consoleView;
            {
                this.$consoleView = $consoleView;
                super((JavaScriptDebugProcess)$debugProcess);
            }

            public void registerAdditionalContent(RunnerLayoutUi ui) {
                Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
                Content content = ui.createContent("ConsoleContent", this.$consoleView.getComponent(), "DevServer", RiderIcons.Templates.TemplateConsoleApp, this.$consoleView.getPreferredFocusableComponent());
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
                Content content2 = content;
                content2.setCloseable(false);
                RunContentBuilder.addAdditionalConsoleEditorActions((ExecutionConsole)this.$consoleView, (Content)content2);
                ui.addContent(content2);
                Disposer.register((Disposable)((Disposable)content2), (Disposable)((Disposable)this.$consoleView));
            }
        });
        BlazorWasmDebugStateNotifier.notify$default(notifier, BlazorWasmDebugState.BEFORE_CONNECTION_OPEN, null, 2, null);
        RemoteVmConnection.open$default((RemoteVmConnection)((RemoteVmConnection)connection), (InetSocketAddress)new InetSocketAddress(InetAddress.getLoopbackAddress(), proxyPort), null, (int)2, null).onSuccess(arg_0 -> BlazorWasmDebugProcessProvider.createDebugProcess$lambda$3(arg_0 -> BlazorWasmDebugProcessProvider.createDebugProcess$lambda$2(launchSettingsConfiguration, arg_0), arg_0)).onError(arg_0 -> BlazorWasmDebugProcessProvider.createDebugProcess$lambda$5(arg_0 -> BlazorWasmDebugProcessProvider.createDebugProcess$lambda$4(connectionErrorHandler, notifier, arg_0), arg_0));
        BlazorWasmDebugStateNotifier.notify$default(notifier, BlazorWasmDebugState.BEFORE_START_NOTIFY_DEBUG_PROCESS, null, 2, null);
        if (!dotnetProcess.getProcessHandler().isStartNotified()) {
            dotnetProcess.getProcessHandler().startNotify();
        }
        BlazorWasmDebugStateNotifier.notify$default(notifier, BlazorWasmDebugState.DEBUG_PROCESS_CREATED, null, 2, null);
        return (XDebugProcess)debugProcess;
    }

    static /* synthetic */ XDebugProcess createDebugProcess$default(BlazorWasmDebugProcessProvider blazorWasmDebugProcessProvider, LaunchSettingsConfiguration launchSettingsConfiguration, BlazorWasmDebugInfo blazorWasmDebugInfo, XDebugSession xDebugSession, BlazorWasmDebugStateNotifier blazorWasmDebugStateNotifier, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = BlazorWasmDebugProcessProvider::createDebugProcess$lambda$1;
        }
        return blazorWasmDebugProcessProvider.createDebugProcess(launchSettingsConfiguration, blazorWasmDebugInfo, xDebugSession, blazorWasmDebugStateNotifier, (Function1<? super Throwable, Unit>)function1);
    }

    private final DotNetWasmWipVmConnection createConnection(Project project, BlazorWasmDebugInfo debugInfo, XDebugSession session, BlazorWasmDebugStateNotifier notifier) {
        Url debuggingUri = BlazorWasmBrowserUtil.INSTANCE.toIdeaUrl$intellij_rider_plugins_razor_jsdebugger(BlazorWasmBrowserUtil.INSTANCE.toUriTrailingSlashAware$intellij_rider_plugins_razor_jsdebugger(debugInfo.getPageUrlInBrowser()));
        return WhenMappings.$EnumSwitchMapping$0[debugInfo.getBlazorAppInfo().getVersion().ordinal()] == 1 ? (DotNetWasmWipVmConnection)new DotNet3WasmWipVmConnection(project, debuggingUri, debugInfo, session, notifier) : new DotNetWasmWipVmConnection(project, debuggingUri, debugInfo, session, notifier);
    }

    private final void notifySessionStarting(String dotnetProjectPath) {
        blazorWipLogger.logInfo("");
        blazorWipLogger.logInfo("Creating new Blazor WASM debugging session for project '" + dotnetProjectPath + "'...");
    }

    private static final Unit createStandaloneProcess$lambda$0(BlazorWasmDebugInfo $debugInfo, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ProcessHandler processHandler2 = $debugInfo.getDotnetHostProcessExecutionResult().getProcessHandler();
        Intrinsics.checkNotNullExpressionValue((Object)processHandler2, (String)"getProcessHandler(...)");
        ProcessTerminationUtil.INSTANCE.terminateProcessAndDescendants(processHandler2);
        return Unit.INSTANCE;
    }

    private static final Unit createDebugProcess$lambda$1(Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit createDebugProcess$lambda$2(LaunchSettingsConfiguration $launchSettingsConfiguration, WipVm vm) {
        Project project = $launchSettingsConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SplashScreenPageManager splashManager = SplashScreenPageManager.Companion.getInstance(project);
        Object object = vm.getCurrentUrl();
        if (object == null || (object = object.toDecodedForm()) == null) {
            return Unit.INSTANCE;
        }
        Object url = object;
        if (splashManager.isSplashScreenUrl((String)url)) {
            URI uRI = splashManager.extractRealUrl((String)url);
            if (uRI == null) {
                return Unit.INSTANCE;
            }
            URI placeholder = uRI;
            WipCommandProcessor wipCommandProcessor = vm.getCommandProcessor();
            String string = placeholder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            wipCommandProcessor.send((Request)PageKt.Navigate$default((CharSequence)string, null, null, null, null, (int)30, null));
        }
        return Unit.INSTANCE;
    }

    private static final void createDebugProcess$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createDebugProcess$lambda$4(Function1 $connectionErrorHandler, BlazorWasmDebugStateNotifier $notifier, Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        $connectionErrorHandler.invoke((Object)it);
        BlazorWasmDebugStateNotifier.notify$default($notifier, BlazorWasmDebugState.ERROR, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final void createDebugProcess$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        Logger logger2 = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
        blazorWipLogger = BlazorWasmWipLogger.Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlazorWASMAppVersion.values().length];
            try {
                nArray[BlazorWASMAppVersion.DOTNET_CORE_3.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

