/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.jsdebugger.blazor.wasm.browser;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PathUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.wasm.splash.SplashScreenPageManager;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.browser.BrowserSessionLauncher;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.pipeline.BlazorWasmCliOptionsProvider;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.stateMachine.BlazorWasmDebugStateNotifier;
import com.jetbrains.rider.shared.utils.registryUtils.impl.RegistryRoot;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\u0018\u0000 72\u00020\u0001:\u00017Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0007\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0005H\u0002J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000eH\u0002J\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0007042\u0006\u00105\u001a\u00020\u0007H\u0002J\u0018\u00106\u001a\u00020-2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001dR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/browser/BrowserSessionBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "debuggableBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "url", "", "userDataDir", "stderrFile", "Ljava/io/File;", "remoteDebuggingPort", "", "cleanEnvironment", "", "additionalEnvironmentVariables", "", "additionalParameters", "", "sessionId", "notifier", "Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/stateMachine/BlazorWasmDebugStateNotifier;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/browsers/WebBrowser;Ljava/lang/String;Ljava/lang/String;Ljava/io/File;IZLjava/util/Map;Ljava/util/List;Ljava/lang/String;Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/stateMachine/BlazorWasmDebugStateNotifier;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDebuggableBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "getUrl", "()Ljava/lang/String;", "getUserDataDir", "getStderrFile", "()Ljava/io/File;", "getRemoteDebuggingPort", "()I", "getCleanEnvironment", "()Z", "getAdditionalEnvironmentVariables", "()Ljava/util/Map;", "getAdditionalParameters", "()Ljava/util/List;", "getSessionId", "getBrowserSystemDependentPath", "browser", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getParentEnvironmentType", "Lcom/intellij/execution/configurations/GeneralCommandLine$ParentEnvironmentType;", "clean", "buildLauncher", "Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/browser/BrowserSessionLauncher;", "getOpenBrowserCommand", "", "browserDependentPath", "createOpenBrowserCommand", "Companion", "intellij.rider.plugins.razor.jsdebugger"})
@SourceDebugExtension(value={"SMAP\nBrowserSessionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserSessionBuilder.kt\ncom/jetbrains/rider/razor/jsdebugger/blazor/wasm/browser/BrowserSessionBuilder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,160:1\n15#2:161\n*S KotlinDebug\n*F\n+ 1 BrowserSessionBuilder.kt\ncom/jetbrains/rider/razor/jsdebugger/blazor/wasm/browser/BrowserSessionBuilder\n*L\n62#1:161\n*E\n"})
public final class BrowserSessionBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final WebBrowser debuggableBrowser;
    @NotNull
    private final String url;
    @NotNull
    private final String userDataDir;
    @NotNull
    private final File stderrFile;
    private final int remoteDebuggingPort;
    private final boolean cleanEnvironment;
    @NotNull
    private final Map<String, String> additionalEnvironmentVariables;
    @NotNull
    private final List<String> additionalParameters;
    @NotNull
    private final String sessionId;
    @NotNull
    private final BlazorWasmDebugStateNotifier notifier;
    @NotNull
    private static final String EDGE_NAME = "Edge";
    @NotNull
    private static final String CHROME_NAME;
    @NotNull
    private static final Logger logger;
    @TestOnly
    @Nullable
    private static String browserPath;

    public BrowserSessionBuilder(@NotNull Project project, @NotNull WebBrowser debuggableBrowser, @NotNull String url, @NotNull String userDataDir, @NotNull File stderrFile, int remoteDebuggingPort, boolean cleanEnvironment, @NotNull Map<String, String> additionalEnvironmentVariables, @NotNull List<String> additionalParameters, @NotNull String sessionId, @NotNull BlazorWasmDebugStateNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)debuggableBrowser, (String)"debuggableBrowser");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)userDataDir, (String)"userDataDir");
        Intrinsics.checkNotNullParameter((Object)stderrFile, (String)"stderrFile");
        Intrinsics.checkNotNullParameter(additionalEnvironmentVariables, (String)"additionalEnvironmentVariables");
        Intrinsics.checkNotNullParameter(additionalParameters, (String)"additionalParameters");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        this.project = project;
        this.debuggableBrowser = debuggableBrowser;
        this.url = url;
        this.userDataDir = userDataDir;
        this.stderrFile = stderrFile;
        this.remoteDebuggingPort = remoteDebuggingPort;
        this.cleanEnvironment = cleanEnvironment;
        this.additionalEnvironmentVariables = additionalEnvironmentVariables;
        this.additionalParameters = additionalParameters;
        this.sessionId = sessionId;
        this.notifier = notifier;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final WebBrowser getDebuggableBrowser() {
        return this.debuggableBrowser;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getUserDataDir() {
        return this.userDataDir;
    }

    @NotNull
    public final File getStderrFile() {
        return this.stderrFile;
    }

    public final int getRemoteDebuggingPort() {
        return this.remoteDebuggingPort;
    }

    public final boolean getCleanEnvironment() {
        return this.cleanEnvironment;
    }

    @NotNull
    public final Map<String, String> getAdditionalEnvironmentVariables() {
        return this.additionalEnvironmentVariables;
    }

    @NotNull
    public final List<String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    private final String getBrowserSystemDependentPath(WebBrowser browser) {
        if (browserPath != null) {
            String string = browserPath;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        String browserPath = browser.getPath();
        String string = PathUtil.toSystemDependentName((String)browserPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        return string;
    }

    private final GeneralCommandLine buildCommandLine() {
        GeneralCommandLine commandLine = this.createOpenBrowserCommand(this.debuggableBrowser, this.url);
        List<String> browserArguments = BlazorWasmCliOptionsProvider.INSTANCE.createBrowserArguments(this.userDataDir, this.remoteDebuggingPort, this.debuggableBrowser);
        commandLine.withParentEnvironmentType(this.getParentEnvironmentType(this.cleanEnvironment));
        commandLine.addParameters(browserArguments);
        commandLine.addParameters(this.additionalParameters);
        commandLine.withEnvironment(this.additionalEnvironmentVariables);
        if (ApplicationKt.getApplication().isUnitTestMode() && SystemInfo.isLinux) {
            String string = browserPath;
            Intrinsics.checkNotNull((Object)string);
            File libs = new File(PathUtil.getParentPath((String)string), "lib");
            Map map = commandLine.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
            Map map2 = map;
            String string2 = "LD_LIBRARY_PATH";
            String string3 = libs.getCanonicalPath();
            map2.put(string2, string3);
            commandLine.addParameter("--headless");
            commandLine.addParameter("--no-sandbox");
        }
        return commandLine;
    }

    private final GeneralCommandLine.ParentEnvironmentType getParentEnvironmentType(boolean clean) {
        return clean ? GeneralCommandLine.ParentEnvironmentType.NONE : GeneralCommandLine.ParentEnvironmentType.CONSOLE;
    }

    @NotNull
    public final BrowserSessionLauncher buildLauncher() {
        GeneralCommandLine commandLine = this.buildCommandLine();
        return new BrowserSessionLauncher(this.url, this.userDataDir, this.stderrFile, this.remoteDebuggingPort, commandLine, this.sessionId, this.notifier);
    }

    private final List<String> getOpenBrowserCommand(String browserDependentPath) {
        List list = BrowserUtil.getOpenBrowserCommand((String)browserDependentPath, null, (List)CollectionsKt.emptyList(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOpenBrowserCommand(...)");
        List result2 = CollectionsKt.toMutableList((Collection)list);
        if (Intrinsics.areEqual((Object)CollectionsKt.first((List)result2), (Object)CommandLineUtil.getWinShellName())) {
            try {
                WinReg.HKEY hKEY = WinReg.HKEY_LOCAL_MACHINE;
                Intrinsics.checkNotNullExpressionValue((Object)hKEY, (String)"HKEY_LOCAL_MACHINE");
                String string = new RegistryRoot(hKEY, Lifetime.Companion.getEternal()).fromKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\" + browserDependentPath + ".exe").getStringValue("Path");
                Intrinsics.checkNotNull((Object)string);
                String pathWithoutBrowser = string;
                File browserDir = new File(pathWithoutBrowser);
                File browserFile = new File(browserDir, browserDependentPath + ".exe");
                result2 = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object)browserFile.getAbsolutePath()));
            }
            catch (Exception e) {
                logger.info("Cannot find registry key", (Throwable)e);
            }
        }
        return result2;
    }

    private final GeneralCommandLine createOpenBrowserCommand(WebBrowser browser, String url) {
        String browserDependentPath = this.getBrowserSystemDependentPath(browser);
        List<String> commandWithUrl = this.getOpenBrowserCommand(browserDependentPath);
        SplashScreenPageManager splashScreenPageManager = SplashScreenPageManager.Companion.getInstance(this.project);
        URI uRI = URI.create(url);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        browser.addOpenUrlParameter(commandWithUrl, splashScreenPageManager.createSplashScreenUrl(uRI));
        GeneralCommandLine result2 = new GeneralCommandLine(commandWithUrl);
        if (SystemInfo.isMac && Intrinsics.areEqual((Object)ExecUtil.getOpenCommandPath(), (Object)result2.getExePath())) {
            if (SystemInfo.isMacOSBigSur) {
                result2.addParameter("--stderr=" + this.stderrFile.getAbsolutePath());
            }
            result2.addParameter("--args");
        }
        return result2;
    }

    static {
        String string = IdeBundle.message((String)"browsers.chrome", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CHROME_NAME = string;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(BrowserSessionBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f0\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/browser/BrowserSessionBuilder$Companion;", "", "<init>", "()V", "EDGE_NAME", "", "CHROME_NAME", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "browserPath", "getBrowserPath", "()Ljava/lang/String;", "setBrowserPath", "(Ljava/lang/String;)V", "intellij.rider.plugins.razor.jsdebugger"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getBrowserPath() {
            return browserPath;
        }

        public final void setBrowserPath(@Nullable String string) {
            browserPath = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

