/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.jsdebugger.blazor.wasm.browser;

import com.intellij.execution.CantRunException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.rider.RiderRazorBundle;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.stateMachine.BlazorWasmDebugState;
import com.jetbrains.rider.razor.jsdebugger.blazor.wasm.stateMachine.BlazorWasmDebugStateNotifier;
import com.jetbrains.rider.run.TerminalProcessHandler;
import java.net.InetSocketAddress;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\bH\u0000\u00a2\u0006\u0002\b\rJ\u0011\u0010\u000e\u001a\u00020\t*\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/browser/BlazorWasmBrowserUtil;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "toUriTrailingSlashAware", "Ljava/net/URI;", "", "toUriTrailingSlashAware$intellij_rider_plugins_razor_jsdebugger", "toIdeaUrl", "Lcom/intellij/util/Url;", "toIdeaUrl$intellij_rider_plugins_razor_jsdebugger", "toHttpHeaderHostField", "Ljava/net/InetSocketAddress;", "toHttpHeaderHostField$intellij_rider_plugins_razor_jsdebugger", "checkBrowserExists", "", "browserProcessHandler", "Lcom/jetbrains/rider/run/TerminalProcessHandler;", "notifier", "Lcom/jetbrains/rider/razor/jsdebugger/blazor/wasm/stateMachine/BlazorWasmDebugStateNotifier;", "isOpenCommand", "Lcom/intellij/execution/process/BaseProcessHandler;", "checkBrowserSupported", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "intellij.rider.plugins.razor.jsdebugger"})
public final class BlazorWasmBrowserUtil {
    @NotNull
    public static final BlazorWasmBrowserUtil INSTANCE = new BlazorWasmBrowserUtil();
    @NotNull
    private static final Logger logger;

    private BlazorWasmBrowserUtil() {
    }

    @NotNull
    public final URI toUriTrailingSlashAware$intellij_rider_plugins_razor_jsdebugger(@NotNull String $this$toUriTrailingSlashAware) {
        Intrinsics.checkNotNullParameter((Object)$this$toUriTrailingSlashAware, (String)"<this>");
        URI it = URI.create($this$toUriTrailingSlashAware);
        boolean bl = false;
        String string = it.getRawPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRawPath(...)");
        URI uRI = ((CharSequence)string).length() == 0 ? URI.create($this$toUriTrailingSlashAware + "/") : it;
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"let(...)");
        return uRI;
    }

    @Nullable
    public final Url toIdeaUrl$intellij_rider_plugins_razor_jsdebugger(@NotNull URI $this$toIdeaUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toIdeaUrl, (String)"<this>");
        String string = $this$toIdeaUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Urls.parseEncoded((String)string);
    }

    @NotNull
    public final String toHttpHeaderHostField$intellij_rider_plugins_razor_jsdebugger(@NotNull InetSocketAddress $this$toHttpHeaderHostField) {
        Intrinsics.checkNotNullParameter((Object)$this$toHttpHeaderHostField, (String)"<this>");
        return $this$toHttpHeaderHostField.getHostString() + ":" + $this$toHttpHeaderHostField.getPort();
    }

    public final boolean checkBrowserExists(@NotNull TerminalProcessHandler browserProcessHandler, @NotNull BlazorWasmDebugStateNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)browserProcessHandler, (String)"browserProcessHandler");
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        if (SystemInfo.isMac && this.isOpenCommand((BaseProcessHandler)browserProcessHandler)) {
            return true;
        }
        if (browserProcessHandler.isProcessTerminating() || browserProcessHandler.isProcessTerminated()) {
            logger.debug("browser is dead");
            BlazorWasmDebugStateNotifier.notify$default(notifier, BlazorWasmDebugState.BROWSER_TERMINATED, null, 2, null);
            throw new CantRunException(RiderRazorBundle.Companion.message("blazor.wasm.debug.exception.browser.closed", new Object[0]));
        }
        logger.debug("browser exists");
        return true;
    }

    private final boolean isOpenCommand(BaseProcessHandler<?> $this$isOpenCommand) {
        String string = $this$isOpenCommand.getCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLine(...)");
        return StringsKt.startsWith$default((String)string, (String)ExecUtil.getOpenCommandPath(), (boolean)false, (int)2, null);
    }

    public final void checkBrowserSupported(@NotNull WebBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        if (browser.getFamily() != BrowserFamily.CHROME) {
            Object[] objectArray = new Object[]{browser.getFamily().getName()};
            throw new CantRunException(RiderRazorBundle.Companion.message("blazor.wasm.debug.exception.browser.incorrect", objectArray));
        }
    }

    static {
        Logger logger2 = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }
}

