/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.javascript.analysis;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.jetbrains.rider.razor.psi.RazorFileViewProvider;
import com.jetbrains.rider.razor.psi.RazorTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/razor/javascript/analysis/JSInRazorErrorFilter;", "Lcom/intellij/codeInsight/highlighting/HighlightErrorFilter;", "<init>", "()V", "shouldHighlightErrorElement", "", "element", "Lcom/intellij/psi/PsiErrorElement;", "intellij.rider.plugins.razor.javascript"})
public final class JSInRazorErrorFilter
extends HighlightErrorFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!RazorTreeUtilKt.inRazorFile((PsiElement)element)) {
            return true;
        }
        if (!(element.getParent() instanceof JSElement)) {
            return true;
        }
        FileViewProvider fileViewProvider = element.getContainingFile().getViewProvider();
        RazorFileViewProvider razorFileViewProvider = fileViewProvider instanceof RazorFileViewProvider ? (RazorFileViewProvider)fileViewProvider : null;
        if (razorFileViewProvider == null) {
            return true;
        }
        RazorFileViewProvider provider = razorFileViewProvider;
        PsiElement nextSibling = provider.findElementAt(element.getTextOffset() + 1, provider.getTemplateDataLanguage());
        if (RazorTreeUtilKt.isRazorOuterElement(nextSibling)) {
            String string = element.getErrorDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorDescription(...)");
            if (StringsKt.endsWith$default((String)string, (String)"expression expected", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        return true;
    }
}

