/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.verse.lang.service;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.lsp.api.LspCommunicationChannel;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.platform.lsp.api.lsWidget.LspServerWidgetItem;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.plugins.verse.VerseIcons;
import com.jetbrains.rider.plugins.verse.VerseProjectLifetimeService;
import com.jetbrains.rider.plugins.verse.lang.service.VerseFirstNotification;
import com.jetbrains.rider.plugins.verse.lang.service.VerseLspProjectService;
import com.jetbrains.rider.plugins.verse.lang.service.VerseLspServerSupportProvider;
import com.jetbrains.rider.plugins.verse.lang.service.VerseLspServerWidgetItem;
import com.jetbrains.rider.plugins.verse.settings.VersePluginSettings;
import com.jetbrains.rider.plugins.verse.settings.VersePluginSettingsPage;
import com.jetbrains.rider.plugins.verse.settings.VerseTextMateSettingsSync;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/verse/lang/service/VerseLspServerSupportProvider;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "<init>", "()V", "createLspServerWidgetItem", "Lcom/intellij/platform/lsp/api/lsWidget/LspServerWidgetItem;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "serverStarter", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider$LspServerStarter;", "allReady", "", "settings", "Lcom/jetbrains/rider/plugins/verse/settings/VersePluginSettings;", "scheduleStartIfNeeded", "VerseLspServerDescriptor", "intellij.rider.plugins.verse"})
@SourceDebugExtension(value={"SMAP\nVerseLspServerSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerseLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/verse/lang/service/VerseLspServerSupportProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,185:1\n25#2:186\n*S KotlinDebug\n*F\n+ 1 VerseLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/verse/lang/service/VerseLspServerSupportProvider\n*L\n98#1:186\n*E\n"})
public final class VerseLspServerSupportProvider
implements LspServerSupportProvider {
    @NotNull
    public LspServerWidgetItem createLspServerWidgetItem(@NotNull LspServer lspServer, @Nullable VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        return new VerseLspServerWidgetItem(lspServer, currentFile, VerseIcons.Icons.Companion.getLogo(), VersePluginSettingsPage.class);
    }

    public void fileOpened(@NotNull Project project, @NotNull VirtualFile file, @NotNull LspServerSupportProvider.LspServerStarter serverStarter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)serverStarter, (String)"serverStarter");
        if (Intrinsics.areEqual((Object)file.getExtension(), (Object)"verse")) {
            VerseLspProjectService lspService = VerseLspProjectService.Companion.getInstance(project);
            if (lspService.isScheduled().compareAndSet(false, true)) {
                Lifetime pluginLifetime = VerseProjectLifetimeService.Companion.getLifetime(project);
                LifetimeCoroutineUtilKt.async$default((Lifetime)pluginLifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(pluginLifetime, this, project, null){
                    int label;
                    final /* synthetic */ Lifetime $pluginLifetime;
                    final /* synthetic */ VerseLspServerSupportProvider this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.$pluginLifetime = $pluginLifetime;
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                SourceExKt.adviseNotNull((ISource)((ISource)VersePluginSettings.Companion.getInstance().getEnableLsp()), (Lifetime)this.$pluginLifetime, arg_0 -> fileOpened.1.invokeSuspend$lambda$0(this.this$0, this.$project, arg_0));
                                SourceExKt.adviseNotNull((ISource)((ISource)VersePluginSettings.Companion.getInstance().getLspPath()), (Lifetime)this.$pluginLifetime, arg_0 -> fileOpened.1.invokeSuspend$lambda$1(this.this$0, this.$project, arg_0));
                                VerseTextMateSettingsSync.Companion.getInstance().getSyncTextMate().advise(this.$pluginLifetime, arg_0 -> fileOpened.1.invokeSuspend$lambda$2(this.this$0, this.$project, arg_0));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(VerseLspServerSupportProvider this$0, Project $project, boolean enabled) {
                        if (enabled) {
                            VerseLspServerSupportProvider.access$scheduleStartIfNeeded(this$0, $project);
                        } else {
                            LspServerManager.Companion.getInstance($project).stopServers(VerseLspServerSupportProvider.class);
                        }
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$1(VerseLspServerSupportProvider this$0, Project $project, Path path) {
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            VerseLspServerSupportProvider.access$scheduleStartIfNeeded(this$0, $project);
                        } else {
                            VerseFirstNotification.Companion.getService($project).show();
                            LspServerManager.Companion.getInstance($project).stopServers(VerseLspServerSupportProvider.class);
                        }
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$2(VerseLspServerSupportProvider this$0, Project $project, Unit it) {
                        VerseLspServerSupportProvider.access$scheduleStartIfNeeded(this$0, $project);
                        return Unit.INSTANCE;
                    }
                }), (int)2, null);
            }
            if (this.allReady(VersePluginSettings.Companion.getInstance())) {
                VerseLspServerSupportProvider $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(VerseLspServerSupportProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("ensureServerStarted");
                serverStarter.ensureServerStarted((LspServerDescriptor)new VerseLspServerDescriptor(project));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean allReady(VersePluginSettings settings) {
        if (!Intrinsics.areEqual((Object)settings.getEnableLsp().getValue(), (Object)true)) return false;
        Object object = settings.getLspPath().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
        Path path = (Path)object;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        return true;
    }

    private final void scheduleStartIfNeeded(Project project) {
        VerseLspProjectService lspProjectService = VerseLspProjectService.Companion.getInstance(project);
        if (!this.allReady(VersePluginSettings.Companion.getInstance())) {
            return;
        }
        lspProjectService.queueRestart();
    }

    public static final /* synthetic */ void access$scheduleStartIfNeeded(VerseLspServerSupportProvider $this, Project project) {
        $this.scheduleStartIfNeeded(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/verse/lang/service/VerseLspServerSupportProvider$VerseLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isSupportedFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "lspCommunicationChannel", "Lcom/intellij/platform/lsp/api/LspCommunicationChannel;", "getLspCommunicationChannel", "()Lcom/intellij/platform/lsp/api/LspCommunicationChannel;", "readFolders", "", "Lorg/eclipse/lsp4j/WorkspaceFolder;", "createInitializeParams", "Lorg/eclipse/lsp4j/InitializeParams;", "Companion", "intellij.rider.plugins.verse"})
    @SourceDebugExtension(value={"SMAP\nVerseLspServerSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerseLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/verse/lang/service/VerseLspServerSupportProvider$VerseLspServerDescriptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n3829#2:186\n4344#2,2:187\n1310#2,2:192\n1557#3:189\n1628#3,2:190\n1630#3:194\n1557#3:195\n1628#3,3:196\n1#4:199\n*S KotlinDebug\n*F\n+ 1 VerseLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/verse/lang/service/VerseLspServerSupportProvider$VerseLspServerDescriptor\n*L\n140#1:186\n140#1:187,2\n143#1:192,2\n142#1:189\n142#1:190,2\n142#1:194\n147#1:195\n147#1:196,3\n*E\n"})
    private static final class VerseLspServerDescriptor
    extends ProjectWideLspServerDescriptor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static final ObjectMapper json;

        public VerseLspServerDescriptor(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, "Verse");
        }

        public boolean isSupportedFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return Intrinsics.areEqual((Object)file.getExtension(), (Object)"verse");
        }

        @NotNull
        public GeneralCommandLine createCommandLine() {
            String[] stringArray = new String[1];
            Object object = VersePluginSettings.Companion.getInstance().getLspPath().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
            stringArray[0] = ((Object)((Path)object)).toString();
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray).withWorkingDirectory(SolutionHostExtensionsKt.getSolutionDirectoryPath((Project)this.getProject()));
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withWorkingDirectory(...)");
            return generalCommandLine;
        }

        @NotNull
        public LspCommunicationChannel getLspCommunicationChannel() {
            return (LspCommunicationChannel)LspCommunicationChannel.StdIO.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private final List<WorkspaceFolder> readFolders() {
            block12: {
                block11: {
                    v0 = ProjectUtil.guessProjectDir((Project)this.getProject());
                    if (v0 == null) {
                        return CollectionsKt.emptyList();
                    }
                    solDir = v0;
                    parentDirectory = solDir.getParent();
                    v1 = plugins = VirtualFileUtil.findDirectory((VirtualFile)solDir, (String)"Plugins");
                    if (plugins == null || (v1 = v1.getChildren()) == null) break block11;
                    $this$filter$iv = v1;
                    $i$f$filter = false;
                    var9_7 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                        it = element$iv$iv;
                        $i$a$-filter-VerseLspServerSupportProvider$VerseLspServerDescriptor$readFolders$alt$1 = false;
                        if (!it.isDirectory()) ** GOTO lbl-1000
                        v2 = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
                        if (!StringsKt.startsWith$default((String)v2, (String)".", (boolean)false, (int)2, null)) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    v4 = (List)destination$iv$iv;
                    break block12;
                }
                v4 = CollectionsKt.emptyList();
            }
            alt = v4;
            alternatives = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)alt, (Object)parentDirectory), (Object)solDir);
            $this$map$iv = alternatives;
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                block10: {
                    it = (VirtualFile)item$iv$iv;
                    var24_32 = destination$iv$iv;
                    $i$a$-map-VerseLspServerSupportProvider$VerseLspServerDescriptor$readFolders$file$1 = false;
                    v5 = dir.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getChildren(...)");
                    $this$firstOrNull$iv = (JsonNode)v5;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (VirtualFile)element$iv;
                        $i$a$-firstOrNull-VerseLspServerSupportProvider$VerseLspServerDescriptor$readFolders$file$1$1 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!VirtualFileUtil.isFile((VirtualFile)it)) ** GOTO lbl-1000
                        v6 = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getName(...)");
                        if (StringsKt.endsWith$default((String)v6, (String)".code-workspace", (boolean)false, (int)2, null)) {
                            v7 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v7 = false;
                        }
                        if (!v7) continue;
                        v8 = element$iv;
                        break block10;
                    }
                    v8 = null;
                }
                var24_32.add((VirtualFile)v8);
            }
            v9 = (VirtualFile)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (v9 == null) {
                return CollectionsKt.emptyList();
            }
            file = v9;
            root = VerseLspServerDescriptor.json.readTree(DocumentUtilKt.toIOFile((VirtualFile)file));
            foldersNode = root.get("folders");
            Intrinsics.checkNotNull((Object)foldersNode);
            $this$map$iv = (Iterable)foldersNode;
            $i$f$map = false;
            $i$f$mapTo = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                $this$firstOrNull$iv = (JsonNode)item$iv$iv;
                var24_32 = destination$iv$iv;
                $i$a$-map-VerseLspServerSupportProvider$VerseLspServerDescriptor$readFolders$folders$1 = false;
                var24_32.add(new WorkspaceFolder(Path.of(it.get("path").textValue(), new String[0]).toUri().toString(), it.get("name").textValue()));
            }
            folders = (List)destination$iv$iv;
            return folders;
        }

        @NotNull
        public InitializeParams createInitializeParams() {
            ClientCapabilities clientCapabilities;
            InitializeParams initializeParams;
            InitializeParams $this$createInitializeParams_u24lambda_u245 = initializeParams = super.createInitializeParams();
            boolean bl = false;
            $this$createInitializeParams_u24lambda_u245.setProcessId(Integer.valueOf(OSProcessUtil.getCurrentProcessId()));
            ClientCapabilities clientCapabilities2 = clientCapabilities = new ClientCapabilities();
            InitializeParams initializeParams2 = $this$createInitializeParams_u24lambda_u245;
            boolean bl2 = false;
            $this$createInitializeParams_u24lambda_u245.setWorkspaceFolders(this.readFolders());
            initializeParams2.setCapabilities(clientCapabilities);
            return initializeParams;
        }

        static {
            JsonParser.Feature[] featureArray = new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS};
            ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().enable(featureArray);
            featureArray = new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES};
            ObjectMapper objectMapper2 = objectMapper.enable(featureArray);
            featureArray = new JsonParser.Feature[]{JsonReadFeature.ALLOW_TRAILING_COMMA.mappedFeature()};
            json = objectMapper2.enable(featureArray);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/verse/lang/service/VerseLspServerSupportProvider$VerseLspServerDescriptor$Companion;", "", "<init>", "()V", "json", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "intellij.rider.plugins.verse"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

