/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.requests;

import com.intellij.grpc.requests.execution.GrpcAggregatedRequestExecutor;
import com.intellij.grpc.requests.execution.GrpcLocalFileBasedRequestExecutor;
import com.intellij.grpc.requests.execution.GrpcReflectionRequestExecutor;
import com.intellij.grpc.requests.execution.GrpcRequestExecutor;
import com.intellij.grpc.requests.execution.KnownReflectionRequestsKt;
import com.intellij.grpc.restClient.execution.GrpcReflectionWrappingRequest;
import com.intellij.grpc.restClient.execution.GrpcRequest;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.protobuf.lang.stub.ProtoFileAccessor;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u00020\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grpc/requests/GrpcRequestManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "executeCallSynchronously", "Lcom/intellij/httpClient/execution/common/CommonClientResponse;", "request", "Lcom/intellij/grpc/restClient/execution/GrpcRequest;", "forceUseReflection", "", "executeCallSynchronouslySafe", "hasProtoFileWithFqn", "methodFqn", "", "Companion", "intellij.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcRequestManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcRequestManager.kt\ncom/intellij/grpc/requests/GrpcRequestManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,73:1\n15#2:74\n19#3:75\n31#4,2:76\n*S KotlinDebug\n*F\n+ 1 GrpcRequestManager.kt\ncom/intellij/grpc/requests/GrpcRequestManager\n*L\n36#1:74\n44#1:75\n71#1:76,2\n*E\n"})
public final class GrpcRequestManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Path TEMP_BINARY_DESCRIPTOR_FOLDER;

    public GrpcRequestManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(TEMP_BINARY_DESCRIPTOR_FOLDER, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Files.createDirectories(TEMP_BINARY_DESCRIPTOR_FOLDER, new FileAttribute[0]);
            }
        }
        catch (IOException exception) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GrpcRequestManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to create temp binary file", (Throwable)exception);
        }
    }

    @NotNull
    public final CommonClientResponse executeCallSynchronously(@NotNull GrpcRequest request, boolean forceUseReflection) {
        GrpcRequestExecutor grpcRequestExecutor;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (Intrinsics.areEqual((Object)request.getMethodFqn(), (Object)"grpc.reflection.v1alpha.ServerReflection.ServerReflectionInfo")) {
            GrpcRequest $this$asSafely$iv = request;
            boolean $i$f$asSafely = false;
            GrpcRequest grpcRequest = $this$asSafely$iv;
            if (!(grpcRequest instanceof GrpcReflectionWrappingRequest)) {
                grpcRequest = null;
            }
            GrpcReflectionWrappingRequest grpcReflectionWrappingRequest = (GrpcReflectionWrappingRequest)grpcRequest;
            ServerReflectionRequest preparedRequest = grpcReflectionWrappingRequest != null ? grpcReflectionWrappingRequest.getEffectiveRequest() : null;
            grpcRequestExecutor = new GrpcReflectionRequestExecutor(request, null, preparedRequest, 2, null);
        } else {
            grpcRequestExecutor = forceUseReflection || !this.hasProtoFileWithFqn(request.getMethodFqn(), this.project) ? (GrpcRequestExecutor)new GrpcAggregatedRequestExecutor(request, this.project, KnownReflectionRequestsKt.findProtoDescriptorsWithSymbolRequest(request.getMethodFqn())) : (GrpcRequestExecutor)new GrpcLocalFileBasedRequestExecutor(request, null, this.project, null, 10, null);
        }
        GrpcRequestExecutor executor = grpcRequestExecutor;
        return executor.executeUnsafe();
    }

    public static /* synthetic */ CommonClientResponse executeCallSynchronously$default(GrpcRequestManager grpcRequestManager, GrpcRequest grpcRequest, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return grpcRequestManager.executeCallSynchronously(grpcRequest, bl);
    }

    @Nullable
    public final CommonClientResponse executeCallSynchronouslySafe(@NotNull GrpcRequest request, boolean forceUseReflection) {
        CommonClientResponse commonClientResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            commonClientResponse = this.executeCallSynchronously(request, forceUseReflection);
        }
        catch (Exception ignored) {
            commonClientResponse = null;
        }
        return commonClientResponse;
    }

    public static /* synthetic */ CommonClientResponse executeCallSynchronouslySafe$default(GrpcRequestManager grpcRequestManager, GrpcRequest grpcRequest, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return grpcRequestManager.executeCallSynchronouslySafe(grpcRequest, bl);
    }

    private final boolean hasProtoFileWithFqn(@NlsSafe String methodFqn, Project project) {
        return (Boolean)ActionsKt.runReadAction(() -> GrpcRequestManager.hasProtoFileWithFqn$lambda$0(project, methodFqn));
    }

    private static final boolean hasProtoFileWithFqn$lambda$0(Project $project, String $methodFqn) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<ProtoFileAccessor> serviceClass$iv = ProtoFileAccessor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((ProtoFileAccessor)object).findMethodByFqn($methodFqn) != null;
    }

    static {
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("grpc");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        TEMP_BINARY_DESCRIPTOR_FOLDER = path;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/grpc/requests/GrpcRequestManager$Companion;", "", "<init>", "()V", "TEMP_BINARY_DESCRIPTOR_FOLDER", "Ljava/nio/file/Path;", "getTEMP_BINARY_DESCRIPTOR_FOLDER", "()Ljava/nio/file/Path;", "intellij.grpc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getTEMP_BINARY_DESCRIPTOR_FOLDER() {
            return TEMP_BINARY_DESCRIPTOR_FOLDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

