/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc;

import com.intellij.grpc.GrpcCombinedModificationTracker;
import com.intellij.grpc.model.ProtoFileModel;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.lang.PbFileType;
import com.intellij.protobuf.lang.PbLanguage;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbServiceMethod;
import com.intellij.protobuf.lang.psi.PbServiceMethodType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"hasAnyProtoFiles", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getAllProtoFiles", "Lkotlin/sequences/Sequence;", "Lcom/intellij/grpc/model/ProtoFileModel;", "getProtoModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "getProtoAndHttpModificationTracker", "canExecuteRPC", "method", "Lcom/intellij/protobuf/lang/psi/PbServiceMethod;", "intellij.grpc"})
@SourceDebugExtension(value={"SMAP\nProtoFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtoFileUtils.kt\ncom/intellij/grpc/ProtoFileUtilsKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,40:1\n31#2,2:41\n*S KotlinDebug\n*F\n+ 1 ProtoFileUtils.kt\ncom/intellij/grpc/ProtoFileUtilsKt\n*L\n34#1:41,2\n*E\n"})
public final class ProtoFileUtilsKt {
    public static final boolean hasAnyProtoFiles(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return FileTypeIndex.containsFileOfType((FileType)((FileType)PbFileType.INSTANCE), (GlobalSearchScope)scope);
    }

    @NotNull
    public static final Sequence<ProtoFileModel> getAllProtoFiles(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Project project = scope.getProject();
        if (project == null) {
            return SequencesKt.emptySequence();
        }
        Project project2 = project;
        Collection collection = FileTypeIndex.getFiles((FileType)((FileType)PbFileType.INSTANCE), (GlobalSearchScope)scope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
        return SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> ProtoFileUtilsKt.getAllProtoFiles$lambda$0(project2, arg_0)), ProtoFileUtilsKt::getAllProtoFiles$lambda$1);
    }

    @NotNull
    public static final ModificationTracker getProtoModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModificationTracker modificationTracker = PsiManager.getInstance((Project)project).getModificationTracker().forLanguage((Language)PbLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"forLanguage(...)");
        return modificationTracker;
    }

    @NotNull
    public static final ModificationTracker getProtoAndHttpModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GrpcCombinedModificationTracker> serviceClass$iv = GrpcCombinedModificationTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (ModificationTracker)object;
    }

    public static final boolean canExecuteRPC(@NotNull PbServiceMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List list = method.getServiceMethodTypeList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getServiceMethodTypeList(...)");
        PbServiceMethodType pbServiceMethodType = (PbServiceMethodType)CollectionsKt.firstOrNull((List)list);
        if (pbServiceMethodType == null) {
            return false;
        }
        PbServiceMethodType methodParameterType = pbServiceMethodType;
        return !methodParameterType.isStreaming();
    }

    private static final PbFile getAllProtoFiles$lambda$0(Project $project, VirtualFile virtualFile) {
        PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile(virtualFile);
        return psiFile instanceof PbFile ? (PbFile)psiFile : null;
    }

    private static final ProtoFileModel getAllProtoFiles$lambda$1(PbFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)it));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        return new ProtoFileModel((SmartPsiElementPointer<PbFile>)smartPsiElementPointer);
    }
}

