/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.ui.container.states;

import com.jetbrains.rider.model.ErrorState;
import com.jetbrains.rider.model.NotSupportedState;
import com.jetbrains.rider.model.ReloadingState;
import com.jetbrains.rider.model.SuccessState;
import com.jetbrains.rider.model.SuccessWithWarningsState;
import com.jetbrains.rider.model.WpfPreviewState;
import com.jetbrains.rider.xaml.preview.states.InvalidTransitionException;
import com.jetbrains.rider.xaml.preview.ui.container.ImagePreviewLoadingContainer;
import com.jetbrains.rider.xaml.preview.ui.container.states.ContainerTransitionParams;
import com.jetbrains.rider.xaml.preview.ui.container.states.ErrorShownState;
import com.jetbrains.rider.xaml.preview.ui.container.states.ImagePreviewShownState;
import com.jetbrains.rider.xaml.preview.ui.container.states.MarkupErrorsState;
import com.jetbrains.rider.xaml.preview.ui.container.states.PreviewContainerStateBase;
import com.jetbrains.rider.xaml.preview.ui.container.states.UnsupportedState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/xaml/preview/ui/container/states/InitialState;", "Lcom/jetbrains/rider/xaml/preview/ui/container/states/PreviewContainerStateBase;", "container", "Lcom/jetbrains/rider/xaml/preview/ui/container/ImagePreviewLoadingContainer;", "<init>", "(Lcom/jetbrains/rider/xaml/preview/ui/container/ImagePreviewLoadingContainer;)V", "changeState", "params", "Lcom/jetbrains/rider/xaml/preview/ui/container/states/ContainerTransitionParams;", "intellij.rider.plugins.xaml.preview"})
public final class InitialState
extends PreviewContainerStateBase {
    public InitialState(@NotNull ImagePreviewLoadingContainer container) {
        Intrinsics.checkNotNullParameter((Object)((Object)container), (String)"container");
        super(null, container);
        container.startLoading();
    }

    @Override
    @NotNull
    public PreviewContainerStateBase changeState(@NotNull ContainerTransitionParams params) {
        PreviewContainerStateBase previewContainerStateBase;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (params.getHasMarkupErrors()) {
            return new MarkupErrorsState(this, params, this.getContainer());
        }
        WpfPreviewState wpfPreviewState = params.getState();
        if (wpfPreviewState instanceof SuccessWithWarningsState) {
            previewContainerStateBase = new ImagePreviewShownState(this, this.getContainer());
        } else if (wpfPreviewState instanceof SuccessState) {
            previewContainerStateBase = new ImagePreviewShownState(this, this.getContainer());
        } else if (wpfPreviewState instanceof ErrorState) {
            previewContainerStateBase = new ErrorShownState(this, params, this.getContainer());
        } else if (wpfPreviewState instanceof NotSupportedState) {
            previewContainerStateBase = new UnsupportedState(this, params, this.getContainer());
        } else if (wpfPreviewState instanceof ReloadingState) {
            previewContainerStateBase = this;
        } else {
            throw new InvalidTransitionException();
        }
        return previewContainerStateBase;
    }
}

