/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.ui;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rider.model.PreviewHighlightingRect;
import com.jetbrains.rider.ui.components.base.Viewable;
import com.jetbrains.rider.ui.components.layouts.FilledLayeredPane;
import com.jetbrains.rider.ui.components.utils.WPFBackgroundComponent;
import com.jetbrains.rider.xaml.preview.ui.ImagePane;
import com.jetbrains.rider.xaml.preview.ui.ImagePaneWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020\u001cJ\u0006\u0010!\u001a\u00020\u001cJ\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020\u0002H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/xaml/preview/ui/ZoomPanel;", "Lcom/jetbrains/rider/ui/components/base/Viewable;", "Ljavax/swing/JComponent;", "mouseListener", "Ljava/awt/event/MouseListener;", "<init>", "(Ljava/awt/event/MouseListener;)V", "imagePanel", "Lcom/jetbrains/rider/xaml/preview/ui/ImagePane;", "getImagePanel", "()Lcom/jetbrains/rider/xaml/preview/ui/ImagePane;", "imagePaneWrapper", "Lcom/jetbrains/rider/xaml/preview/ui/ImagePaneWrapper;", "getImagePaneWrapper", "()Lcom/jetbrains/rider/xaml/preview/ui/ImagePaneWrapper;", "scroll", "Lcom/intellij/ui/components/JBScrollPane;", "getScroll", "()Lcom/intellij/ui/components/JBScrollPane;", "wpfBackgroundComponent", "Lcom/jetbrains/rider/ui/components/utils/WPFBackgroundComponent;", "root", "Lcom/jetbrains/rider/ui/components/layouts/FilledLayeredPane;", "rectangle", "Ljava/awt/Rectangle;", "getRectangle", "()Ljava/awt/Rectangle;", "scrollToMiddle", "", "scrollModelToMiddle", "model", "Ljavax/swing/BoundedRangeModel;", "scrollToHighlightingRectIfNeeded", "clear", "hasImage", "", "showImage", "image", "Ljava/awt/Image;", "sourceSize", "Ljava/awt/Dimension;", "drawRect", "rect", "Lcom/jetbrains/rider/model/PreviewHighlightingRect;", "getView", "intellij.rider.plugins.xaml.preview"})
public final class ZoomPanel
implements Viewable<JComponent> {
    @NotNull
    private final ImagePane imagePanel;
    @NotNull
    private final ImagePaneWrapper imagePaneWrapper;
    @NotNull
    private final JBScrollPane scroll;
    @NotNull
    private final WPFBackgroundComponent wpfBackgroundComponent;
    @NotNull
    private final FilledLayeredPane root;

    /*
     * WARNING - void declaration
     */
    public ZoomPanel(@NotNull MouseListener mouseListener) {
        void $this$scroll_u24lambda_u240;
        JBScrollPane jBScrollPane;
        Intrinsics.checkNotNullParameter((Object)mouseListener, (String)"mouseListener");
        this.imagePanel = new ImagePane();
        this.imagePaneWrapper = new ImagePaneWrapper(this.imagePanel);
        JBScrollPane jBScrollPane2 = jBScrollPane = new JBScrollPane((Component)this.imagePaneWrapper);
        ZoomPanel zoomPanel = this;
        boolean bl = false;
        this.imagePanel.setBaseComponent($this$scroll_u24lambda_u240.getViewport());
        $this$scroll_u24lambda_u240.setOpaque(false);
        $this$scroll_u24lambda_u240.getViewport().setOpaque(false);
        $this$scroll_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        zoomPanel.scroll = jBScrollPane;
        this.wpfBackgroundComponent = new WPFBackgroundComponent();
        this.root = new FilledLayeredPane();
        this.root.add((Component)this.wpfBackgroundComponent, (Object)0);
        this.root.add((Component)this.scroll, (Object)1);
        this.wpfBackgroundComponent.setVisible(false);
        this.imagePanel.setBaseComponent((JComponent)this.scroll);
        this.imagePanel.addMouseListener(mouseListener);
        this.scroll.addMouseWheelListener(arg_0 -> ZoomPanel._init_$lambda$3(this, arg_0));
    }

    @NotNull
    public final ImagePane getImagePanel() {
        return this.imagePanel;
    }

    @NotNull
    public final ImagePaneWrapper getImagePaneWrapper() {
        return this.imagePaneWrapper;
    }

    @NotNull
    public final JBScrollPane getScroll() {
        return this.scroll;
    }

    @Nullable
    public final Rectangle getRectangle() {
        return this.imagePanel.getRectangle();
    }

    public final void scrollToMiddle() {
        ActionsKt.invokeLater$default(null, () -> ZoomPanel.scrollToMiddle$lambda$1(this), (int)1, null);
    }

    private final void scrollModelToMiddle(BoundedRangeModel model) {
        model.setValue((model.getMaximum() - model.getExtent()) / 2);
    }

    public final void scrollToHighlightingRectIfNeeded() {
        Dimension dimension = this.imagePaneWrapper.getHighlightingRectZoomedDimension();
        if (dimension == null) {
            return;
        }
        int width = dimension.width;
        Dimension dimension2 = this.imagePaneWrapper.getHighlightingRectZoomedDimension();
        if (dimension2 == null) {
            return;
        }
        int height = dimension2.height;
        double newZoomFactor = width > height ? ((double)this.scroll.getWidth() - (double)100) / (double)width : ((double)this.scroll.getHeight() - (double)100) / (double)height;
        this.imagePanel.setZoomFactor(newZoomFactor);
        ActionsKt.invokeLater$default(null, () -> ZoomPanel.scrollToHighlightingRectIfNeeded$lambda$2(this), (int)1, null);
    }

    public final void clear() {
        this.imagePanel.clear();
        this.wpfBackgroundComponent.setVisible(true);
    }

    public final boolean hasImage() {
        return this.imagePanel.hasImage();
    }

    public final void showImage(@NotNull Image image, @NotNull Dimension sourceSize) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)sourceSize, (String)"sourceSize");
        this.imagePanel.updateImage(image, sourceSize);
        this.wpfBackgroundComponent.setVisible(true);
    }

    public final void drawRect(@NotNull PreviewHighlightingRect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.imagePaneWrapper.drawHighlightRect(rect);
    }

    @NotNull
    public JComponent getView() {
        return (JComponent)this.root;
    }

    private static final Unit scrollToMiddle$lambda$1(ZoomPanel this$0) {
        BoundedRangeModel boundedRangeModel = this$0.scroll.getHorizontalScrollBar().getModel();
        Intrinsics.checkNotNullExpressionValue((Object)boundedRangeModel, (String)"getModel(...)");
        this$0.scrollModelToMiddle(boundedRangeModel);
        BoundedRangeModel boundedRangeModel2 = this$0.scroll.getVerticalScrollBar().getModel();
        Intrinsics.checkNotNullExpressionValue((Object)boundedRangeModel2, (String)"getModel(...)");
        this$0.scrollModelToMiddle(boundedRangeModel2);
        return Unit.INSTANCE;
    }

    private static final Unit scrollToHighlightingRectIfNeeded$lambda$2(ZoomPanel this$0) {
        this$0.imagePaneWrapper.recalculateHighlightingRectPosition();
        Dimension dimension = this$0.imagePaneWrapper.getHighlightingRectZoomedDimension();
        if (dimension == null) {
            return Unit.INSTANCE;
        }
        Dimension highlightingRectDimension = dimension;
        Point point = this$0.imagePaneWrapper.getHighlightingRectLeftUpPoint();
        if (point == null) {
            return Unit.INSTANCE;
        }
        Point highlightingRectLeftUpPoint = point;
        int centralX = highlightingRectLeftUpPoint.x + highlightingRectDimension.width / 2;
        int centralY = highlightingRectLeftUpPoint.y + highlightingRectDimension.height / 2;
        int newScrollX = Math.max(centralX - this$0.scroll.getWidth() / 2, 0);
        int newScrollY = Math.max(centralY - this$0.scroll.getHeight() / 2, 0);
        this$0.scroll.getHorizontalScrollBar().getModel().setValue(newScrollX);
        this$0.scroll.getVerticalScrollBar().getModel().setValue(newScrollY);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(ZoomPanel this$0, MouseWheelEvent e) {
        if (e != null && e.isControlDown()) {
            if (e.getPreciseWheelRotation() < 0.0) {
                if (this$0.imagePanel.canZoomIn()) {
                    this$0.imagePaneWrapper.zoomIn();
                }
            } else if (e.getPreciseWheelRotation() > 0.0 && this$0.imagePanel.canZoomOut()) {
                this$0.imagePaneWrapper.zoomOut();
            }
        }
    }
}

