/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.ui;

import com.intellij.ui.paint.LinePainter2D;
import com.jetbrains.rider.model.PreviewHighlightingRect;
import com.jetbrains.rider.model.PreviewPoint;
import com.jetbrains.rider.xaml.preview.ui.ImagePane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u000e\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\fJ\u0006\u0010$\u001a\u00020 J\u0012\u0010%\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010'H\u0014J\u0006\u0010(\u001a\u00020 J\b\u0010)\u001a\u00020 H\u0002J\b\u0010*\u001a\u00020 H\u0002J\u0010\u0010+\u001a\u00020 2\u0006\u0010&\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fH\u0002J0\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020,H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00063"}, d2={"Lcom/jetbrains/rider/xaml/preview/ui/ImagePaneWrapper;", "Ljavax/swing/JPanel;", "imagePane", "Lcom/jetbrains/rider/xaml/preview/ui/ImagePane;", "<init>", "(Lcom/jetbrains/rider/xaml/preview/ui/ImagePane;)V", "getImagePane", "()Lcom/jetbrains/rider/xaml/preview/ui/ImagePane;", "rectPoints", "", "Lcom/jetbrains/rider/model/PreviewPoint;", "highlightingRect", "Lcom/jetbrains/rider/model/PreviewHighlightingRect;", "maxHighlightingRectDelta", "", "margin", "", "getMargin", "()I", "value", "Ljava/awt/Dimension;", "highlightingRectZoomedDimension", "getHighlightingRectZoomedDimension", "()Ljava/awt/Dimension;", "Ljava/awt/Point;", "highlightingRectLeftUpPoint", "getHighlightingRectLeftUpPoint", "()Ljava/awt/Point;", "canZoomIn", "", "canZoomOut", "zoomIn", "", "zoomOut", "drawHighlightRect", "rect", "update", "paintChildren", "g", "Ljava/awt/Graphics;", "recalculateHighlightingRectPosition", "recalculateInternal", "findContainingRectangle", "drawRectangle", "Ljava/awt/Graphics2D;", "getZoomedRect", "drawLine", "x1", "y1", "x2", "y2", "intellij.rider.plugins.xaml.preview"})
public final class ImagePaneWrapper
extends JPanel {
    @NotNull
    private final ImagePane imagePane;
    @Nullable
    private List<PreviewPoint> rectPoints;
    @Nullable
    private PreviewHighlightingRect highlightingRect;
    private final double maxHighlightingRectDelta;
    private final int margin;
    @Nullable
    private Dimension highlightingRectZoomedDimension;
    @Nullable
    private Point highlightingRectLeftUpPoint;

    public ImagePaneWrapper(@NotNull ImagePane imagePane) {
        GridBagConstraints gridBagConstraints;
        Intrinsics.checkNotNullParameter((Object)imagePane, (String)"imagePane");
        super(new GridBagLayout());
        this.imagePane = imagePane;
        this.maxHighlightingRectDelta = 7.0;
        this.margin = 10;
        GridBagConstraints gridBagConstraints2 = gridBagConstraints = new GridBagConstraints();
        Component component = this.imagePane;
        ImagePaneWrapper imagePaneWrapper = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.insets = new Insets(this.margin, this.margin, this.margin, this.margin);
        Unit unit = Unit.INSTANCE;
        imagePaneWrapper.add(component, gridBagConstraints);
        this.setOpaque(false);
    }

    @NotNull
    public final ImagePane getImagePane() {
        return this.imagePane;
    }

    public final int getMargin() {
        return this.margin;
    }

    @Nullable
    public final Dimension getHighlightingRectZoomedDimension() {
        return this.highlightingRectZoomedDimension;
    }

    @Nullable
    public final Point getHighlightingRectLeftUpPoint() {
        return this.highlightingRectLeftUpPoint;
    }

    public final boolean canZoomIn() {
        return this.imagePane.canZoomIn();
    }

    public final boolean canZoomOut() {
        return this.imagePane.canZoomOut();
    }

    public final void zoomIn() {
        this.imagePane.zoomIn();
        this.update();
    }

    public final void zoomOut() {
        this.imagePane.zoomOut();
        this.update();
    }

    public final void drawHighlightRect(@NotNull PreviewHighlightingRect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.highlightingRect = rect;
        this.update();
    }

    public final void update() {
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintChildren(@Nullable Graphics g) {
        super.paintChildren(g);
        if (g != null) {
            this.drawRectangle((Graphics2D)g);
        }
    }

    public final void recalculateHighlightingRectPosition() {
        this.recalculateInternal();
    }

    private final void recalculateInternal() {
        PreviewHighlightingRect previewHighlightingRect = this.highlightingRect;
        if (previewHighlightingRect == null) {
            return;
        }
        PreviewHighlightingRect highlightingRect = previewHighlightingRect;
        Point point = this.imagePane.getImageLeftUpPoint();
        if (point == null) {
            return;
        }
        int imageLeftUpCornerX = point.x;
        Point point2 = this.imagePane.getImageLeftUpPoint();
        if (point2 == null) {
            return;
        }
        int imageLeftUpCornerY = point2.y;
        PreviewHighlightingRect zoomedRect = this.getZoomedRect(highlightingRect);
        List newRectPoints = new ArrayList();
        for (PreviewPoint point3 : zoomedRect.getPoints()) {
            newRectPoints.add(new PreviewPoint((double)imageLeftUpCornerX + point3.getX(), (double)imageLeftUpCornerY + point3.getY()));
        }
        this.rectPoints = newRectPoints;
        this.findContainingRectangle();
    }

    private final void findContainingRectangle() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        List<PreviewPoint> list = this.rectPoints;
        if (list == null) {
            return;
        }
        List<PreviewPoint> points = list;
        for (PreviewPoint point : points) {
            if (point.getX() < minX) {
                minX = point.getX();
            }
            if (point.getX() > maxX) {
                maxX = point.getX();
            }
            if (point.getY() < minY) {
                minY = point.getY();
            }
            if (!(point.getY() > maxY)) continue;
            maxY = point.getY();
        }
        this.highlightingRectZoomedDimension = new Dimension((int)(maxX - minX), (int)(maxY - minY));
        this.highlightingRectLeftUpPoint = new Point((int)minX, (int)minY);
    }

    private final void drawRectangle(Graphics2D g) {
        this.recalculateInternal();
        PreviewHighlightingRect previewHighlightingRect = this.highlightingRect;
        if (previewHighlightingRect == null) {
            return;
        }
        PreviewHighlightingRect rect = previewHighlightingRect;
        List<PreviewPoint> list = this.rectPoints;
        if (list == null) {
            return;
        }
        List<PreviewPoint> points = list;
        if (rect.getVisible()) {
            int n = points.size();
            for (int i = 1; i < n; ++i) {
                this.drawLine(points.get(i - 1).getX(), points.get(i - 1).getY(), points.get(i).getX(), points.get(i).getY(), g);
            }
            this.drawLine(points.get(points.size() - 1).getX(), points.get(points.size() - 1).getY(), points.get(0).getX(), points.get(0).getY(), g);
        }
    }

    private final PreviewHighlightingRect getZoomedRect(PreviewHighlightingRect rect) {
        List newPoints = new ArrayList();
        for (PreviewPoint point : rect.getPoints()) {
            newPoints.add(new PreviewPoint(point.getX() * this.imagePane.getZoomFactor() + (double)this.margin, point.getY() * this.imagePane.getZoomFactor() + (double)this.margin));
        }
        return new PreviewHighlightingRect(rect.getVisible(), newPoints);
    }

    private final void drawLine(double x1, double y1, double x2, double y2, Graphics2D g) {
        Color oldBg = g.getBackground();
        Color oldColor = g.getColor();
        Color lineColor = new Color(45, 162, 232);
        g.setBackground(lineColor);
        g.setColor(lineColor);
        LinePainter2D.paint((Graphics2D)g, (double)x1, (double)y1, (double)x2, (double)y2);
        g.setBackground(oldBg);
        g.setColor(oldColor);
    }
}

