/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.ui;

import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.reactive.Property;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.editor.ImageZoomModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010+\u001a\u00020\u0018H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020-H\u0016J\u000f\u00101\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020-H\u0016J\b\u00104\u001a\u00020-H\u0016J\u0010\u00105\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020/H\u0016J\b\u00106\u001a\u00020/H\u0016J\b\u00107\u001a\u00020/H\u0016J\b\u00108\u001a\u00020/H\u0016J\u0006\u00109\u001a\u00020-J\u0016\u0010:\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010;\u001a\u00020-J\n\u0010<\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010=\u001a\u00020\u000eH\u0016J\u0010\u0010>\u001a\u00020-2\u0006\u0010?\u001a\u00020@H\u0014J\u0006\u0010A\u001a\u00020-R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010%\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0013\u0010(\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006B"}, d2={"Lcom/jetbrains/rider/xaml/preview/ui/ImagePane;", "Ljavax/swing/JPanel;", "Lorg/intellij/images/editor/ImageZoomModel;", "<init>", "()V", "baseComponent", "Ljavax/swing/JComponent;", "getBaseComponent", "()Ljavax/swing/JComponent;", "setBaseComponent", "(Ljavax/swing/JComponent;)V", "image", "Ljava/awt/Image;", "sourceSize", "Ljava/awt/Dimension;", "leftUpPoint", "Ljava/awt/Point;", "rectangle", "Ljava/awt/Rectangle;", "getRectangle", "()Ljava/awt/Rectangle;", "setRectangle", "(Ljava/awt/Rectangle;)V", "zoomStep", "", "value", "zoomFactorInternal", "setZoomFactorInternal", "(D)V", "zoomFactorLive", "Lcom/jetbrains/rd/util/reactive/Property;", "getZoomFactorLive", "()Lcom/jetbrains/rd/util/reactive/Property;", "highlightingRectDelta", "", "getHighlightingRectDelta", "()I", "imageLeftUpPoint", "getImageLeftUpPoint", "()Ljava/awt/Point;", "imageSize", "getImageSize", "()Ljava/awt/Dimension;", "getZoomFactor", "setZoomFactor", "", "hasImage", "", "fitZoomToWindow", "getFitZoomFactor", "()Ljava/lang/Double;", "zoomOut", "zoomIn", "setZoomLevelChanged", "canZoomOut", "canZoomIn", "isZoomLevelChanged", "clear", "updateImage", "update", "getZoomedSize", "getPreferredSize", "paintComponent", "gr", "Ljava/awt/Graphics;", "recalculateImageCoords", "intellij.rider.plugins.xaml.preview"})
public final class ImagePane
extends JPanel
implements ImageZoomModel {
    public JComponent baseComponent;
    @Nullable
    private Image image;
    @Nullable
    private Dimension sourceSize;
    @Nullable
    private Point leftUpPoint;
    @Nullable
    private Rectangle rectangle;
    private final double zoomStep;
    private double zoomFactorInternal = 1.0;
    @NotNull
    private final Property<Double> zoomFactorLive;
    private final int highlightingRectDelta;

    public ImagePane() {
        this.zoomStep = 1.2;
        this.highlightingRectDelta = 5;
        this.setOpaque(false);
        this.zoomFactorLive = new Property((Object)1.0);
    }

    @NotNull
    public final JComponent getBaseComponent() {
        JComponent jComponent = this.baseComponent;
        if (jComponent != null) {
            return jComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"baseComponent");
        return null;
    }

    public final void setBaseComponent(@NotNull JComponent jComponent) {
        Intrinsics.checkNotNullParameter((Object)jComponent, (String)"<set-?>");
        this.baseComponent = jComponent;
    }

    @Nullable
    public final Rectangle getRectangle() {
        return this.rectangle;
    }

    public final void setRectangle(@Nullable Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    private final void setZoomFactorInternal(double value) {
        if (this.zoomFactorInternal == value) {
            return;
        }
        this.zoomFactorInternal = value;
        this.zoomFactorLive.set((Object)value);
        this.update();
    }

    @NotNull
    public final Property<Double> getZoomFactorLive() {
        return this.zoomFactorLive;
    }

    public final int getHighlightingRectDelta() {
        return this.highlightingRectDelta;
    }

    @Nullable
    public final Point getImageLeftUpPoint() {
        return this.leftUpPoint;
    }

    @Nullable
    public final Dimension getImageSize() {
        return this.sourceSize;
    }

    public double getZoomFactor() {
        return this.zoomFactorInternal;
    }

    public void setZoomFactor(double value) {
        this.setZoomFactorInternal(Math.max(0.125, Math.min(value, 8.0)));
    }

    public final boolean hasImage() {
        return this.image != null;
    }

    public void fitZoomToWindow() {
        Double zf = this.getFitZoomFactor();
        if (zf == null || Intrinsics.areEqual((Double)zf, (double)this.zoomFactorInternal)) {
            return;
        }
        this.setZoomFactor(zf);
    }

    private final Double getFitZoomFactor() {
        if (this.sourceSize == null) {
            return null;
        }
        double w = this.getBaseComponent().getWidth();
        double h = this.getBaseComponent().getHeight();
        Dimension dimension = this.sourceSize;
        Intrinsics.checkNotNull((Object)dimension);
        double d = w / (double)dimension.width;
        Dimension dimension2 = this.sourceSize;
        Intrinsics.checkNotNull((Object)dimension2);
        double idealFitZoomFactor = Math.min(d, h / (double)dimension2.height);
        double delta = (double)this.highlightingRectDelta * idealFitZoomFactor + (double)2;
        double newW = w - (double)2 * delta - (double)20;
        double newH = h - (double)2 * delta - (double)20;
        if (newW <= 0.0 || newH <= 0.0) {
            return null;
        }
        Dimension dimension3 = this.sourceSize;
        Intrinsics.checkNotNull((Object)dimension3);
        double d2 = newW / (double)dimension3.width;
        Dimension dimension4 = this.sourceSize;
        Intrinsics.checkNotNull((Object)dimension4);
        return Math.min(d2, newH / (double)dimension4.height);
    }

    public void zoomOut() {
        this.setZoomFactor(this.getZoomFactor() / this.zoomStep);
    }

    public void zoomIn() {
        this.setZoomFactor(this.getZoomFactor() * this.zoomStep);
    }

    public void setZoomLevelChanged(boolean value) {
    }

    public boolean canZoomOut() {
        return this.image != null && this.getZoomFactor() / this.zoomStep >= 0.125;
    }

    public boolean canZoomIn() {
        return this.image != null && this.getZoomFactor() * this.zoomStep <= 8.0;
    }

    public boolean isZoomLevelChanged() {
        if (this.image == null) {
            return false;
        }
        Double zf = this.getFitZoomFactor();
        return zf != null && !Intrinsics.areEqual((Double)zf, (double)this.zoomFactorInternal);
    }

    public final void clear() {
        this.image = null;
        this.sourceSize = null;
        this.setZoomFactorInternal(1.0);
    }

    public final void updateImage(@NotNull Image image, @NotNull Dimension sourceSize) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)sourceSize, (String)"sourceSize");
        this.image = image;
        this.sourceSize = sourceSize;
        this.update();
    }

    public final void update() {
        this.revalidate();
        this.repaint();
    }

    private final Dimension getZoomedSize() {
        if (this.image == null || this.sourceSize == null) {
            return null;
        }
        Dimension dimension = this.sourceSize;
        Intrinsics.checkNotNull((Object)dimension);
        int n = (int)((double)dimension.width * this.getZoomFactor());
        Dimension dimension2 = this.sourceSize;
        Intrinsics.checkNotNull((Object)dimension2);
        return (Dimension)new JBDimension(n, (int)((double)dimension2.height * this.getZoomFactor()));
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        JBDimension dimension = new JBDimension(this.getBaseComponent().getWidth(), this.getBaseComponent().getHeight());
        if (this.image == null) {
            return (Dimension)dimension;
        }
        Dimension dimension2 = this.getZoomedSize();
        if (dimension2 == null) {
            return (Dimension)dimension;
        }
        Dimension size = dimension2;
        int prefW = Math.max(size.width, this.getBaseComponent().getWidth());
        int prefH = Math.max(size.height, this.getBaseComponent().getHeight());
        return (Dimension)new JBDimension(prefW, prefH);
    }

    @Override
    protected void paintComponent(@NotNull Graphics gr) {
        Intrinsics.checkNotNullParameter((Object)gr, (String)"gr");
        super.paintComponent(gr);
        if (this.image == null) {
            return;
        }
        this.recalculateImageCoords();
        Point point = this.leftUpPoint;
        if (point == null) {
            return;
        }
        Point imageLeftUpPoint = point;
        Dimension dimension = this.getZoomedSize();
        if (dimension == null) {
            return;
        }
        Dimension zoomedSize = dimension;
        this.rectangle = new Rectangle(imageLeftUpPoint.x, imageLeftUpPoint.y, zoomedSize.width, zoomedSize.height);
        Image image = this.image;
        Intrinsics.checkNotNull((Object)image);
        UIUtil.drawImage((Graphics)gr, (Image)image, (Rectangle)this.rectangle, null, (ImageObserver)this);
    }

    public final void recalculateImageCoords() {
        Dimension dimension = this.getZoomedSize();
        if (dimension == null) {
            return;
        }
        Dimension zoomedSize = dimension;
        int imageLeftUpCornerX = (this.getWidth() - zoomedSize.width) / 2;
        int imageLeftUpCornerY = (this.getHeight() - zoomedSize.height) / 2;
        this.leftUpPoint = new Point(imageLeftUpCornerX, imageLeftUpCornerY);
    }
}

