/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.ui;

import com.jetbrains.dotCommon.externalAppToolWindow.inputHandlers.WindowInputHandlersBundle;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.FrameRenderer;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.Frame;
import com.jetbrains.rd.ide.model.BaseClientMessage;
import com.jetbrains.rd.ide.model.CloseWindow;
import com.jetbrains.rd.ide.model.ExternalAppInputModel;
import com.jetbrains.rd.ide.model.WindowHidden;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skiko.SkiaLayer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWidget;", "Lorg/jetbrains/skiko/SkiaLayer;", "inputModel", "Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "windowInputHandlersBundle", "Lcom/jetbrains/dotCommon/externalAppToolWindow/inputHandlers/WindowInputHandlersBundle;", "rdDispatcher", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "<init>", "(Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;Lcom/jetbrains/dotCommon/externalAppToolWindow/inputHandlers/WindowInputHandlersBundle;Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;)V", "remoteRenderer", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/FrameRenderer;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "scheduleFrame", "", "frame", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/Frame;", "close", "removeNotify", "dispose", "intellij.rider.plugins.dotCommon"})
public final class RemoteWidget
extends SkiaLayer {
    @NotNull
    private final ExternalAppInputModel inputModel;
    @NotNull
    private final WindowInputHandlersBundle windowInputHandlersBundle;
    @NotNull
    private final IRdDispatcher rdDispatcher;
    @NotNull
    private final FrameRenderer remoteRenderer;
    @NotNull
    private AtomicBoolean isClosed;

    public RemoteWidget(@NotNull ExternalAppInputModel inputModel, @NotNull WindowInputHandlersBundle windowInputHandlersBundle, @NotNull IRdDispatcher rdDispatcher) {
        Intrinsics.checkNotNullParameter((Object)inputModel, (String)"inputModel");
        Intrinsics.checkNotNullParameter((Object)windowInputHandlersBundle, (String)"windowInputHandlersBundle");
        Intrinsics.checkNotNullParameter((Object)rdDispatcher, (String)"rdDispatcher");
        super(null, true, true, null, null, null, 57, null);
        this.inputModel = inputModel;
        this.windowInputHandlersBundle = windowInputHandlersBundle;
        this.rdDispatcher = rdDispatcher;
        this.enableEvents(8L);
        this.setFocusTraversalKeysEnabled(false);
        this.addFocusListener(this.windowInputHandlersBundle.getWindowFocusListener());
        this.addMouseMotionListener(this.windowInputHandlersBundle.getMouseMotionListener());
        this.addMouseListener(this.windowInputHandlersBundle.getMouseAdapter());
        this.addMouseWheelListener(this.windowInputHandlersBundle.getMouseWheelListener());
        this.addKeyListener(this.windowInputHandlersBundle.getKeyListener());
        this.enableInputMethods(false);
        this.remoteRenderer = new FrameRenderer();
        this.setRenderDelegate(this.remoteRenderer);
        this.isClosed = new AtomicBoolean(false);
    }

    public final void scheduleFrame(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.remoteRenderer.setNextFrame(frame);
        this.needRedraw();
    }

    public final void close() {
        this.isClosed.set(true);
    }

    public void removeNotify() {
        this.remoteRenderer.dispose();
        this.setRenderDelegate(null);
        super.removeNotify();
    }

    public void dispose() {
        this.remoteRenderer.dispose();
        this.setRenderDelegate(null);
        this.removeFocusListener(this.windowInputHandlersBundle.getWindowFocusListener());
        this.removeMouseMotionListener(this.windowInputHandlersBundle.getMouseMotionListener());
        this.removeMouseListener(this.windowInputHandlersBundle.getMouseAdapter());
        this.removeMouseWheelListener(this.windowInputHandlersBundle.getMouseWheelListener());
        this.removeKeyListener(this.windowInputHandlersBundle.getKeyListener());
        BaseClientMessage msg = this.isClosed.get() ? (BaseClientMessage)new CloseWindow() : (BaseClientMessage)new WindowHidden();
        this.rdDispatcher.queue(() -> RemoteWidget.dispose$lambda$0(this, msg));
        super.dispose();
    }

    private static final Unit dispose$lambda$0(RemoteWidget this$0, BaseClientMessage $msg) {
        this$0.inputModel.getClientMessage().fire((Object)$msg);
        return Unit.INSTANCE;
    }
}

