/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.windows;

import com.intellij.util.io.ByteBufferUtil;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.Frame;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameSize;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.windows.WindowsFrameMapper;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.windows.nativeLib.Kernel32Ext;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinNT;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/windows/WindowsMemoryFrame;", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/Frame;", "frameSize", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;", "mapFileHandle", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "viewPtr", "Lcom/sun/jna/Pointer;", "frameMapper", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/windows/WindowsFrameMapper;", "<init>", "(Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;Lcom/sun/jna/platform/win32/WinNT$HANDLE;Lcom/sun/jna/Pointer;Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/windows/WindowsFrameMapper;)V", "frameContent", "Ljava/nio/ByteBuffer;", "size", "getSize", "()Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;", "content", "getContent", "()Ljava/nio/ByteBuffer;", "unmap", "", "mapToNewLocation", "location", "", "renderSizeHasChanged", "newRenderWidth", "", "newRenderHeight", "close", "intellij.rider.plugins.dotCommon"})
public final class WindowsMemoryFrame
implements Frame {
    @NotNull
    private FrameSize frameSize;
    @NotNull
    private final WinNT.HANDLE mapFileHandle;
    @NotNull
    private final Pointer viewPtr;
    @NotNull
    private final WindowsFrameMapper frameMapper;
    @NotNull
    private final ByteBuffer frameContent;

    public WindowsMemoryFrame(@NotNull FrameSize frameSize, @NotNull WinNT.HANDLE mapFileHandle, @NotNull Pointer viewPtr, @NotNull WindowsFrameMapper frameMapper) {
        Intrinsics.checkNotNullParameter((Object)frameSize, (String)"frameSize");
        Intrinsics.checkNotNullParameter((Object)mapFileHandle, (String)"mapFileHandle");
        Intrinsics.checkNotNullParameter((Object)viewPtr, (String)"viewPtr");
        Intrinsics.checkNotNullParameter((Object)frameMapper, (String)"frameMapper");
        this.frameSize = frameSize;
        this.mapFileHandle = mapFileHandle;
        this.viewPtr = viewPtr;
        this.frameMapper = frameMapper;
        ByteBuffer byteBuffer = this.viewPtr.getByteBuffer(0L, (long)this.frameSize.getBufferSize());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getByteBuffer(...)");
        this.frameContent = byteBuffer;
    }

    @Override
    @NotNull
    public FrameSize getSize() {
        return this.frameSize;
    }

    @Override
    @NotNull
    public ByteBuffer getContent() {
        return this.frameContent;
    }

    private final void unmap() {
        Kernel32Ext.Companion.getINSTANCE().UnmapViewOfFile(this.viewPtr);
        Kernel32Ext.Companion.getINSTANCE().CloseHandle(this.mapFileHandle);
        ByteBufferUtil.cleanBuffer((ByteBuffer)this.frameContent);
    }

    @Override
    @NotNull
    public Frame mapToNewLocation(@NotNull String location, @NotNull FrameSize size) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.unmap();
        return this.frameMapper.mapFrame(location, size);
    }

    @Override
    public void renderSizeHasChanged(int newRenderWidth, int newRenderHeight) {
        this.frameSize = this.frameSize.withRenderSize(newRenderWidth, newRenderHeight);
    }

    @Override
    public void close() {
        this.unmap();
    }
}

