/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.windows;

import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.Frame;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameMapper;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameSize;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.windows.WindowsMemoryFrame;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.windows.nativeLib.Kernel32Ext;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/windows/WindowsFrameMapper;", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameMapper;", "<init>", "()V", "mapFrame", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/Frame;", "frameLocation", "", "frameSize", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;", "intellij.rider.plugins.dotCommon"})
public final class WindowsFrameMapper
implements FrameMapper {
    @Override
    @NotNull
    public Frame mapFrame(@NotNull String frameLocation, @NotNull FrameSize frameSize) {
        Intrinsics.checkNotNullParameter((Object)frameLocation, (String)"frameLocation");
        Intrinsics.checkNotNullParameter((Object)frameSize, (String)"frameSize");
        Kernel32Ext kernel32 = Kernel32Ext.Companion.getINSTANCE();
        WinNT.HANDLE fileMapHandle = kernel32.OpenFileMapping(4, false, frameLocation);
        if (fileMapHandle == null) {
            throw new Win32Exception(Native.getLastError());
        }
        Pointer fileViewPtr = kernel32.MapViewOfFile(fileMapHandle, 4, 0, 0, 0);
        if (fileViewPtr == null) {
            throw new Win32Exception(Native.getLastError());
        }
        return new WindowsMemoryFrame(frameSize, fileMapHandle, fileViewPtr, this);
    }
}

