/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.macos;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.Frame;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameMapper;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameSize;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.NativeFrameMappingException;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.macos.MacOsFrame;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.macos.nativeLib.CLib;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/macos/MacOsFrameMapper;", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameMapper;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "generateError", "", "mapFrame", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/Frame;", "frameLocation", "", "frameSize", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;", "Companion", "intellij.rider.plugins.dotCommon"})
@SourceDebugExtension(value={"SMAP\nMacOsFrameMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacOsFrameMapper.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/macos/MacOsFrameMapper\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,57:1\n13#2:58\n15#3:59\n*S KotlinDebug\n*F\n+ 1 MacOsFrameMapper.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/macos/MacOsFrameMapper\n*L\n18#1:58\n18#1:59\n*E\n"})
public final class MacOsFrameMapper
implements FrameMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private static final int InvalidHandle = -1;
    private static final Pointer InvalidPointer = Pointer.createConstant((int)-1);

    public MacOsFrameMapper() {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MacOsFrameMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    private final void generateError() {
        int errCode = Native.getLastError();
        String errString = CLib.Companion.getINSTANCE().strerror(errCode);
        this.logger.error("Cannot open mapped frame object. Native Error code: " + errCode + "." + System.lineSeparator() + "Error message: " + errString);
        throw new NativeFrameMappingException(errCode, errString);
    }

    @Override
    @NotNull
    public Frame mapFrame(@NotNull String frameLocation, @NotNull FrameSize frameSize) {
        Pointer frameMapPtr;
        Intrinsics.checkNotNullParameter((Object)frameLocation, (String)"frameLocation");
        Intrinsics.checkNotNullParameter((Object)frameSize, (String)"frameSize");
        CLib cLib = CLib.Companion.getINSTANCE();
        int frameBufferSize = frameSize.getBufferSize();
        int shmHandle = cLib.shm_open(frameLocation, 0, 256);
        if (shmHandle == -1) {
            this.generateError();
        }
        if ((frameMapPtr = cLib.mmap(null, frameBufferSize, 1, 1, shmHandle, 0L)) == null || Intrinsics.areEqual((Object)frameMapPtr, (Object)InvalidPointer)) {
            this.generateError();
        }
        Pointer pointer = frameMapPtr;
        Intrinsics.checkNotNull((Object)pointer);
        return new MacOsFrame(frameLocation, frameSize, pointer, this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/macos/MacOsFrameMapper$Companion;", "", "<init>", "()V", "InvalidHandle", "", "InvalidPointer", "Lcom/sun/jna/Pointer;", "kotlin.jvm.PlatformType", "Lcom/sun/jna/Pointer;", "intellij.rider.plugins.dotCommon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

