/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;", "", "renderWidth", "", "renderHeight", "framebufferWidth", "framebufferHeight", "<init>", "(IIII)V", "getRenderWidth", "()I", "getRenderHeight", "getFramebufferWidth", "getFramebufferHeight", "bufferSize", "getBufferSize", "isTheSameRenderSize", "", "otherSize", "otherWidth", "otherHeight", "isTheSameFramebufferSize", "withRenderSize", "newRenderWidth", "newRenderHeight", "intellij.rider.plugins.dotCommon"})
@SourceDebugExtension(value={"SMAP\nFrameSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameSize.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n1#2:36\n*E\n"})
public final class FrameSize {
    private final int renderWidth;
    private final int renderHeight;
    private final int framebufferWidth;
    private final int framebufferHeight;
    private final int bufferSize;

    public FrameSize(int renderWidth, int renderHeight, int framebufferWidth, int framebufferHeight) {
        this.renderWidth = renderWidth;
        this.renderHeight = renderHeight;
        this.framebufferWidth = framebufferWidth;
        this.framebufferHeight = framebufferHeight;
        if (!(this.renderWidth > 0)) {
            boolean $i$a$-require-FrameSize$72 = false;
            String $i$a$-require-FrameSize$72 = "Render width should be a positive number";
            throw new IllegalArgumentException($i$a$-require-FrameSize$72.toString());
        }
        if (!(this.renderHeight > 0)) {
            boolean $i$a$-require-FrameSize$82 = false;
            String $i$a$-require-FrameSize$82 = "Render height should be a positive number";
            throw new IllegalArgumentException($i$a$-require-FrameSize$82.toString());
        }
        if (!(this.framebufferWidth > 0)) {
            boolean $i$a$-require-FrameSize$92 = false;
            String $i$a$-require-FrameSize$92 = "Framebuffer width should be a positive number";
            throw new IllegalArgumentException($i$a$-require-FrameSize$92.toString());
        }
        if (!(this.framebufferHeight > 0)) {
            boolean $i$a$-require-FrameSize$102 = false;
            String $i$a$-require-FrameSize$102 = "Framebuffer height should be a positive number";
            throw new IllegalArgumentException($i$a$-require-FrameSize$102.toString());
        }
        if (!(this.renderWidth <= this.framebufferWidth)) {
            boolean $i$a$-require-FrameSize$112 = false;
            String $i$a$-require-FrameSize$112 = "Render width cannot be greater than framebuffer width";
            throw new IllegalArgumentException($i$a$-require-FrameSize$112.toString());
        }
        if (!(this.renderHeight <= this.framebufferHeight)) {
            boolean bl = false;
            String string = "Render height cannot be greater than framebuffer height";
            throw new IllegalArgumentException(string.toString());
        }
        this.bufferSize = this.framebufferWidth * this.framebufferHeight * 4;
    }

    public final int getRenderWidth() {
        return this.renderWidth;
    }

    public final int getRenderHeight() {
        return this.renderHeight;
    }

    public final int getFramebufferWidth() {
        return this.framebufferWidth;
    }

    public final int getFramebufferHeight() {
        return this.framebufferHeight;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final boolean isTheSameRenderSize(@NotNull FrameSize otherSize) {
        Intrinsics.checkNotNullParameter((Object)otherSize, (String)"otherSize");
        return this.renderWidth == otherSize.renderWidth && this.renderHeight == otherSize.renderHeight;
    }

    public final boolean isTheSameRenderSize(int otherWidth, int otherHeight) {
        return this.renderWidth == otherWidth && this.renderHeight == otherHeight;
    }

    public final boolean isTheSameFramebufferSize(@NotNull FrameSize otherSize) {
        Intrinsics.checkNotNullParameter((Object)otherSize, (String)"otherSize");
        return this.framebufferWidth == otherSize.framebufferWidth && this.framebufferHeight == otherSize.framebufferHeight;
    }

    @NotNull
    public final FrameSize withRenderSize(int newRenderWidth, int newRenderHeight) {
        return new FrameSize(newRenderWidth, newRenderHeight, this.framebufferWidth, this.framebufferHeight);
    }
}

