/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.Frame;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameMapper;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameSize;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.linux.LinuxFrameMapper;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.macos.MacOsFrameMapper;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.persistentMemoryMappedFile.PersistentMemoryFrameMapper;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.windows.WindowsFrameMapper;
import com.jetbrains.rd.ide.model.InitFramebufferMessage;
import com.jetbrains.rd.ide.model.NewFrameMessage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\fj\u0002`\rJ\u0006\u0010\u001e\u001a\u00020\nJ\n\u0010\u001f\u001a\u00060\fj\u0002`\rJ\u0012\u0010 \u001a\u00020\u001c2\n\u0010!\u001a\u00060\fj\u0002`\rJ\u0012\u0010\"\u001a\u00020\u001c2\n\u0010!\u001a\u00060\fj\u0002`\rJ\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u001cH\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020(H\u0002J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020(J\u0006\u0010*\u001a\u00020\u001cJ\u0012\u0010+\u001a\u00020\u001c2\n\u0010,\u001a\u00060\fj\u0002`\rJ\u0006\u0010-\u001a\u00020\u001cJ\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00130/2\n\u0010,\u001a\u00060\fj\u0002`\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u0018\u0012\b\u0012\u00060\fj\u0002`\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameBufferStorageChannel;", "", "frameCount", "", "<init>", "(I)V", "lockObj", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "disposed", "", "owner", "Ljava/util/UUID;", "Lcom/jetbrains/rd/util/UUID;", "availableFrames", "currentFrameIdx", "writeIdx", "rawMappedFrames", "", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/Frame;", "[Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/Frame;", "frameMapper", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameMapper;", "frameChannels", "", "Lkotlinx/coroutines/channels/Channel;", "chooseFrameMapper", "acquireOwnership", "", "newOwner", "isDisposed", "getCurrentOwner", "registerWindow", "id", "closeWindowChannel", "nextFrameAvailable", "msg", "Lcom/jetbrains/rd/ide/model/NewFrameMessage;", "resetPosition", "resizeInternal", "Lcom/jetbrains/rd/ide/model/InitFramebufferMessage;", "resize", "dispose", "frameRead", "windowId", "skipFrame", "getFrameChannel", "Lkotlinx/coroutines/channels/ReceiveChannel;", "intellij.rider.plugins.dotCommon"})
@SourceDebugExtension(value={"SMAP\nFrameBufferStorageChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameBufferStorageChannel.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameBufferStorageChannel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 Channel.kt\nkotlinx/coroutines/channels/ChannelKt\n*L\n1#1,221:1\n1#2:222\n13#3:223\n15#4:224\n539#5,5:225\n*S KotlinDebug\n*F\n+ 1 FrameBufferStorageChannel.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameBufferStorageChannel\n*L\n48#1:223\n48#1:224\n140#1:225,5\n*E\n"})
public final class FrameBufferStorageChannel {
    private final int frameCount;
    @NotNull
    private final Object lockObj;
    @NotNull
    private final Logger logger;
    private boolean disposed;
    @NotNull
    private UUID owner;
    private int availableFrames;
    private int currentFrameIdx;
    private int writeIdx;
    @NotNull
    private final Frame[] rawMappedFrames;
    @NotNull
    private final FrameMapper frameMapper;
    @NotNull
    private final Map<UUID, Channel<Frame>> frameChannels;

    public FrameBufferStorageChannel(int frameCount) {
        this.frameCount = frameCount;
        if (!(this.frameCount > 0)) {
            boolean $i$a$-require-FrameBufferStorageChannel$22 = false;
            String $i$a$-require-FrameBufferStorageChannel$22 = "FrameCount parameter should be a positive number";
            throw new IllegalArgumentException($i$a$-require-FrameBufferStorageChannel$22.toString());
        }
        this.lockObj = new Object();
        this.writeIdx = 0;
        this.currentFrameIdx = 0;
        this.availableFrames = 0;
        this.disposed = false;
        this.rawMappedFrames = new Frame[this.frameCount];
        this.frameMapper = this.chooseFrameMapper();
        this.frameChannels = new LinkedHashMap();
        this.owner = UUID.fromString("00000000-0000-0000-0000-000000000000");
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrameBufferStorageChannel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    private final FrameMapper chooseFrameMapper() {
        if (SystemInfo.isWindows) {
            return new WindowsFrameMapper();
        }
        if (SystemInfo.isLinux) {
            return new LinuxFrameMapper();
        }
        if (SystemInfo.isMac) {
            return new MacOsFrameMapper();
        }
        return new PersistentMemoryFrameMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void acquireOwnership(@NotNull UUID newOwner) {
        Intrinsics.checkNotNullParameter((Object)newOwner, (String)"newOwner");
        Object object = this.lockObj;
        synchronized (object) {
            block8: {
                block7: {
                    boolean bl = false;
                    if (!this.frameChannels.containsKey(newOwner)) {
                        boolean bl2 = false;
                        String string = "Window '" + newOwner + "' should be registered in framebuffer channel before taking ownership";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (Intrinsics.areEqual((Object)this.owner, (Object)newOwner)) break block7;
                    if (!this.disposed) break block8;
                }
                return;
            }
            this.owner = newOwner;
            this.resetPosition();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDisposed() {
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.disposed;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final UUID getCurrentOwner() {
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            UUID uUID = this.owner;
            return uUID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerWindow(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            if (!(!this.frameChannels.containsKey(id))) {
                boolean bl2 = false;
                String string = "Window with id '" + id + "' is already registered";
                throw new IllegalArgumentException(string.toString());
            }
            this.frameChannels.put(id, (Channel<Frame>)ChannelKt.Channel$default((int)this.frameCount, null, null, (int)6, null));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeWindowChannel(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            if (!this.frameChannels.containsKey(id)) {
                boolean bl2 = false;
                String string = "Window with id '" + id + "' is not registered in framebuffer storage";
                throw new IllegalArgumentException(string.toString());
            }
            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)MapsKt.getValue(this.frameChannels, (Object)id)), null, (int)1, null);
            Channel<Frame> channel = this.frameChannels.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void nextFrameAvailable(@NotNull NewFrameMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Frame frame = null;
        Channel<Frame> frameChannel = null;
        Object object = this.lockObj;
        synchronized (object) {
            int n;
            int n2 = 0;
            if (this.disposed) {
                return;
            }
            if (!Intrinsics.areEqual((Object)this.owner, (Object)msg.getWindowId())) {
                return;
            }
            int n3 = n = this.availableFrames != this.frameCount ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl = false;
                String string = "Synchronization issue: new frame shouldn't arrive when framebuffer is full";
                throw new AssertionError((Object)string);
            }
            Channel<Frame> channel = this.frameChannels.get(msg.getWindowId());
            if (channel == null) {
                return;
            }
            frameChannel = channel;
            Frame frame2 = this.rawMappedFrames[this.writeIdx];
            Intrinsics.checkNotNull((Object)frame2);
            frame = frame2;
            if (!frame.getSize().isTheSameRenderSize(msg.getRenderWidth(), msg.getRenderHeight())) {
                frame.renderSizeHasChanged(msg.getRenderWidth(), msg.getRenderHeight());
            }
            this.rawMappedFrames[this.writeIdx] = frame;
            this.writeIdx = (this.writeIdx + 1) % this.frameCount;
            n = this.availableFrames;
            this.availableFrames = n + 1;
            n2 = n;
        }
        Object $this$onFailure_u2dWpGqRn0$iv = ChannelsKt.trySendBlocking((SendChannel)((SendChannel)frameChannel), (Object)frame);
        boolean bl = false;
        if ($this$onFailure_u2dWpGqRn0$iv instanceof ChannelResult.Failed) {
            Throwable it = ChannelResult.exceptionOrNull-impl((Object)$this$onFailure_u2dWpGqRn0$iv);
            boolean bl2 = false;
            this.logger.info("Frame channel has been cancelled");
        }
    }

    private final void resetPosition() {
        this.writeIdx = 0;
        this.currentFrameIdx = 0;
        this.availableFrames = 0;
    }

    private final void resizeInternal(InitFramebufferMessage msg) {
        int n = this.frameCount;
        for (int i = 0; i < n; ++i) {
            Frame frame = this.rawMappedFrames[i];
            FrameSize frameSize = new FrameSize(msg.getRenderWidth(), msg.getRenderHeight(), msg.getFramebufferWidth(), msg.getFramebufferHeight());
            this.rawMappedFrames[i] = frame == null ? this.frameMapper.mapFrame((String)msg.getBufferLocations().get(i), frameSize) : frame.mapToNewLocation((String)msg.getBufferLocations().get(i), frameSize);
        }
        this.resetPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resize(@NotNull InitFramebufferMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            if (!(msg.getBufferLocations().size() == this.frameCount)) {
                boolean bl2 = false;
                String string = "BufferLocations count should align with declared frame buffer size";
                throw new IllegalArgumentException(string.toString());
            }
            if (!this.disposed) {
                this.resizeInternal(msg);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            if (!this.disposed) {
                this.disposed = true;
                int n = this.frameCount;
                for (int i = 0; i < n; ++i) {
                    Frame frame = this.rawMappedFrames[i];
                    if (frame == null) continue;
                    frame.close();
                }
                for (Channel<Frame> frameChannel : this.frameChannels.values()) {
                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)frameChannel), null, (int)1, null);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void frameRead(@NotNull UUID windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)this.owner, (Object)windowId)) {
                return;
            }
            this.currentFrameIdx = (this.currentFrameIdx + 1) % this.frameCount;
            int n = this.availableFrames;
            this.availableFrames = n + -1;
            int n2 = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void skipFrame() {
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            this.currentFrameIdx = (this.currentFrameIdx + 1) % this.frameCount;
            this.writeIdx = (this.writeIdx + 1) % this.frameCount;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ReceiveChannel<Frame> getFrameChannel(@NotNull UUID windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            if (!this.frameChannels.containsKey(windowId)) {
                boolean bl2 = false;
                String string = "Window '" + windowId + "' should be registered in framebuffer channel";
                throw new IllegalArgumentException(string.toString());
            }
            ReceiveChannel receiveChannel = (ReceiveChannel)MapsKt.getValue(this.frameChannels, (Object)windowId);
            return receiveChannel;
        }
    }
}

