/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow;

import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.dotCommon.externalAppToolWindow.common.ObjectExtensionsKt;
import com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow.RemoteDocumentWindow;
import com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow.RemoteDocumentWindowFile;
import com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow.RemoteDocumentWindowInternals;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameBufferStorageChannel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.LoadingPanel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWindow;
import com.jetbrains.rd.ide.model.RiderWindowState;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.awt.Dimension;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalIgnoreDependencyViolation
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/remoteDocumentWindow/RemoteDocumentWindowProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "openedWindows", "", "Ljava/util/UUID;", "Lcom/jetbrains/dotCommon/externalAppToolWindow/remoteDocumentWindow/RemoteDocumentWindowInternals;", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "closeFile", "", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.rider.plugins.dotCommon"})
public final class RemoteDocumentWindowProvider
implements FileEditorProvider,
DumbAware {
    @NotNull
    private final Map<UUID, RemoteDocumentWindowInternals> openedWindows = new LinkedHashMap();

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof RemoteDocumentWindowFile;
    }

    private final void closeFile(VirtualFile file, Project project) {
        FileEditorManagerEx fileManager = FileEditorManagerEx.Companion.getInstanceEx(project);
        block0: for (EditorWindow editorWindow : fileManager.getWindows()) {
            EditorComposite composite = editorWindow.getComposite(file);
            if (composite == null) continue;
            for (FileEditor editor : composite.getAllEditors()) {
                if (!(editor instanceof RemoteDocumentWindow) || !Intrinsics.areEqual((Object)((RemoteDocumentWindow)editor).getFile(), (Object)file)) continue;
                FileEditorManagerEx.Companion.getInstanceEx(project).closeFile(file, editorWindow);
                continue block0;
            }
        }
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RemoteDocumentWindowFile remoteDocWindowFile = (RemoteDocumentWindowFile)file;
        LifetimeDefinition docWindowLifetimeDef = remoteDocWindowFile.getWindowLifetimeDef();
        if (this.openedWindows.containsKey(remoteDocWindowFile.getWindowId())) {
            boolean isReopen = ObjectExtensionsKt.falseIfNull((Boolean)remoteDocWindowFile.getUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN));
            if (!isReopen) {
                remoteDocWindowFile.putUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN, true);
                this.closeFile(file, project);
                remoteDocWindowFile.putUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN, null);
            }
            RemoteDocumentWindowInternals windowInternals = (RemoteDocumentWindowInternals)MapsKt.getValue(this.openedWindows, (Object)remoteDocWindowFile.getWindowId());
            return new RemoteDocumentWindow(windowInternals.getRemoteWindow(), remoteDocWindowFile, this.openedWindows, windowInternals.getFileLifetimeDef());
        }
        FrameBufferStorageChannel framebufferStorage = new FrameBufferStorageChannel(2);
        LoadingPanel loadingPanel = new LoadingPanel(new Dimension(0, 0), docWindowLifetimeDef.getLifetime());
        RemoteWindow remoteWindow = new RemoteWindow(project, remoteDocWindowFile.getWindowId(), remoteDocWindowFile.getWindowTitle(), loadingPanel, framebufferStorage, remoteDocWindowFile.getInputModel(), remoteDocWindowFile.getRenderModel(), docWindowLifetimeDef.getLifetime(), remoteDocWindowFile.getDispatcher(), remoteDocWindowFile.getOnWindowShownCallback(), remoteDocWindowFile.getOnWindowClosedCallback(), (Function0<Unit>)((Function0)() -> RemoteDocumentWindowProvider.createEditor$lambda$0(project, file)));
        this.openedWindows.put(remoteDocWindowFile.getWindowId(), new RemoteDocumentWindowInternals(remoteWindow, docWindowLifetimeDef));
        remoteDocWindowFile.getInputModel().getWindowState().advise(docWindowLifetimeDef.getLifetime(), arg_0 -> RemoteDocumentWindowProvider.createEditor$lambda$5(docWindowLifetimeDef, file, this, remoteDocWindowFile, project, arg_0));
        docWindowLifetimeDef.onTermination(() -> RemoteDocumentWindowProvider.createEditor$lambda$6(this, file, project, framebufferStorage));
        return new RemoteDocumentWindow(remoteWindow, remoteDocWindowFile, this.openedWindows, docWindowLifetimeDef);
    }

    @NotNull
    public String getEditorTypeId() {
        return "remote-document-window-provider";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    private static final Unit createEditor$lambda$0(Project $project, VirtualFile $file) {
        FileEditorManager.getInstance((Project)$project).openFile($file, true);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$5$lambda$1(VirtualFile $file, RemoteDocumentWindowProvider this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((RemoteDocumentWindowFile)$file).rename(this$0, it);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$5$lambda$2(RemoteDocumentWindowFile $remoteDocWindowFile, String it) {
        $remoteDocWindowFile.updateIcon(it);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$5$lambda$3(LifetimeDefinition $docWindowLifetimeDef, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $docWindowLifetimeDef.terminate(true);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$5$lambda$4(Project $project, RemoteDocumentWindowFile $remoteDocWindowFile, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FileEditorManagerEx.Companion.getInstanceEx($project).openFile((VirtualFile)$remoteDocWindowFile, true, true);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$5(LifetimeDefinition $docWindowLifetimeDef, VirtualFile $file, RemoteDocumentWindowProvider this$0, RemoteDocumentWindowFile $remoteDocWindowFile, Project $project, RiderWindowState windowState) {
        Intrinsics.checkNotNullParameter((Object)windowState, (String)"windowState");
        windowState.getWindowTitle().advise($docWindowLifetimeDef.getLifetime(), arg_0 -> RemoteDocumentWindowProvider.createEditor$lambda$5$lambda$1($file, this$0, arg_0));
        windowState.getWindowIcon().advise($docWindowLifetimeDef.getLifetime(), arg_0 -> RemoteDocumentWindowProvider.createEditor$lambda$5$lambda$2($remoteDocWindowFile, arg_0));
        windowState.getClose().advise($docWindowLifetimeDef.getLifetime(), arg_0 -> RemoteDocumentWindowProvider.createEditor$lambda$5$lambda$3($docWindowLifetimeDef, arg_0));
        windowState.getFocusInIde().advise($docWindowLifetimeDef.getLifetime(), arg_0 -> RemoteDocumentWindowProvider.createEditor$lambda$5$lambda$4($project, $remoteDocWindowFile, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$6(RemoteDocumentWindowProvider this$0, VirtualFile $file, Project $project, FrameBufferStorageChannel $framebufferStorage) {
        this$0.closeFile($file, $project);
        $framebufferStorage.dispose();
        return Unit.INSTANCE;
    }
}

