/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow;

import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.WindowTitle;
import com.jetbrains.rd.ide.model.ExternalAppInputModel;
import com.jetbrains.rd.ide.model.ExternalAppServerModel;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.util.UUID;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0012\u0010/\u001a\u00020\u00142\b\u00101\u001a\u0004\u0018\u00010*H\u0002J\u0010\u00102\u001a\u00020\u00142\b\u00101\u001a\u0004\u0018\u00010*J\u001a\u00103\u001a\u00020\u00142\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020*H\u0016J\b\u00107\u001a\u00020*H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u00068"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/remoteDocumentWindow/RemoteDocumentWindowFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "windowTitle", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;", "windowId", "Ljava/util/UUID;", "inputModel", "Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "renderModel", "Lcom/jetbrains/rd/ide/model/ExternalAppServerModel;", "iconClassLoader", "Ljava/lang/ClassLoader;", "dispatcher", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "windowLifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "onWindowShownCallback", "Lkotlin/Function0;", "", "onWindowClosedCallback", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;Ljava/util/UUID;Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;Lcom/jetbrains/rd/ide/model/ExternalAppServerModel;Ljava/lang/ClassLoader;Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getWindowTitle", "()Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;", "getWindowId", "()Ljava/util/UUID;", "getInputModel", "()Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "getRenderModel", "()Lcom/jetbrains/rd/ide/model/ExternalAppServerModel;", "getDispatcher", "()Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "getWindowLifetimeDef", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getOnWindowShownCallback", "()Lkotlin/jvm/functions/Function0;", "getOnWindowClosedCallback", "title", "", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "setIcon", "(Ljavax/swing/Icon;)V", "iconPath", "updateIcon", "rename", "requestor", "", "newName", "getName", "intellij.rider.plugins.dotCommon"})
public final class RemoteDocumentWindowFile
extends LightVirtualFile {
    @NotNull
    private final Project project;
    @NotNull
    private final WindowTitle windowTitle;
    @NotNull
    private final UUID windowId;
    @NotNull
    private final ExternalAppInputModel inputModel;
    @NotNull
    private final ExternalAppServerModel renderModel;
    @NotNull
    private final ClassLoader iconClassLoader;
    @NotNull
    private final IRdDispatcher dispatcher;
    @NotNull
    private final LifetimeDefinition windowLifetimeDef;
    @NotNull
    private final Function0<Unit> onWindowShownCallback;
    @NotNull
    private final Function0<Unit> onWindowClosedCallback;
    @NotNull
    private String title;
    @Nullable
    private Icon icon;

    public RemoteDocumentWindowFile(@NotNull Project project, @NotNull WindowTitle windowTitle, @NotNull UUID windowId, @NotNull ExternalAppInputModel inputModel, @NotNull ExternalAppServerModel renderModel, @NotNull ClassLoader iconClassLoader, @NotNull IRdDispatcher dispatcher, @NotNull LifetimeDefinition windowLifetimeDef, @NotNull Function0<Unit> onWindowShownCallback, @NotNull Function0<Unit> onWindowClosedCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)windowTitle, (String)"windowTitle");
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        Intrinsics.checkNotNullParameter((Object)inputModel, (String)"inputModel");
        Intrinsics.checkNotNullParameter((Object)renderModel, (String)"renderModel");
        Intrinsics.checkNotNullParameter((Object)iconClassLoader, (String)"iconClassLoader");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)windowLifetimeDef, (String)"windowLifetimeDef");
        Intrinsics.checkNotNullParameter(onWindowShownCallback, (String)"onWindowShownCallback");
        Intrinsics.checkNotNullParameter(onWindowClosedCallback, (String)"onWindowClosedCallback");
        this.project = project;
        this.windowTitle = windowTitle;
        this.windowId = windowId;
        this.inputModel = inputModel;
        this.renderModel = renderModel;
        this.iconClassLoader = iconClassLoader;
        this.dispatcher = dispatcher;
        this.windowLifetimeDef = windowLifetimeDef;
        this.onWindowShownCallback = onWindowShownCallback;
        this.onWindowClosedCallback = onWindowClosedCallback;
        this.title = this.windowTitle.getTitle();
        this.setIcon(this.windowTitle.getIcon());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final WindowTitle getWindowTitle() {
        return this.windowTitle;
    }

    @NotNull
    public final UUID getWindowId() {
        return this.windowId;
    }

    @NotNull
    public final ExternalAppInputModel getInputModel() {
        return this.inputModel;
    }

    @NotNull
    public final ExternalAppServerModel getRenderModel() {
        return this.renderModel;
    }

    @NotNull
    public final IRdDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    public final LifetimeDefinition getWindowLifetimeDef() {
        return this.windowLifetimeDef;
    }

    @NotNull
    public final Function0<Unit> getOnWindowShownCallback() {
        return this.onWindowShownCallback;
    }

    @NotNull
    public final Function0<Unit> getOnWindowClosedCallback() {
        return this.onWindowClosedCallback;
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    public final void setIcon(@Nullable Icon icon) {
        this.icon = icon;
    }

    private final void setIcon(String iconPath) {
        this.icon = iconPath != null ? IconLoader.getIcon((String)iconPath, (ClassLoader)this.iconClassLoader) : null;
    }

    public final void updateIcon(@Nullable String iconPath) {
        this.setIcon(iconPath);
        FileEditorManagerEx.Companion.getInstanceEx(this.project).updateFilePresentation((VirtualFile)this);
    }

    public void rename(@Nullable Object requestor, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (Intrinsics.areEqual((Object)this.title, (Object)newName)) {
            return;
        }
        this.title = newName;
        FileEditorManagerEx.Companion.getInstanceEx(this.project).updateFilePresentation((VirtualFile)this);
    }

    @NotNull
    public String getName() {
        return this.title;
    }
}

