/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.modalWindow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameBufferStorageChannel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.LoadingPanel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWindow;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.WindowTitle;
import com.jetbrains.rd.ide.model.ExternalAppInputModel;
import com.jetbrains.rd.ide.model.ExternalAppServerModel;
import com.jetbrains.rd.ide.model.InitialResolution;
import com.jetbrains.rd.ide.model.RiderWindowState;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.awt.Dimension;
import java.util.UUID;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0014J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\n\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0014J\b\u0010 \u001a\u00020!H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/modalWindow/RemoteModalWindow;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "windowTitle", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;", "windowId", "Ljava/util/UUID;", "Lcom/jetbrains/rd/util/UUID;", "inputModel", "Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "renderModel", "Lcom/jetbrains/rd/ide/model/ExternalAppServerModel;", "dispatcher", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "initialResulution", "Lcom/jetbrains/rd/ide/model/InitialResolution;", "windowLifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;Ljava/util/UUID;Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;Lcom/jetbrains/rd/ide/model/ExternalAppServerModel;Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;Lcom/jetbrains/rd/ide/model/InitialResolution;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "remoteWindow", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWindow;", "subscribeInputEvents", "", "windowLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "dispose", "createRemoteWindow", "createSouthPanel", "", "createNorthPanel", "createCenterPanel", "Ljavax/swing/JComponent;", "Companion", "intellij.rider.plugins.dotCommon"})
public final class RemoteModalWindow
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final WindowTitle windowTitle;
    @NotNull
    private final UUID windowId;
    @NotNull
    private final ExternalAppInputModel inputModel;
    @NotNull
    private final ExternalAppServerModel renderModel;
    @NotNull
    private final IRdDispatcher dispatcher;
    @Nullable
    private InitialResolution initialResulution;
    @NotNull
    private final LifetimeDefinition windowLifetimeDef;
    @NotNull
    private final RemoteWindow remoteWindow;
    private static final int ExtendedWidth = 50;
    private static final int ExtendedHeight = 50;

    public RemoteModalWindow(@NotNull Project project, @NotNull WindowTitle windowTitle, @NotNull UUID windowId, @NotNull ExternalAppInputModel inputModel, @NotNull ExternalAppServerModel renderModel, @NotNull IRdDispatcher dispatcher, @Nullable InitialResolution initialResulution, @NotNull LifetimeDefinition windowLifetimeDef) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)windowTitle, (String)"windowTitle");
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        Intrinsics.checkNotNullParameter((Object)inputModel, (String)"inputModel");
        Intrinsics.checkNotNullParameter((Object)renderModel, (String)"renderModel");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)windowLifetimeDef, (String)"windowLifetimeDef");
        super(project, false, DialogWrapper.IdeModalityType.IDE);
        this.project = project;
        this.windowTitle = windowTitle;
        this.windowId = windowId;
        this.inputModel = inputModel;
        this.renderModel = renderModel;
        this.dispatcher = dispatcher;
        this.initialResulution = initialResulution;
        this.windowLifetimeDef = windowLifetimeDef;
        this.setResizable(true);
        if (this.initialResulution == null) {
            this.initialResulution = new InitialResolution(500, 200);
        }
        this.setTitle(this.windowTitle.getTitle());
        Lifetime windowLifetime = this.windowLifetimeDef.getLifetime();
        this.remoteWindow = this.createRemoteWindow(windowLifetime);
        InitialResolution initialResolution = this.initialResulution;
        Intrinsics.checkNotNull((Object)initialResolution);
        int n = initialResolution.getWidth() + 50;
        InitialResolution initialResolution2 = this.initialResulution;
        Intrinsics.checkNotNull((Object)initialResolution2);
        super.setSize(n, initialResolution2.getHeight() + 50);
        windowLifetime.onTermination(() -> RemoteModalWindow._init_$lambda$0(this));
        this.subscribeInputEvents(windowLifetime);
        this.init();
    }

    private final void subscribeInputEvents(Lifetime windowLifetime) {
        this.inputModel.getWindowState().advise(windowLifetime, arg_0 -> RemoteModalWindow.subscribeInputEvents$lambda$2(windowLifetime, this, arg_0));
    }

    protected void dispose() {
        super.dispose();
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.windowLifetimeDef, (boolean)false, (int)1, null);
    }

    private final RemoteWindow createRemoteWindow(Lifetime windowLifetime) {
        FrameBufferStorageChannel framebufferStorage = new FrameBufferStorageChannel(2);
        LoadingPanel loadingPanel = new LoadingPanel(new Dimension(0, 0), windowLifetime);
        return new RemoteWindow(this.project, this.windowId, this.windowTitle, loadingPanel, framebufferStorage, this.inputModel, this.renderModel, windowLifetime, this.dispatcher, (Function0<Unit>)((Function0)RemoteModalWindow::createRemoteWindow$lambda$3), (Function0<Unit>)((Function0)RemoteModalWindow::createRemoteWindow$lambda$4), (Function0<Unit>)((Function0)RemoteModalWindow::createRemoteWindow$lambda$5));
    }

    @Nullable
    protected Void createSouthPanel() {
        return null;
    }

    @Nullable
    protected Void createNorthPanel() {
        return null;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.remoteWindow;
    }

    private static final Unit _init_$lambda$0(RemoteModalWindow this$0) {
        this$0.remoteWindow.close();
        return Unit.INSTANCE;
    }

    private static final Unit subscribeInputEvents$lambda$2$lambda$1(RemoteModalWindow this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        super.doCancelAction();
        return Unit.INSTANCE;
    }

    private static final Unit subscribeInputEvents$lambda$2(Lifetime $windowLifetime, RemoteModalWindow this$0, RiderWindowState winState) {
        Intrinsics.checkNotNullParameter((Object)winState, (String)"winState");
        winState.getClose().advise($windowLifetime, arg_0 -> RemoteModalWindow.subscribeInputEvents$lambda$2$lambda$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createRemoteWindow$lambda$3() {
        return Unit.INSTANCE;
    }

    private static final Unit createRemoteWindow$lambda$4() {
        return Unit.INSTANCE;
    }

    private static final Unit createRemoteWindow$lambda$5() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/modalWindow/RemoteModalWindow$Companion;", "", "<init>", "()V", "ExtendedWidth", "", "ExtendedHeight", "intellij.rider.plugins.dotCommon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

