/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.jetbrains.dotCommon.externalAppToolWindow.actions.ActionDataContextConstants;
import com.jetbrains.dotCommon.externalAppToolWindow.actions.RemoteActionDataContext;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWindow;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Component;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J9\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0011\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H$\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/actions/BaseRemoteAction;", "TAppModel", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "tryFindWindowId", "Ljava/util/UUID;", "Lcom/jetbrains/rd/util/UUID;", "component", "Ljava/awt/Component;", "actionPerformed", "windowId", "model", "project", "Lcom/intellij/openapi/project/Project;", "processLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Ljava/util/UUID;Ljava/lang/Object;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "intellij.rider.plugins.dotCommon"})
public abstract class BaseRemoteAction<TAppModel>
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setVisible(false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final UUID tryFindWindowId(Component component) {
        for (Component currentComponent = component; currentComponent != null; currentComponent = (Component)currentComponent.getParent()) {
            if (!(currentComponent instanceof RemoteWindow)) continue;
            return ((RemoteWindow)currentComponent).getWindowId();
        }
        return null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!(e.getDataContext() instanceof RemoteActionDataContext)) {
            return;
        }
        Object appModel = e.getDataContext().getData(DataKey.Companion.create(ActionDataContextConstants.Companion.getRiderAppModel()));
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project = DataContextKt.getProject((DataContext)dataContext);
        Lifetime lifetime = (Lifetime)e.getDataContext().getData(DataKey.Companion.create(ActionDataContextConstants.Companion.getProcessLifetime()));
        Component component = WindowManager.getInstance().getFocusedComponent(project);
        if (component == null) {
            return;
        }
        Component component2 = component;
        UUID uUID = this.tryFindWindowId(component2);
        if (uUID == null) {
            return;
        }
        UUID windowId = uUID;
        if (appModel == null || project == null || lifetime == null) {
            return;
        }
        this.actionPerformed(e, windowId, appModel, project, lifetime);
    }

    protected abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull UUID var2, TAppModel var3, @NotNull Project var4, @NotNull Lifetime var5);
}

