/*
 * Decompiled with CFR 0.152.
 */
package intellij.rider.plugins.debuggerLinq;

import com.intellij.debugger.streams.core.lib.LibrarySupport;
import com.intellij.debugger.streams.core.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.core.trace.CollectionTreeBuilder;
import com.intellij.debugger.streams.core.trace.TraceExpressionBuilder;
import com.intellij.debugger.streams.core.trace.XValueInterpreter;
import com.intellij.debugger.streams.core.trace.dsl.Dsl;
import com.intellij.debugger.streams.core.trace.dsl.StatementFactory;
import com.intellij.debugger.streams.core.trace.dsl.impl.DslImpl;
import com.intellij.debugger.streams.core.wrapper.StreamChainBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import intellij.rider.plugins.debuggerLinq.CSharpCollectionTreeBuilder;
import intellij.rider.plugins.debuggerLinq.CSharpValueInterpreter;
import intellij.rider.plugins.debuggerLinq.LinqChainBuilder;
import intellij.rider.plugins.debuggerLinq.LinqSequencesSupport;
import intellij.rider.plugins.debuggerLinq.LinqStatementFactory;
import intellij.rider.plugins.debuggerLinq.LinqTraceExpressionBuilder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lintellij/rider/plugins/debuggerLinq/LinqSupportProvider;", "Lcom/intellij/debugger/streams/core/lib/LibrarySupportProvider;", "<init>", "()V", "getLanguageId", "", "builder", "Lcom/intellij/debugger/streams/core/wrapper/StreamChainBuilder;", "support", "Lcom/intellij/debugger/streams/core/lib/LibrarySupport;", "getSupport", "()Lcom/intellij/debugger/streams/core/lib/LibrarySupport;", "support$delegate", "Lkotlin/Lazy;", "dsl", "Lcom/intellij/debugger/streams/core/trace/dsl/impl/DslImpl;", "getDsl", "()Lcom/intellij/debugger/streams/core/trace/dsl/impl/DslImpl;", "dsl$delegate", "getChainBuilder", "getLibrarySupport", "getExpressionBuilder", "Lcom/intellij/debugger/streams/core/trace/TraceExpressionBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "getXValueInterpreter", "Lcom/intellij/debugger/streams/core/trace/XValueInterpreter;", "getCollectionTreeBuilder", "Lcom/intellij/debugger/streams/core/trace/CollectionTreeBuilder;", "intellij.rider.plugins.debuggerLinq"})
public final class LinqSupportProvider
implements LibrarySupportProvider {
    @NotNull
    private final StreamChainBuilder builder = new LinqChainBuilder();
    @NotNull
    private final Lazy support$delegate = LazyKt.lazy(LinqSupportProvider::support_delegate$lambda$0);
    @NotNull
    private final Lazy dsl$delegate = LazyKt.lazy(LinqSupportProvider::dsl_delegate$lambda$1);

    @NotNull
    public String getLanguageId() {
        if (Registry.Companion.is("rider.debugger.enable.linq.plugin")) {
            String string = CSharpLanguage.INSTANCE.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            return string;
        }
        return "<LINQ Debugger plugin is disabled via Registry>";
    }

    private final LibrarySupport getSupport() {
        Lazy lazy = this.support$delegate;
        return (LibrarySupport)lazy.getValue();
    }

    private final DslImpl getDsl() {
        Lazy lazy = this.dsl$delegate;
        return (DslImpl)lazy.getValue();
    }

    @NotNull
    public StreamChainBuilder getChainBuilder() {
        return this.builder;
    }

    @NotNull
    public LibrarySupport getLibrarySupport() {
        return this.getSupport();
    }

    @NotNull
    public TraceExpressionBuilder getExpressionBuilder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (TraceExpressionBuilder)new LinqTraceExpressionBuilder((Dsl)this.getDsl(), this.getSupport().createHandlerFactory((Dsl)this.getDsl()));
    }

    @NotNull
    public XValueInterpreter getXValueInterpreter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new CSharpValueInterpreter(project);
    }

    @NotNull
    public CollectionTreeBuilder getCollectionTreeBuilder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new CSharpCollectionTreeBuilder(project);
    }

    private static final LinqSequencesSupport support_delegate$lambda$0() {
        return new LinqSequencesSupport();
    }

    private static final DslImpl dsl_delegate$lambda$1() {
        return new DslImpl((StatementFactory)new LinqStatementFactory());
    }
}

