/*
 * Decompiled with CFR 0.152.
 */
package intellij.rider.plugins.debuggerLinq;

import com.intellij.debugger.streams.core.trace.ArrayReference;
import com.intellij.debugger.streams.core.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.TraceInfo;
import com.intellij.debugger.streams.core.trace.Value;
import com.intellij.debugger.streams.core.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.core.trace.impl.interpret.CollectIdentityTraceInterpreter;
import com.intellij.debugger.streams.core.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.core.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.core.wrapper.StreamCall;
import intellij.rider.plugins.debuggerLinq.CSharpPeekCallTraceInterpreter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lintellij/rider/plugins/debuggerLinq/CSharpCollectIdentityTraceInterpreter;", "Lcom/intellij/debugger/streams/core/trace/CallTraceInterpreter;", "<init>", "()V", "myPeekResolver", "Lintellij/rider/plugins/debuggerLinq/CSharpPeekCallTraceInterpreter;", "resolve", "Lcom/intellij/debugger/streams/core/trace/TraceInfo;", "call", "Lcom/intellij/debugger/streams/core/wrapper/StreamCall;", "value", "Lcom/intellij/debugger/streams/core/trace/Value;", "intellij.rider.plugins.debuggerLinq"})
public final class CSharpCollectIdentityTraceInterpreter
implements CallTraceInterpreter {
    @NotNull
    private final CSharpPeekCallTraceInterpreter myPeekResolver = new CSharpPeekCallTraceInterpreter();

    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call, @NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof ArrayReference)) {
            throw new UnexpectedValueTypeException("Array reference expected. But " + value.typeName() + " received");
        }
        Value value2 = ((ArrayReference)value).getValue(0);
        Intrinsics.checkNotNull((Object)value2);
        TraceInfo resolved = this.myPeekResolver.resolve(call, value2);
        Map map2 = resolved.getValuesOrderBefore();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getValuesOrderBefore(...)");
        Map before = map2;
        if (before.isEmpty()) {
            return resolved;
        }
        int timeAfter = CollectIdentityTraceInterpreter.extractTime((ArrayReference)((ArrayReference)value)) + 1;
        PrimitiveIterator.OfInt ofInt = IntStreamEx.of((Collection)before.keySet()).sorted().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)ofInt, (String)"iterator(...)");
        PrimitiveIterator.OfInt iterator = ofInt;
        Map after = new HashMap(before.size());
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        while (iterator.hasNext()) {
            TraceElement elementBefore;
            Integer timeBefore = iterator.next();
            TraceElement traceElement = elementBefore = (TraceElement)before.get(timeBefore);
            Intrinsics.checkNotNull((Object)traceElement);
            TraceElement elementAfter = (TraceElement)new TraceElementImpl(timeAfter, traceElement.getValue());
            direct.put(elementBefore, CollectionsKt.listOf((Object)elementAfter));
            reverse.put(elementAfter, CollectionsKt.listOf((Object)elementBefore));
            Integer n = timeAfter;
            after.put(n, elementAfter);
            ++timeAfter;
        }
        return (TraceInfo)new ValuesOrderInfo(call, before, after, direct, reverse);
    }
}

