/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.javascript.nodejs;

import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonNotifierConfiguration;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.util.ThreeState;
import com.jetbrains.rider.plugins.appender.javascript.RiderProjectModelWebFilesCollector;
import com.jetbrains.rider.plugins.appender.javascript.nodejs.RiderPackageJsonConfiguratorHandler;
import com.jetbrains.rider.projectView.projectTemplates.utils.ExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.workspaceModel.WorkspaceUserModelUpdater;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator;", "Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonNotifierConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "detectPackageJsonFiles", "Lorg/jetbrains/concurrency/Promise;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "findInDirectory", "file", "Ljava/io/File;", "findInProject", "projectEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "isEssential", "", "packageJson", "isNpmPackageJson", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderPackageJsonConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderPackageJsonConfigurator.kt\ncom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1#2:86\n1755#3,3:87\n*S KotlinDebug\n*F\n+ 1 RiderPackageJsonConfigurator.kt\ncom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator\n*L\n73#1:87,3\n*E\n"})
public final class RiderPackageJsonConfigurator
implements PackageJsonNotifierConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private static final ExtensionPointName<RiderPackageJsonConfiguratorHandler> EP_NAME = ExtensionPointName.Companion.create("JavaScript.packageJson.configuration.handler");

    public RiderPackageJsonConfigurator(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public Promise<List<VirtualFile>> detectPackageJsonFiles() {
        if (this.project.isDefault()) {
            return Promises.resolvedPromise((Object)CollectionsKt.emptyList());
        }
        return RdCoroutinesUtilKt.toPromise((Deferred)BuildersKt.async$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends VirtualFile>>, Object>(this, null){
            int label;
            final /* synthetic */ RiderPackageJsonConfigurator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WorkspaceUserModelUpdater store = WorkspaceUserModelUpdater.Companion.getInstance(this.this$0.getProject());
                        RiderProjectModelWebFilesCollector visitor2 = new RiderProjectModelWebFilesCollector(this.this$0.getProject(), store);
                        this.label = 1;
                        Object object3 = visitor2.collectAllFiles((Function1<? super File, ? extends VirtualFile>)((Function1)new Function1<File, VirtualFile>((Object)this.this$0){

                            public final VirtualFile invoke(File p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                return RiderPackageJsonConfigurator.access$findInDirectory((RiderPackageJsonConfigurator)this.receiver, p0);
                            }
                        }), (Function1<? super ProjectModelEntity, ? extends VirtualFile>)((Function1)new Function1<ProjectModelEntity, VirtualFile>((Object)this.this$0){

                            public final VirtualFile invoke(ProjectModelEntity p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                return RiderPackageJsonConfigurator.access$findInProject((RiderPackageJsonConfigurator)this.receiver, p0);
                            }
                        }), (Continuation<? super List<? extends VirtualFile>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends VirtualFile>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
    }

    private final VirtualFile findInDirectory(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile directory = virtualFile2;
        while (!directory.is(VFileProperty.SYMLINK)) {
            VirtualFile[] virtualFileArray = directory.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            VirtualFile virtualFile3 = (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFileArray);
            boolean bl = virtualFile3 != null ? virtualFile3.isDirectory() : false;
            if (!bl) break;
            directory = directory.getChildren()[0];
        }
        return PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory);
    }

    private final VirtualFile findInProject(ProjectModelEntity projectEntity) {
        VirtualFile packageJsonInProject;
        boolean bl = ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)projectEntity);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-RiderPackageJsonConfigurator$findInProject$22 = false;
            String $i$a$-assert-RiderPackageJsonConfigurator$findInProject$22 = "Entity should be a project entity";
            throw new AssertionError((Object)$i$a$-assert-RiderPackageJsonConfigurator$findInProject$22);
        }
        VirtualFile virtualFile2 = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)projectEntity);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile directory = virtualFile2;
        VirtualFile virtualFile3 = packageJsonInProject = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory);
        if (virtualFile3 != null) {
            return virtualFile3;
        }
        return PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory.findChild("ClientApp"));
    }

    public boolean isEssential(@NotNull VirtualFile packageJson) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
            if (this.project.isDefault()) {
                return false;
            }
            ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.firstOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.project), (VirtualFile)packageJson, (Project)this.project));
            if (projectModelEntity == null) {
                return false;
            }
            ProjectModelEntity fileNode = projectModelEntity;
            ProjectModelEntity projectNode = ExtensionsKt.findParent((ProjectModelEntity)fileNode, RiderPackageJsonConfigurator::isEssential$lambda$1);
            if (projectNode != null && Intrinsics.areEqual((Object)this.findInProject(projectNode), (Object)packageJson)) {
                return true;
            }
            WorkspaceUserModelUpdater store = WorkspaceUserModelUpdater.Companion.getInstance(this.project);
            Iterable $this$any$iv = (Iterable)store.getExplicitIncludes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)packageJson, (Object)this.findInDirectory(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNpmPackageJson(@NotNull VirtualFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        if (this.project.isDefault()) {
            return false;
        }
        for (RiderPackageJsonConfiguratorHandler handler : EP_NAME.getExtensionList((AreaInstance)this.project)) {
            ThreeState isPackageNpmJson = handler.isNpmPackageJson(packageJson);
            if (isPackageNpmJson == ThreeState.UNSURE) continue;
            return isPackageNpmJson.toBoolean();
        }
        return true;
    }

    private static final Boolean isEssential$lambda$1(ProjectModelEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)it);
    }

    public static final /* synthetic */ VirtualFile access$findInDirectory(RiderPackageJsonConfigurator $this, File file) {
        return $this.findInDirectory(file);
    }

    public static final /* synthetic */ VirtualFile access$findInProject(RiderPackageJsonConfigurator $this, ProjectModelEntity projectEntity) {
        return $this.findInProject(projectEntity);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfiguratorHandler;", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

