/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.featuretrainer.lessons;

import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.plugins.appender.featuretrainer.RiderLessonsBundle;
import java.awt.Component;
import java.awt.Dialog;
import java.util.Map;
import javax.swing.JDialog;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.dsl.TaskTestContext;
import training.learn.LessonsBundle;
import training.learn.course.KLesson;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/appender/featuretrainer/lessons/CSharpRenameLesson;", "Ltraining/learn/course/KLesson;", "<init>", "()V", "initialName", "", "template", "sample", "Ltraining/dsl/LessonSample;", "replaceTemplate", "name", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nCSharpRenameLesson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CSharpRenameLesson.kt\ncom/jetbrains/rider/plugins/appender/featuretrainer/lessons/CSharpRenameLesson\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class CSharpRenameLesson
extends KLesson {
    @NotNull
    private final String initialName;
    @NotNull
    private final String template;
    @NotNull
    private final LessonSample sample;
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent;

    public CSharpRenameLesson() {
        super("Refactorings.Rename", LessonsBundle.INSTANCE.message("rename.lesson.name", new Object[0]));
        this.initialName = "Name";
        this.template = "// ReSharper disable CheckNamespace\n// ReSharper disable UnusedType.Global\n// ReSharper disable ClassNeverInstantiated.Local\n// ReSharper disable UnusedAutoPropertyAccessor.Local\n#pragma warning disable CS8618\n\nusing System;\n\ninternal class Sample\n{\n    private Sample(Person person, Car car)\n    {\n        Console.WriteLine($\"Look, {person.Name} has a new {car.<caret><name>}.\");\n    }\n\n    private class Person\n    {\n        public string Name { get; set; }\n    }\n\n    private class Car\n    {\n        public string <name> { get; set; }\n    }\n}    \n";
        this.sample = LessonSampleKt.parseLessonSample((String)this.replaceTemplate(this.initialName));
        this.lessonContent = arg_0 -> CSharpRenameLesson.lessonContent$lambda$10(this, arg_0);
    }

    private final String replaceTemplate(String name) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)this.template, (String)"<name>", (String)name, (boolean)false, (int)4, null), (String)"<name2>", (String)StringsKt.capitalize((String)name), (boolean)false, (int)4, null);
    }

    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.mapOf((Pair)new Pair((Object)LessonsBundle.INSTANCE.message("rename.help.link", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink("Refactorings__Rename.html")));
    }

    private static final TaskContext.RestoreNotification lessonContent$lambda$10$lambda$2$lambda$0(CSharpRenameLesson this$0, TaskRuntimeContext $this$proposeRestore) {
        Intrinsics.checkNotNullParameter((Object)$this$proposeRestore, (String)"$this$proposeRestore");
        return LessonUtil.checkExpectedStateOfEditor$default((LessonUtil)LessonUtil.INSTANCE, (TaskRuntimeContext)$this$proposeRestore, (LessonSample)this$0.sample, (boolean)false, null, (int)4, null);
    }

    private static final Unit lessonContent$lambda$10$lambda$2$lambda$1(String $it, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        String[] stringArray = new String[]{$it};
        $this$test.actions(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$10$lambda$2(Ref.ObjectRef $startId, CSharpRenameLesson this$0, TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $startId.element = $this$task.getTaskId();
        Object[] objectArray = new Object[]{$this$task.action(it), $this$task.code(this$0.initialName)};
        TaskContext.text$default((TaskContext)$this$task, (String)RiderLessonsBundle.INSTANCE.message("rename.press.rename", objectArray), null, (int)2, null);
        objectArray = new String[]{it};
        $this$task.triggers((String[])objectArray);
        $this$task.proposeRestore(arg_0 -> CSharpRenameLesson.lessonContent$lambda$10$lambda$2$lambda$0(this$0, arg_0));
        TaskContext.test$default((TaskContext)$this$task, (boolean)false, arg_0 -> CSharpRenameLesson.lessonContent$lambda$10$lambda$2$lambda$1(it, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final boolean lessonContent$lambda$10$lambda$5$lambda$4(TaskRuntimeContext $this$stateCheck) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        Component component2 = $this$stateCheck.getFocusOwner();
        if (component2 != null) {
            Component fo = component2;
            boolean bl = false;
            JDialog jDialog = (JDialog)UIUtil.getParentOfType(JDialog.class, (Component)fo);
            component2 = jDialog;
            if (jDialog != null) {
                string = ((Dialog)component2).getTitle();
                return Intrinsics.areEqual(string, (Object)RiderLessonsBundle.INSTANCE.message("rename.dialog.title", new Object[0]));
            }
        }
        string = null;
        return Intrinsics.areEqual(string, (Object)RiderLessonsBundle.INSTANCE.message("rename.dialog.title", new Object[0]));
    }

    private static final Unit lessonContent$lambda$10$lambda$5(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.stateCheck(CSharpRenameLesson::lessonContent$lambda$10$lambda$5$lambda$4);
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$10$lambda$9$lambda$6(CSharpRenameLesson this$0, TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return $this$stateCheck.getFocusOwner() instanceof EditorComponentImpl && !Intrinsics.areEqual((Object)$this$stateCheck.getEditor().getDocument().getText(), (Object)this$0.sample.getText());
    }

    private static final boolean lessonContent$lambda$10$lambda$9$lambda$7(CSharpRenameLesson this$0, TaskRuntimeContext $this$restoreAfterStateBecomeFalse) {
        Intrinsics.checkNotNullParameter((Object)$this$restoreAfterStateBecomeFalse, (String)"$this$restoreAfterStateBecomeFalse");
        return $this$restoreAfterStateBecomeFalse.getFocusOwner() instanceof EditorComponentImpl && Intrinsics.areEqual((Object)$this$restoreAfterStateBecomeFalse.getEditor().getDocument().getText(), (Object)this$0.sample.getText());
    }

    private static final Unit lessonContent$lambda$10$lambda$9$lambda$8(String $newNameExample, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        $this$test.type($newNameExample);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$10$lambda$9(String $newNameExample, Ref.ObjectRef $startId, CSharpRenameLesson this$0, TaskContext $this$task) {
        TaskContext.TaskId taskId;
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.stateCheck(arg_0 -> CSharpRenameLesson.lessonContent$lambda$10$lambda$9$lambda$6(this$0, arg_0));
        Object[] objectArray = new Object[]{$this$task.code($newNameExample), LessonUtil.INSTANCE.rawEnter()};
        TaskContext.text$default((TaskContext)$this$task, (String)RiderLessonsBundle.INSTANCE.message("rename.type.new.name", objectArray), null, (int)2, null);
        if ($startId.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startId");
            taskId = null;
        } else {
            taskId = (TaskContext.TaskId)$startId.element;
        }
        LessonUtilKt.restoreAfterStateBecomeFalse((TaskContext)$this$task, (TaskContext.TaskId)taskId, arg_0 -> CSharpRenameLesson.lessonContent$lambda$10$lambda$9$lambda$7(this$0, arg_0));
        $this$task.test(false, arg_0 -> CSharpRenameLesson.lessonContent$lambda$10$lambda$9$lambda$8($newNameExample, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$10(CSharpRenameLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        String newNameExample = "BrandName";
        LessonContext.prepareSample$default((LessonContext)lessonContext, (LessonSample)this$0.sample, (boolean)false, (int)2, null);
        LessonUtilKt.showWarningIfInplaceRefactoringsDisabled((LessonContext)lessonContext);
        Ref.ObjectRef startId = new Ref.ObjectRef();
        lessonContext.task("RenameElement", (arg_0, arg_1) -> CSharpRenameLesson.lessonContent$lambda$10$lambda$2(startId, this$0, arg_0, arg_1));
        lessonContext.task(CSharpRenameLesson::lessonContent$lambda$10$lambda$5);
        lessonContext.task(arg_0 -> CSharpRenameLesson.lessonContent$lambda$10$lambda$9(newNameExample, startId, this$0, arg_0));
        lessonContext.text(RiderLessonsBundle.INSTANCE.message("rename.epilogue", new Object[0]));
        LessonUtilKt.restoreRefactoringOptionsInformer((LessonContext)lessonContext);
        return Unit.INSTANCE;
    }
}

