/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.featuretrainer.lessons;

import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.RefactoringBundle;
import com.jetbrains.rd.ui.bindable.views.customControls.TextBoxControlJb;
import com.jetbrains.rider.plugins.appender.featuretrainer.RiderLessonsBundle;
import com.jetbrains.rider.plugins.appender.featuretrainer.RiderLessonsUtilsKt;
import java.awt.Component;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.learn.LessonsBundle;
import training.learn.course.KLesson;
import training.util.UtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\u0012\u001a\u00020\t*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R%\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\u0002\b\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/plugins/appender/featuretrainer/lessons/CSharpRefactoringMenuLesson;", "Ltraining/learn/course/KLesson;", "<init>", "()V", "sample", "Ltraining/dsl/LessonSample;", "getSample", "()Ltraining/dsl/LessonSample;", "prepare", "", "project", "Lcom/intellij/openapi/project/Project;", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "restoreIfIntentionsPopupClosed", "Ltraining/dsl/TaskContext;", "restoreId", "Ltraining/dsl/TaskContext$TaskId;", "helpLinks", "", "", "getHelpLinks", "()Ljava/util/Map;", "intellij.rider.plugins.appender"})
public final class CSharpRefactoringMenuLesson
extends KLesson {
    @NotNull
    private final LessonSample sample;
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent;

    public CSharpRefactoringMenuLesson() {
        String string = RefactoringBundle.message((String)"refactor.this.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super("rider.refactoring.menu", string);
        this.sample = LessonSampleKt.parseLessonSample((String)"// ReSharper disable MemberCanBePrivate.Global\n// ReSharper disable UnusedType.Global\n// ReSharper disable ReturnTypeCanBeEnumerable.Local\n// ReSharper disable UnusedMember.Local\n// ReSharper disable MemberCanBeMadeStatic.Global\nnamespace Learning;\n\npublic class Re<caret>factorings\n{\n  public string[] ReadStrings()\n  {\n    return System.IO.File.ReadAllLines(\"input.txt\");\n  }\n  \n  public void PrintStrings()\n  {\n    var array = ReadStrings();\n    var filtered = array.Where(x => !string.IsNullOrEmpty(x)).ToArray();\n    foreach (var str in filtered)\n    {\n      Console.WriteLine(str);\n    }\n  }\n}     ");
        this.lessonContent = arg_0 -> CSharpRefactoringMenuLesson.lessonContent$lambda$8(this, arg_0);
    }

    @NotNull
    public final LessonSample getSample() {
        return this.sample;
    }

    public void prepare(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.prepare(project);
        RiderLessonsUtilsKt.restoreNuGetPackages();
    }

    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    private final void restoreIfIntentionsPopupClosed(TaskContext $this$restoreIfIntentionsPopupClosed, TaskContext.TaskId restoreId) {
        TaskContext.restoreState$default((TaskContext)$this$restoreIfIntentionsPopupClosed, (TaskContext.TaskId)restoreId, (int)LessonUtilKt.getDefaultRestoreDelay(), null, CSharpRefactoringMenuLesson::restoreIfIntentionsPopupClosed$lambda$9, (int)4, null);
    }

    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.mapOf((Pair)new Pair((Object)RiderLessonsBundle.INSTANCE.message("help.refactor.this", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink("Refactor_This.html")));
    }

    private static final Unit lessonContent$lambda$8$lambda$0(Ref.ObjectRef $showIntentionsTaskId, CSharpRefactoringMenuLesson this$0, TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $showIntentionsTaskId.element = $this$task.getTaskId();
        Object[] objectArray = new Object[]{$this$task.action(it)};
        TaskContext.text$default((TaskContext)$this$task, (String)LessonsBundle.INSTANCE.message("refactoring.menu.show.refactoring.list", objectArray), null, (int)2, null);
        $this$task.trigger(it);
        LessonUtil.INSTANCE.restoreIfModifiedOrMovedIncorrectly($this$task, "Refactorings", this$0.sample);
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$8$lambda$2$lambda$1(TaskRuntimeContext $this$listItem, Object item) {
        Intrinsics.checkNotNullParameter((Object)$this$listItem, (String)"$this$listItem");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return UtilsKt.isToStringContains((Object)item, (String)"Extract Interface");
    }

    private static final Unit lessonContent$lambda$8$lambda$2(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null).listItem(CSharpRefactoringMenuLesson::lessonContent$lambda$8$lambda$2$lambda$1);
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$8$lambda$4$lambda$3(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        Component component2 = $this$stateCheck.getFocusOwner();
        TextBoxControlJb textBoxControlJb = component2 instanceof TextBoxControlJb ? (TextBoxControlJb)component2 : null;
        return Intrinsics.areEqual((Object)(textBoxControlJb != null ? textBoxControlJb.getText() : null), (Object)"IRefactorings");
    }

    private static final Unit lessonContent$lambda$8$lambda$4(CSharpRefactoringMenuLesson this$0, Ref.ObjectRef $showIntentionsTaskId, TaskContext $this$task) {
        TaskContext.TaskId taskId;
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.strong("Extract Interface")};
        TaskContext.text$default((TaskContext)$this$task, (String)RiderLessonsBundle.INSTANCE.message("refactoring.menu.extract.interface", objectArray), null, (int)2, null);
        $this$task.stateCheck(CSharpRefactoringMenuLesson::lessonContent$lambda$8$lambda$4$lambda$3);
        if ($showIntentionsTaskId.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showIntentionsTaskId");
            taskId = null;
        } else {
            taskId = (TaskContext.TaskId)$showIntentionsTaskId.element;
        }
        this$0.restoreIfIntentionsPopupClosed($this$task, taskId);
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$8$lambda$6$lambda$5(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return $this$stateCheck.getFocusOwner() instanceof EditorComponentImpl;
    }

    private static final Unit lessonContent$lambda$8$lambda$6(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TaskContext.text$default((TaskContext)$this$task, (String)RiderLessonsBundle.INSTANCE.message("refactoring.menu.extract.interface.dialog", new Object[0]), null, (int)2, null);
        $this$task.stateCheck(CSharpRefactoringMenuLesson::lessonContent$lambda$8$lambda$6$lambda$5);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$8$lambda$7(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$task.action(it)};
        TaskContext.text$default((TaskContext)$this$task, (String)RiderLessonsBundle.INSTANCE.message("refactoring.menu.finish", objectArray), null, (int)2, null);
        $this$task.trigger(it);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$8(CSharpRefactoringMenuLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        LessonContext.prepareSample$default((LessonContext)lessonContext, (LessonSample)this$0.sample, (boolean)false, (int)2, null);
        LessonUtilKt.showWarningIfInplaceRefactoringsDisabled((LessonContext)lessonContext);
        String refactorThisActionId = "Refactorings.QuickListPopupAction";
        Ref.ObjectRef showIntentionsTaskId = new Ref.ObjectRef();
        lessonContext.task(refactorThisActionId, (arg_0, arg_1) -> CSharpRefactoringMenuLesson.lessonContent$lambda$8$lambda$0(showIntentionsTaskId, this$0, arg_0, arg_1));
        lessonContext.task(CSharpRefactoringMenuLesson::lessonContent$lambda$8$lambda$2);
        lessonContext.task(arg_0 -> CSharpRefactoringMenuLesson.lessonContent$lambda$8$lambda$4(this$0, showIntentionsTaskId, arg_0));
        lessonContext.task("IntroduceParameter", CSharpRefactoringMenuLesson::lessonContent$lambda$8$lambda$6);
        lessonContext.task(refactorThisActionId, CSharpRefactoringMenuLesson::lessonContent$lambda$8$lambda$7);
        return Unit.INSTANCE;
    }

    private static final boolean restoreIfIntentionsPopupClosed$lambda$9(TaskRuntimeContext $this$restoreState) {
        Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$this$restoreState");
        return $this$restoreState.getFocusOwner() instanceof EditorComponentImpl;
    }
}

