/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.plugins.appender.docker.common.DockerContainerType;
import com.jetbrains.rider.plugins.appender.docker.common.DockerExecutionInstruction;
import com.jetbrains.rider.plugins.appender.docker.deployment.RiderDockerDeploymentModel;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00072\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\"\u0010\u0016\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getContainerExecutable", "", "", "entrypoint", "Lcom/jetbrains/rider/plugins/appender/docker/common/DockerExecutionInstruction;", "cmd", "isLinuxContainer", "", "isInstructionInShellForm", "instruction", "os", "Lcom/jetbrains/rider/plugins/appender/docker/common/DockerContainerType;", "getActualExecutionCommand", "command", "getPossibleExecutable", "Ljava/io/File;", "dockerDeploymentModel", "Lcom/jetbrains/rider/plugins/appender/docker/deployment/RiderDockerDeploymentModel;", "getPossibleProjectAssembly", "getPossibleExecutableAndAssembly", "Lkotlin/Pair;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDockerExecutableUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerExecutableUtils.kt\ncom/jetbrains/rider/plugins/appender/docker/utils/DockerExecutableUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,118:1\n1#2:119\n69#3,4:120\n69#3,4:124\n*S KotlinDebug\n*F\n+ 1 DockerExecutableUtils.kt\ncom/jetbrains/rider/plugins/appender/docker/utils/DockerExecutableUtilsKt\n*L\n94#1:120,4\n115#1:124,4\n*E\n"})
public final class DockerExecutableUtilsKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> getContainerExecutable(@Nullable DockerExecutionInstruction<String> entrypoint, @Nullable DockerExecutionInstruction<String> cmd, boolean isLinuxContainer) {
        DockerExecutionInstruction<String> dockerExecutionInstruction;
        if (entrypoint == null && cmd == null) {
            return null;
        }
        if (entrypoint != null) {
            List list;
            if (!entrypoint.isInExecForm()) {
                List list2;
                if (isLinuxContainer) {
                    var4_3 = new String[]{"/bin/sh", "-c"};
                    list2 = CollectionsKt.mutableListOf((Object[])var4_3);
                } else {
                    var4_3 = new String[]{"cmd", "/S", "/C"};
                    list2 = CollectionsKt.mutableListOf((Object[])var4_3);
                }
                List result2 = list2;
                result2.addAll((Collection)entrypoint.getCommand());
                return result2;
            }
            if (cmd == null) {
                list = entrypoint.getCommand();
            } else if (!cmd.isInExecForm()) {
                List result3 = new ArrayList();
                result3.addAll((Collection)entrypoint.getCommand());
                if (isLinuxContainer) {
                    result3.add("/bin/sh");
                    v2 = result3.add("-c");
                } else {
                    result3.add("cmd");
                    result3.add("/S");
                    v2 = result3.add("/C");
                }
                result3.addAll((Collection)cmd.getCommand());
                list = result3;
            } else {
                List result4 = new ArrayList();
                result4.addAll((Collection)entrypoint.getCommand());
                result4.addAll((Collection)cmd.getCommand());
                list = result4;
            }
            return list;
        }
        DockerExecutionInstruction<String> dockerExecutionInstruction2 = cmd;
        boolean bl = dockerExecutionInstruction2 != null ? !dockerExecutionInstruction2.isInExecForm() : false;
        if (bl) {
            void var3_8;
            List list;
            if (isLinuxContainer) {
                var4_4 = new String[]{"/bin/sh", "-c"};
                list = CollectionsKt.mutableListOf((Object[])var4_4);
            } else {
                var4_4 = new String[]{"cmd", "/S", "/C"};
                list = CollectionsKt.mutableListOf((Object[])var4_4);
            }
            List result5 = list;
            result5.addAll((Collection)cmd.getCommand());
            dockerExecutionInstruction = var3_8;
        } else {
            dockerExecutionInstruction = cmd;
            if (dockerExecutionInstruction == null || (dockerExecutionInstruction = dockerExecutionInstruction.getCommand()) == null) {
                dockerExecutionInstruction = CollectionsKt.emptyList();
            }
        }
        return dockerExecutionInstruction;
    }

    public static /* synthetic */ List getContainerExecutable$default(DockerExecutionInstruction dockerExecutionInstruction, DockerExecutionInstruction dockerExecutionInstruction2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return DockerExecutableUtilsKt.getContainerExecutable(dockerExecutionInstruction, dockerExecutionInstruction2, bl);
    }

    public static final boolean isInstructionInShellForm(@NotNull List<String> instruction, @NotNull DockerContainerType os) {
        Intrinsics.checkNotNullParameter(instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        return os == DockerContainerType.Linux ? instruction.size() >= 2 && Intrinsics.areEqual((Object)instruction.get(0), (Object)"/bin/sh") && Intrinsics.areEqual((Object)instruction.get(1), (Object)"-c") : instruction.size() >= 3 && Intrinsics.areEqual((Object)instruction.get(0), (Object)"cmd") && Intrinsics.areEqual((Object)instruction.get(1), (Object)"/S") && Intrinsics.areEqual((Object)instruction.get(2), (Object)"/C");
    }

    @NotNull
    public static final List<String> getActualExecutionCommand(@NotNull List<String> command, @NotNull DockerContainerType os) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        if (!DockerExecutableUtilsKt.isInstructionInShellForm(command, os)) {
            return command;
        }
        if (os == DockerContainerType.Linux) {
            return CollectionsKt.drop((Iterable)command, (int)2);
        }
        return CollectionsKt.drop((Iterable)command, (int)3);
    }

    @Nullable
    public static final File getPossibleExecutable(@NotNull RiderDockerDeploymentModel dockerDeploymentModel) {
        File file;
        String executable;
        Intrinsics.checkNotNullParameter((Object)dockerDeploymentModel, (String)"dockerDeploymentModel");
        Pair<String, String> pair = DockerExecutableUtilsKt.getPossibleExecutableAndAssembly(dockerDeploymentModel);
        if (pair == null) {
            return null;
        }
        String string = executable = (String)pair.component1();
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public static final String getPossibleProjectAssembly(@NotNull RiderDockerDeploymentModel dockerDeploymentModel) {
        Intrinsics.checkNotNullParameter((Object)dockerDeploymentModel, (String)"dockerDeploymentModel");
        Pair<String, String> pair = DockerExecutableUtilsKt.getPossibleExecutableAndAssembly(dockerDeploymentModel);
        if (pair == null) {
            return null;
        }
        Pair<String, String> pair2 = pair;
        String executable = (String)pair2.component1();
        String assembly = (String)pair2.component2();
        if (executable == null) {
            return null;
        }
        String possibleProjectAssembly = DotNetCoreRuntime.Companion.getPossibleDotNetCoreExecutables().contains(executable) ? assembly : executable;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Possible project assembly: " + possibleProjectAssembly);
        }
        return possibleProjectAssembly;
    }

    private static final Pair<String, String> getPossibleExecutableAndAssembly(RiderDockerDeploymentModel dockerDeploymentModel) {
        List executionCommand = RiderDockerDeploymentModel.getExecutionCommand$default(dockerDeploymentModel, null, 1, null);
        if (executionCommand.isEmpty()) {
            return null;
        }
        Pair executableAndAssembly = executionCommand.size() >= 2 && Intrinsics.areEqual(executionCommand.get(0), (Object)"/bin/sh") && Intrinsics.areEqual(executionCommand.get(1), (Object)"-c") ? TuplesKt.to((Object)CollectionsKt.getOrNull((List)executionCommand, (int)2), (Object)CollectionsKt.getOrNull((List)executionCommand, (int)3)) : (executionCommand.size() >= 3 && Intrinsics.areEqual(executionCommand.get(0), (Object)"cmd") && Intrinsics.areEqual(executionCommand.get(1), (Object)"/S") && Intrinsics.areEqual(executionCommand.get(2), (Object)"/C") ? TuplesKt.to((Object)CollectionsKt.getOrNull((List)executionCommand, (int)3), (Object)CollectionsKt.getOrNull((List)executionCommand, (int)4)) : TuplesKt.to((Object)CollectionsKt.getOrNull((List)executionCommand, (int)0), (Object)CollectionsKt.getOrNull((List)executionCommand, (int)1)));
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Possible executable and assembly: " + executableAndAssembly);
        }
        return executableAndAssembly;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.jetbrains.rider.plugins.appender.docker.utils.DockerExecutableUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

