/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.runConfiguration;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.jetbrains.rider.plugins.appender.docker.fastMode.RiderDockerFastModeConfigurationExtensionKt;
import com.jetbrains.rider.plugins.appender.docker.utils.DockerServerUtilsKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeRunConfigurationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createRunConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "parameters", "Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeRunConfigurationService$DockerComposeRunConfigurationParameters;", "modifyConfiguration", "", "deploymentConfiguration", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "Companion", "DockerComposeRunConfigurationParameters", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDockerComposeRunConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeRunConfigurationService.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeRunConfigurationService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n15#2:90\n*S KotlinDebug\n*F\n+ 1 DockerComposeRunConfigurationService.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeRunConfigurationService\n*L\n23#1:90\n*E\n"})
public final class DockerComposeRunConfigurationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public DockerComposeRunConfigurationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final RunnerAndConfigurationSettings createRunConfiguration(@NotNull DockerComposeRunConfigurationParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LOG.info("Creating Docker Compose run configuration");
        VirtualFile composeFile2 = VfsUtil.findFile((Path)Path.of(parameters.getDockerComposePath(), new String[0]), (boolean)true);
        if (composeFile2 == null) {
            LOG.warn("Unable to find Dockerfile by path " + parameters.getDockerComposePath());
            return null;
        }
        DockerRunConfigurationCreator configurationCreator = new DockerRunConfigurationCreator(this.project);
        RemoteServer<DockerCloudConfiguration> server = DockerServerUtilsKt.getOrCreateLocalOrWslDockerServer();
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = configurationCreator.createConfiguration((DockerSingletonDeploymentSourceType)DockerComposeDeploymentSourceType.getInstance(), composeFile2, server);
        Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"createConfiguration(...)");
        RunnerAndConfigurationSettings configuration = runnerAndConfigurationSettings;
        RunConfiguration runConfiguration = configuration.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
        RunConfiguration deployToServerConfiguration = runConfiguration;
        if (!(deployToServerConfiguration instanceof DeployToServerRunConfiguration)) {
            return null;
        }
        DeploymentConfiguration deploymentConfiguration = ((DeployToServerRunConfiguration)deployToServerConfiguration).getDeploymentConfiguration();
        if (!(deploymentConfiguration instanceof DockerDeploymentConfiguration)) {
            return null;
        }
        this.modifyConfiguration((DockerDeploymentConfiguration)deploymentConfiguration, parameters);
        configuration.setTemporary(false);
        return configuration;
    }

    private final void modifyConfiguration(DockerDeploymentConfiguration deploymentConfiguration, DockerComposeRunConfigurationParameters parameters) {
        if (parameters.getOverrideComposePath() != null) {
            Object[] objectArray = new String[]{parameters.getOverrideComposePath()};
            deploymentConfiguration.setSecondarySourceFiles(CollectionsKt.mutableListOf((Object[])objectArray));
        }
        if (parameters.getAdditionalComposePaths() != null) {
            deploymentConfiguration.getSecondarySourceFiles().addAll((Collection)parameters.getAdditionalComposePaths());
        }
        if (parameters.getProjectName() != null) {
            deploymentConfiguration.setComposeProjectName(parameters.getProjectName());
        }
        if (Intrinsics.areEqual((Object)parameters.isRegularModeEnabled(), (Object)true)) {
            RiderDockerFastModeConfigurationExtensionKt.setFastModeEnabled(deploymentConfiguration, false);
        }
        if (Intrinsics.areEqual((Object)parameters.isSslEnabled(), (Object)true)) {
            RiderDockerFastModeConfigurationExtensionKt.setSslEnabled(deploymentConfiguration, true);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerComposeRunConfigurationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeRunConfigurationService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeRunConfigurationService;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nDockerComposeRunConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeRunConfigurationService.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeRunConfigurationService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,89:1\n31#2,2:90\n*S KotlinDebug\n*F\n+ 1 DockerComposeRunConfigurationService.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeRunConfigurationService$Companion\n*L\n21#1:90,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerComposeRunConfigurationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DockerComposeRunConfigurationService> serviceClass$iv = DockerComposeRunConfigurationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DockerComposeRunConfigurationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013JZ\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\b\u0010\u0013R\u0015\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\n\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeRunConfigurationService$DockerComposeRunConfigurationParameters;", "", "dockerComposePath", "", "overrideComposePath", "additionalComposePaths", "", "projectName", "isRegularModeEnabled", "", "isSslEnabled", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getDockerComposePath", "()Ljava/lang/String;", "getOverrideComposePath", "getAdditionalComposePaths", "()Ljava/util/List;", "getProjectName", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeRunConfigurationService$DockerComposeRunConfigurationParameters;", "equals", "other", "hashCode", "", "toString", "intellij.rider.plugins.appender"})
    public static final class DockerComposeRunConfigurationParameters {
        @NotNull
        private final String dockerComposePath;
        @Nullable
        private final String overrideComposePath;
        @Nullable
        private final List<String> additionalComposePaths;
        @Nullable
        private final String projectName;
        @Nullable
        private final Boolean isRegularModeEnabled;
        @Nullable
        private final Boolean isSslEnabled;

        public DockerComposeRunConfigurationParameters(@NotNull String dockerComposePath, @Nullable String overrideComposePath, @Nullable List<String> additionalComposePaths, @Nullable String projectName, @Nullable Boolean isRegularModeEnabled, @Nullable Boolean isSslEnabled) {
            Intrinsics.checkNotNullParameter((Object)dockerComposePath, (String)"dockerComposePath");
            this.dockerComposePath = dockerComposePath;
            this.overrideComposePath = overrideComposePath;
            this.additionalComposePaths = additionalComposePaths;
            this.projectName = projectName;
            this.isRegularModeEnabled = isRegularModeEnabled;
            this.isSslEnabled = isSslEnabled;
        }

        @NotNull
        public final String getDockerComposePath() {
            return this.dockerComposePath;
        }

        @Nullable
        public final String getOverrideComposePath() {
            return this.overrideComposePath;
        }

        @Nullable
        public final List<String> getAdditionalComposePaths() {
            return this.additionalComposePaths;
        }

        @Nullable
        public final String getProjectName() {
            return this.projectName;
        }

        @Nullable
        public final Boolean isRegularModeEnabled() {
            return this.isRegularModeEnabled;
        }

        @Nullable
        public final Boolean isSslEnabled() {
            return this.isSslEnabled;
        }

        @NotNull
        public final String component1() {
            return this.dockerComposePath;
        }

        @Nullable
        public final String component2() {
            return this.overrideComposePath;
        }

        @Nullable
        public final List<String> component3() {
            return this.additionalComposePaths;
        }

        @Nullable
        public final String component4() {
            return this.projectName;
        }

        @Nullable
        public final Boolean component5() {
            return this.isRegularModeEnabled;
        }

        @Nullable
        public final Boolean component6() {
            return this.isSslEnabled;
        }

        @NotNull
        public final DockerComposeRunConfigurationParameters copy(@NotNull String dockerComposePath, @Nullable String overrideComposePath, @Nullable List<String> additionalComposePaths, @Nullable String projectName, @Nullable Boolean isRegularModeEnabled, @Nullable Boolean isSslEnabled) {
            Intrinsics.checkNotNullParameter((Object)dockerComposePath, (String)"dockerComposePath");
            return new DockerComposeRunConfigurationParameters(dockerComposePath, overrideComposePath, additionalComposePaths, projectName, isRegularModeEnabled, isSslEnabled);
        }

        public static /* synthetic */ DockerComposeRunConfigurationParameters copy$default(DockerComposeRunConfigurationParameters dockerComposeRunConfigurationParameters, String string, String string2, List list, String string3, Boolean bl, Boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = dockerComposeRunConfigurationParameters.dockerComposePath;
            }
            if ((n & 2) != 0) {
                string2 = dockerComposeRunConfigurationParameters.overrideComposePath;
            }
            if ((n & 4) != 0) {
                list = dockerComposeRunConfigurationParameters.additionalComposePaths;
            }
            if ((n & 8) != 0) {
                string3 = dockerComposeRunConfigurationParameters.projectName;
            }
            if ((n & 0x10) != 0) {
                bl = dockerComposeRunConfigurationParameters.isRegularModeEnabled;
            }
            if ((n & 0x20) != 0) {
                bl2 = dockerComposeRunConfigurationParameters.isSslEnabled;
            }
            return dockerComposeRunConfigurationParameters.copy(string, string2, list, string3, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "DockerComposeRunConfigurationParameters(dockerComposePath=" + this.dockerComposePath + ", overrideComposePath=" + this.overrideComposePath + ", additionalComposePaths=" + this.additionalComposePaths + ", projectName=" + this.projectName + ", isRegularModeEnabled=" + this.isRegularModeEnabled + ", isSslEnabled=" + this.isSslEnabled + ")";
        }

        public int hashCode() {
            int result2 = this.dockerComposePath.hashCode();
            result2 = result2 * 31 + (this.overrideComposePath == null ? 0 : this.overrideComposePath.hashCode());
            result2 = result2 * 31 + (this.additionalComposePaths == null ? 0 : ((Object)this.additionalComposePaths).hashCode());
            result2 = result2 * 31 + (this.projectName == null ? 0 : this.projectName.hashCode());
            result2 = result2 * 31 + (this.isRegularModeEnabled == null ? 0 : ((Object)this.isRegularModeEnabled).hashCode());
            result2 = result2 * 31 + (this.isSslEnabled == null ? 0 : ((Object)this.isSslEnabled).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DockerComposeRunConfigurationParameters)) {
                return false;
            }
            DockerComposeRunConfigurationParameters dockerComposeRunConfigurationParameters = (DockerComposeRunConfigurationParameters)other;
            if (!Intrinsics.areEqual((Object)this.dockerComposePath, (Object)dockerComposeRunConfigurationParameters.dockerComposePath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.overrideComposePath, (Object)dockerComposeRunConfigurationParameters.overrideComposePath)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.additionalComposePaths, dockerComposeRunConfigurationParameters.additionalComposePaths)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.projectName, (Object)dockerComposeRunConfigurationParameters.projectName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.isRegularModeEnabled, (Object)dockerComposeRunConfigurationParameters.isRegularModeEnabled)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.isSslEnabled, (Object)dockerComposeRunConfigurationParameters.isSslEnabled);
        }
    }
}

