/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.run;

import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.plugins.appender.docker.RiderDockerBundle;
import com.jetbrains.rider.plugins.appender.docker.run.RiderDockerExecutionListener;
import com.jetbrains.rider.projectView.actions.addExisting.AddExistingFileSession;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/run/RiderDockerExecutionListener;", "Lcom/intellij/execution/ExecutionListener;", "<init>", "()V", "processStarting", "", "executorId", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "internalProcessStarting", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderDockerExecutionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDockerExecutionListener.kt\ncom/jetbrains/rider/plugins/appender/docker/run/RiderDockerExecutionListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class RiderDockerExecutionListener
implements ExecutionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DOCKERIGNORE_FILE = ".dockerignore";

    public void processStarting(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        super.processStarting(executorId, env);
        this.internalProcessStarting(env);
    }

    public void processStarting(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        super.processStarting(executorId, env, handler);
        this.internalProcessStarting(env);
    }

    private final void internalProcessStarting(ExecutionEnvironment env) {
        Path path;
        Path sourceFilePath;
        Project project;
        block13: {
            block12: {
                Object object;
                RunnerAndConfigurationSettings dockerRunConfig;
                block11: {
                    block10: {
                        Project project2 = env.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        project = project2;
                        RunnerAndConfigurationSettings runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
                        if (runnerAndConfigurationSettings == null || (runnerAndConfigurationSettings = DockerRunConfig.Wrapper.Companion.asDockerRunConfig(runnerAndConfigurationSettings)) == null) {
                            return;
                        }
                        dockerRunConfig = runnerAndConfigurationSettings;
                        String string = dockerRunConfig.getDockerRunConfig().getDeployment().getSourceFilePath();
                        if (string == null) break block10;
                        String it = string;
                        boolean bl = false;
                        object = DockerDeploymentConfigurationUtilsKt.resolvePath((Project)project, (String)it);
                        if (object != null) break block11;
                    }
                    return;
                }
                sourceFilePath = object;
                object = dockerRunConfig.getDockerRunConfig().getDeployment().getContextFolderPath();
                if (object == null) break block12;
                Object it = object;
                boolean bl = false;
                path = DockerDeploymentConfigurationUtilsKt.resolvePath((Project)project, (String)it);
                if (path != null) break block13;
            }
            return;
        }
        Path contextFolderPath = path;
        if (Intrinsics.areEqual((Object)sourceFilePath, (Object)contextFolderPath)) {
            return;
        }
        Path localDockerIgnore = sourceFilePath.getParent().resolve(DOCKERIGNORE_FILE);
        Intrinsics.checkNotNull((Object)localDockerIgnore);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(localDockerIgnore, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        Path contextDockerIgnore = contextFolderPath.resolve(DOCKERIGNORE_FILE);
        Intrinsics.checkNotNull((Object)contextDockerIgnore);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists(contextDockerIgnore, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            return;
        }
        Supplier<String> supplier = RiderDockerBundle.Companion.messagePointer("run.docker.notification.dockerignore.not.in.docker.context.move", new Object[0]);
        new Notification("Docker", RiderDockerBundle.Companion.message("run.docker.notification.dockerignore.not.in.docker.context.title", new Object[0]), RiderDockerBundle.Companion.message("run.docker.notification.dockerignore.not.in.docker.context.content", new Object[0]), NotificationType.WARNING).addAction((AnAction)new DumbAware(localDockerIgnore, project, sourceFilePath, contextDockerIgnore, supplier){
            final /* synthetic */ Path $localDockerIgnore;
            final /* synthetic */ Project $project;
            final /* synthetic */ Path $sourceFilePath;
            final /* synthetic */ Path $contextDockerIgnore;
            {
                this.$localDockerIgnore = $localDockerIgnore;
                this.$project = $project;
                this.$sourceFilePath = $sourceFilePath;
                this.$contextDockerIgnore = $contextDockerIgnore;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Path path = this.$localDockerIgnore;
                Intrinsics.checkNotNull((Object)path);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return;
                }
                ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.singleOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.$project), (Path)this.$sourceFilePath, (Project)this.$project));
                if (projectModelEntity == null) {
                    return;
                }
                ProjectModelEntity dockerFileEntity = projectModelEntity;
                ProjectModelEntity projectModelEntity2 = dockerFileEntity.getParentEntity();
                if (projectModelEntity2 == null) {
                    return;
                }
                ProjectModelEntity projectEntity = projectModelEntity2;
                Files.move(this.$localDockerIgnore, this.$contextDockerIgnore, new CopyOption[0]);
                AddExistingFileSession.Companion.run(this.$project, arg_0 -> internalProcessStarting.1.actionPerformed$lambda$0(projectEntity, this.$contextDockerIgnore, arg_0));
                LocalFileSystem.getInstance().refresh(false);
            }

            private static final Unit actionPerformed$lambda$0(ProjectModelEntity $projectEntity, Path $contextDockerIgnore, AddExistingFileSession it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Intrinsics.checkNotNull((Object)$contextDockerIgnore);
                AddExistingFileSession.add$default((AddExistingFileSession)it, (ProjectModelEntity)$projectEntity, (Path)$contextDockerIgnore, null, (int)4, null);
                return Unit.INSTANCE;
            }
        }).notify(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/run/RiderDockerExecutionListener$Companion;", "", "<init>", "()V", "DOCKERIGNORE_FILE", "", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

