/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.dockerfile;

import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.dockerFile.DockerFileType;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.parser.DockerParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.plugins.appender.docker.dockerfile.RiderDockerfileCommand;
import com.jetbrains.rider.plugins.appender.docker.dockerfile.RiderDockerfileModelBuilder;
import com.jetbrains.rider.plugins.appender.docker.dockerfile.RiderDockerfilePreprocessor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R,\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileService;", "", "<init>", "()V", "dockerfileCommands", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Pair;", "", "", "Lcom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileCommand;", "parse", "Lcom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileModelBuilder;", "dockerfile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getDockerfileCommands", "getDockerfileCommandsFromFile", "tryGetDockerPsiFileFile", "Lcom/intellij/docker/dockerFile/DockerPsiFile;", "virtualFile", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderDockerfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDockerfileService.kt\ncom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,93:1\n15#2:94\n*S KotlinDebug\n*F\n+ 1 RiderDockerfileService.kt\ncom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileService\n*L\n21#1:94\n*E\n"})
public final class RiderDockerfileService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, Pair<Long, List<RiderDockerfileCommand>>> dockerfileCommands = new ConcurrentHashMap();
    @NotNull
    private static final Logger LOG;

    @Nullable
    public final RiderDockerfileModelBuilder parse(@NotNull VirtualFile dockerfile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)dockerfile2, (String)"dockerfile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<RiderDockerfileCommand> commands = this.getDockerfileCommands(dockerfile2, project);
        if (commands == null) {
            LOG.warn("Unable to create a Dockerfile model for " + dockerfile2.getPath());
            return null;
        }
        RiderDockerfileModelBuilder builder = new RiderDockerfileModelBuilder();
        for (RiderDockerfileCommand command : commands) {
            builder.applyCommand(command);
        }
        return builder;
    }

    @Nullable
    public final List<RiderDockerfileCommand> getDockerfileCommands(@NotNull VirtualFile dockerfile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)dockerfile2, (String)"dockerfile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Pair<Long, List<RiderDockerfileCommand>> existingCommands = this.dockerfileCommands.get(dockerfile2.getPath());
        long modificationStamp = dockerfile2.getModificationStamp();
        if (existingCommands != null && modificationStamp == ((Number)existingCommands.getFirst()).longValue()) {
            LOG.trace("Get Dockerfile " + dockerfile2.getPath() + " commands from cache");
            return (List)existingCommands.getSecond();
        }
        List<RiderDockerfileCommand> commands = this.getDockerfileCommandsFromFile(dockerfile2, project);
        if (commands == null) {
            LOG.warn("Unable to get Dockerfile(" + dockerfile2.getPath() + ") commands");
            return null;
        }
        ((Map)this.dockerfileCommands).put(dockerfile2.getPath(), TuplesKt.to((Object)modificationStamp, commands));
        return commands;
    }

    private final List<RiderDockerfileCommand> getDockerfileCommandsFromFile(VirtualFile dockerfile2, Project project) {
        return (List)ApplicationKt.getApplication().runReadAction(() -> RiderDockerfileService.getDockerfileCommandsFromFile$lambda$0(this, dockerfile2, project));
    }

    private final DockerPsiFile tryGetDockerPsiFileFile(VirtualFile virtualFile2, Project project) {
        DockerPsiFile dockerPsiFile;
        try {
            Object object;
            PsiFile psiFile = PsiUtilCore.getPsiFile((Project)project, (VirtualFile)virtualFile2);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getPsiFile(...)");
            PsiFile initialFile = psiFile;
            if (initialFile instanceof DockerPsiFile) {
                object = (DockerPsiFile)initialFile;
            } else {
                LOG.warn("Dockerfile parsed as " + initialFile.getClass());
                DockerParserDefinition parserDefinition = new DockerParserDefinition();
                SingleRootFileViewProvider fileViewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), initialFile.getVirtualFile(), false, (FileType)DockerFileType.DOCKER_FILE_TYPE);
                PsiFile psiFile2 = parserDefinition.createFile((FileViewProvider)fileViewProvider);
                object = psiFile2 instanceof DockerPsiFile ? (DockerPsiFile)psiFile2 : null;
            }
            dockerPsiFile = object;
        }
        catch (Throwable t) {
            LOG.error(t);
            dockerPsiFile = null;
        }
        return dockerPsiFile;
    }

    private static final List getDockerfileCommandsFromFile$lambda$0(RiderDockerfileService this$0, VirtualFile $dockerfile, Project $project) {
        DockerPsiFile dockerPsiFile = this$0.tryGetDockerPsiFileFile($dockerfile, $project);
        if (dockerPsiFile == null) {
            LOG.warn("Unable to get PSI file for " + $dockerfile.getPath());
            return null;
        }
        return RiderDockerfilePreprocessor.Companion.getInstance().parseDockerfile(dockerPsiFile);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderDockerfileService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileService;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nRiderDockerfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDockerfileService.kt\ncom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,93:1\n40#2,3:94\n*S KotlinDebug\n*F\n+ 1 RiderDockerfileService.kt\ncom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileService$Companion\n*L\n20#1:94,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderDockerfileService getInstance() {
            boolean $i$f$service = false;
            Class<RiderDockerfileService> serviceClass$iv = RiderDockerfileService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (RiderDockerfileService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

