/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.deployment;

import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.plugins.appender.docker.common.DockerContainerType;
import com.jetbrains.rider.plugins.appender.docker.deployment.RiderDockerDeploymentModel;
import com.jetbrains.rider.plugins.appender.docker.dockerfile.EnvironmentReplacementUtilsKt;
import com.jetbrains.rider.plugins.appender.docker.dockerfile.RiderDockerfileModel;
import com.jetbrains.rider.plugins.appender.docker.dockerfile.RiderDockerfileModelExtensionsKt;
import com.jetbrains.rider.plugins.appender.docker.image.RiderDockerImageProperties;
import com.jetbrains.rider.plugins.appender.docker.utils.DockerExecutableUtilsKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0093\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aJ\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\"\u001a\u00020#2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010$\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0016J\u001e\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/deployment/RiderDockerDeploymentFromFileModel;", "Lcom/jetbrains/rider/plugins/appender/docker/deployment/RiderDockerDeploymentModel;", "dockerfilePath", "Ljava/nio/file/Path;", "dockerfileModel", "Lcom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileModel;", "buildTarget", "", "configEntrypoint", "", "configCmd", "configWorkingDir", "configUser", "configEnvVars", "", "configContainerPorts", "", "", "configExposedPorts", "configContainerVolumes", "<init>", "(Ljava/nio/file/Path;Lcom/jetbrains/rider/plugins/appender/docker/dockerfile/RiderDockerfileModel;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getDockerfilePath", "()Ljava/nio/file/Path;", "[Ljava/lang/String;", "getDockerfileStages", "", "getCpuKind", "Lcom/jetbrains/rider/CPUKind;", "stage", "getContainerOs", "Lcom/jetbrains/rider/plugins/appender/docker/common/DockerContainerType;", "getImageProperties", "Lcom/jetbrains/rider/plugins/appender/docker/image/RiderDockerImageProperties;", "isRootless", "", "getWorkingDir", "getEnvironmentVariables", "getContainerPorts", "getContainerVolumes", "getExecutionCommand", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderDockerDeploymentFromFileModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDockerDeploymentFromFileModel.kt\ncom/jetbrains/rider/plugins/appender/docker/deployment/RiderDockerDeploymentFromFileModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1611#2,9:103\n1863#2:112\n1864#2:114\n1620#2:115\n1#3:113\n*S KotlinDebug\n*F\n+ 1 RiderDockerDeploymentFromFileModel.kt\ncom/jetbrains/rider/plugins/appender/docker/deployment/RiderDockerDeploymentFromFileModel\n*L\n23#1:103,9\n23#1:112\n23#1:114\n23#1:115\n23#1:113\n*E\n"})
public final class RiderDockerDeploymentFromFileModel
implements RiderDockerDeploymentModel {
    @NotNull
    private final Path dockerfilePath;
    @NotNull
    private final RiderDockerfileModel dockerfileModel;
    @Nullable
    private final String buildTarget;
    @Nullable
    private final String[] configEntrypoint;
    @Nullable
    private final String[] configCmd;
    @Nullable
    private final String configWorkingDir;
    @Nullable
    private final String configUser;
    @NotNull
    private final Map<String, String> configEnvVars;
    @NotNull
    private final Set<Integer> configContainerPorts;
    @NotNull
    private final Set<Integer> configExposedPorts;
    @NotNull
    private final Set<String> configContainerVolumes;

    public RiderDockerDeploymentFromFileModel(@NotNull Path dockerfilePath, @NotNull RiderDockerfileModel dockerfileModel, @Nullable String buildTarget, @Nullable String[] configEntrypoint, @Nullable String[] configCmd, @Nullable String configWorkingDir, @Nullable String configUser, @NotNull Map<String, String> configEnvVars, @NotNull Set<Integer> configContainerPorts, @NotNull Set<Integer> configExposedPorts, @NotNull Set<String> configContainerVolumes) {
        Intrinsics.checkNotNullParameter((Object)dockerfilePath, (String)"dockerfilePath");
        Intrinsics.checkNotNullParameter((Object)dockerfileModel, (String)"dockerfileModel");
        Intrinsics.checkNotNullParameter(configEnvVars, (String)"configEnvVars");
        Intrinsics.checkNotNullParameter(configContainerPorts, (String)"configContainerPorts");
        Intrinsics.checkNotNullParameter(configExposedPorts, (String)"configExposedPorts");
        Intrinsics.checkNotNullParameter(configContainerVolumes, (String)"configContainerVolumes");
        this.dockerfilePath = dockerfilePath;
        this.dockerfileModel = dockerfileModel;
        this.buildTarget = buildTarget;
        this.configEntrypoint = configEntrypoint;
        this.configCmd = configCmd;
        this.configWorkingDir = configWorkingDir;
        this.configUser = configUser;
        this.configEnvVars = configEnvVars;
        this.configContainerPorts = configContainerPorts;
        this.configExposedPorts = configExposedPorts;
        this.configContainerVolumes = configContainerVolumes;
    }

    @NotNull
    public final Path getDockerfilePath() {
        return this.dockerfilePath;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getDockerfileStages() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.dockerfileModel.getStages();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if ((String)it.getFirst() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public CPUKind getCpuKind(@Nullable String stage) {
        String string = stage;
        if (string == null) {
            string = this.buildTarget;
        }
        String targetStage = string;
        return RiderDockerfileModelExtensionsKt.getCpuKind(this.dockerfileModel, targetStage);
    }

    @Override
    @NotNull
    public DockerContainerType getContainerOs(@Nullable String stage) {
        String string = stage;
        if (string == null) {
            string = this.buildTarget;
        }
        String targetStage = string;
        return RiderDockerfileModelExtensionsKt.getOs(this.dockerfileModel, targetStage);
    }

    @Override
    @Nullable
    public RiderDockerImageProperties getImageProperties(@Nullable String stage) {
        String string = stage;
        if (string == null) {
            string = this.buildTarget;
        }
        String targetStage = string;
        return RiderDockerfileModelExtensionsKt.getImageProperties(this.dockerfileModel, targetStage);
    }

    @Override
    public boolean isRootless(@Nullable String stage) {
        String targetStage;
        if (this.configUser != null) {
            return !StringsKt.equals((String)this.configUser, (String)"root", (boolean)true);
        }
        String string = stage;
        if (string == null) {
            string = this.buildTarget;
        }
        return RiderDockerfileModelExtensionsKt.isRootless(this.dockerfileModel, targetStage = string);
    }

    @Override
    @NotNull
    public String getWorkingDir(@Nullable String stage) {
        if (this.configWorkingDir != null) {
            return this.configWorkingDir;
        }
        String string = stage;
        if (string == null) {
            string = this.buildTarget;
        }
        String targetStage = string;
        return RiderDockerfileModelExtensionsKt.getWorkingDirectory(this.dockerfileModel, targetStage);
    }

    @Override
    @NotNull
    public Map<String, String> getEnvironmentVariables(@Nullable String stage) {
        String string = stage;
        if (string == null) {
            string = this.buildTarget;
        }
        String targetStage = string;
        return MapsKt.plus(RiderDockerfileModelExtensionsKt.getEnvironmentVariables(this.dockerfileModel, targetStage), this.configEnvVars);
    }

    @Override
    @NotNull
    public Set<Integer> getContainerPorts(@Nullable String stage) {
        Set set;
        Set $this$getContainerPorts_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getContainerPorts_u24lambda_u241.addAll((Collection)this.configContainerPorts);
        $this$getContainerPorts_u24lambda_u241.addAll((Collection)this.configExposedPorts);
        String string = stage;
        if (string == null) {
            string = this.buildTarget;
        }
        String targetStage = string;
        Set<Integer> modelPorts = RiderDockerfileModelExtensionsKt.getExposedPorts(this.dockerfileModel, targetStage);
        $this$getContainerPorts_u24lambda_u241.addAll((Collection)modelPorts);
        return SetsKt.build((Set)set);
    }

    @Override
    @NotNull
    public Set<String> getContainerVolumes(@Nullable String stage) {
        Set set;
        Set $this$getContainerVolumes_u24lambda_u242 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getContainerVolumes_u24lambda_u242.addAll((Collection)this.configContainerVolumes);
        String string = stage;
        if (string == null) {
            string = this.buildTarget;
        }
        String targetStage = string;
        Set<String> modelVolumes = RiderDockerfileModelExtensionsKt.getVolumes(this.dockerfileModel, targetStage);
        $this$getContainerVolumes_u24lambda_u242.addAll((Collection)modelVolumes);
        return SetsKt.build((Set)set);
    }

    @Override
    @NotNull
    public List<String> getExecutionCommand(@Nullable String stage) {
        String targetStage;
        List<String> modelEntrypoint;
        if (this.configEntrypoint != null) {
            List list;
            List $this$getExecutionCommand_u24lambda_u243 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            CollectionsKt.addAll((Collection)$this$getExecutionCommand_u24lambda_u243, (Object[])this.configEntrypoint);
            if (this.configCmd != null) {
                CollectionsKt.addAll((Collection)$this$getExecutionCommand_u24lambda_u243, (Object[])this.configCmd);
            }
            return CollectionsKt.build((List)list);
        }
        String string = stage;
        if (string == null) {
            string = this.buildTarget;
        }
        if ((modelEntrypoint = RiderDockerfileModelExtensionsKt.getEntrypoint(this.dockerfileModel, targetStage = string)) != null && DockerExecutableUtilsKt.isInstructionInShellForm(modelEntrypoint, RiderDockerfileModelExtensionsKt.getOs(this.dockerfileModel, targetStage))) {
            Map<String, String> environmentVariables = RiderDockerfileModelExtensionsKt.getEnvironmentVariables(this.dockerfileModel, targetStage);
            return EnvironmentReplacementUtilsKt.replaceEntrypointInShellFormWithEnvironment(modelEntrypoint, environmentVariables);
        }
        if (this.configCmd != null) {
            List list;
            List $this$getExecutionCommand_u24lambda_u244 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (modelEntrypoint != null) {
                $this$getExecutionCommand_u24lambda_u244.addAll((Collection)modelEntrypoint);
            }
            CollectionsKt.addAll((Collection)$this$getExecutionCommand_u24lambda_u244, (Object[])this.configCmd);
            return CollectionsKt.build((List)list);
        }
        return RiderDockerfileModelExtensionsKt.getExecutionCommand(this.dockerfileModel, targetStage);
    }
}

