/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.SchemaCompareDataModel;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.state.SchemaCompareActionState;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.actions.ExcludeSelectedAction;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.actions.IncludeSelectedAction;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.extensions.LifetimedListenersKt;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.SchemaCompareTreeTableModel;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.columns.ChangeTypeColumn;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.columns.SchemaCompareColumnInfo;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.columns.SchemaCompareTreeColumnInfo;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.columns.ToggleColumn;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.SchemaCompareTreeNodeExpander;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.TreeExpandedPathsPreserver;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.nodes.SchemaCompareTreeNode;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u001b\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u001c\"\u0004\b\u0001\u0010\u001d2\u0006\u0010\u0019\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001d0\u001eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTable;", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "schemaCompareDataModel", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;", "treeTableModel", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTableModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTableModel;)V", "getSelectedNodes", "", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/tree/nodes/SchemaCompareTreeNode;", "()[Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/tree/nodes/SchemaCompareTreeNode;", "getCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "row", "", "column", "getCellEditor", "Ljavax/swing/table/TableCellEditor;", "adjustColumns", "", "getColumnInfo", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/columns/SchemaCompareColumnInfo;", "columnIndex", "getRowElement", "setFixedWidthForColumnFromItsName", "Item", "Aspect", "Lcom/intellij/util/ui/ColumnInfo;", "SchemaCompareTreeTableViewMouseAdapter", "intellij.rider.plugins.appender"})
public final class SchemaCompareTreeTable
extends TreeTable {
    @NotNull
    private final SchemaCompareTreeTableModel treeTableModel;

    public SchemaCompareTreeTable(@NotNull Lifetime lifetime, @NotNull SchemaCompareDataModel schemaCompareDataModel, @NotNull SchemaCompareTreeTableModel treeTableModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)schemaCompareDataModel, (String)"schemaCompareDataModel");
        Intrinsics.checkNotNullParameter((Object)treeTableModel, (String)"treeTableModel");
        super((TreeTableModel)treeTableModel);
        this.treeTableModel = treeTableModel;
        this.adjustColumns();
        this.getEmptyText().setText(RiderDatabaseBundle.message("schemaCompare.statuses.ready", new Object[0]));
        this.getEmptyText().setShowAboveCenter(false);
        TreeTableTree treeTableTree = this.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"getTree(...)");
        JTree jTree = (JTree)treeTableTree;
        TreeTableTree treeTableTree2 = this.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)treeTableTree2, (String)"getTree(...)");
        LifetimedListenersKt.addTreeExpansionListener(jTree, lifetime, new TreeExpandedPathsPreserver(lifetime, (JTree)treeTableTree2, schemaCompareDataModel));
        TreeTableTree treeTableTree3 = this.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)treeTableTree3, (String)"getTree(...)");
        LifetimedListenersKt.addTreeWillExpandListener((JTree)treeTableTree3, lifetime, new SchemaCompareTreeNodeExpander(this.treeTableModel.getTreeModel()));
        this.getTree().setRootVisible(false);
        LifetimedListenersKt.addMouseListener((Component)((Object)this), lifetime, new SchemaCompareTreeTableViewMouseAdapter(this, schemaCompareDataModel.getProject()));
        AnAction[] anActionArray = new AnAction[]{new IncludeSelectedAction(), new ExcludeSelectedAction()};
        PopupHandler.installRowSelectionTablePopup((JTable)((JTable)((Object)this)), (ActionGroup)((ActionGroup)new DefaultActionGroup(anActionArray)), (String)"SchemaComparePopup");
        schemaCompareDataModel.getModelState().getCanChangeInclusion().advise(lifetime, arg_0 -> SchemaCompareTreeTable._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final SchemaCompareTreeNode[] getSelectedNodes() {
        Object[] objectArray = this.getTree().getSelectedNodes(SchemaCompareTreeNode.class, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedNodes(...)");
        return (SchemaCompareTreeNode[])objectArray;
    }

    @NotNull
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = this.getColumnInfo(column).getRenderer(this.getRowElement(row));
        TableCellRenderer tableCellRenderer = renderer;
        if (tableCellRenderer == null) {
            TableCellRenderer tableCellRenderer2 = super.getCellRenderer(row, column);
            tableCellRenderer = tableCellRenderer2;
            Intrinsics.checkNotNullExpressionValue((Object)tableCellRenderer2, (String)"getCellRenderer(...)");
        }
        return tableCellRenderer;
    }

    @Nullable
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor2 = this.getColumnInfo(column).getEditor(this.getRowElement(row));
        TableCellEditor tableCellEditor = editor2;
        if (tableCellEditor == null) {
            tableCellEditor = super.getCellEditor(row, column);
        }
        return tableCellEditor;
    }

    private final void adjustColumns() {
        int n = this.treeTableModel.getColumns().length;
        for (int columnIndex = 0; columnIndex < n; ++columnIndex) {
            SchemaCompareColumnInfo column = this.treeTableModel.getColumns()[columnIndex];
            if (column instanceof ToggleColumn || column instanceof ChangeTypeColumn) {
                this.setFixedWidthForColumnFromItsName(columnIndex, column);
                continue;
            }
            if (!(column instanceof SchemaCompareTreeColumnInfo)) continue;
            TableColumn tableColumn = this.getColumnModel().getColumn(columnIndex);
            tableColumn.setPreferredWidth(300);
        }
    }

    private final SchemaCompareColumnInfo getColumnInfo(int columnIndex) {
        return this.treeTableModel.getColumns()[this.convertColumnIndexToModel(columnIndex)];
    }

    private final SchemaCompareTreeNode getRowElement(int row) {
        Object object = this.getTree().getPathForRow(row).getLastPathComponent();
        return object instanceof SchemaCompareTreeNode ? (SchemaCompareTreeNode)object : null;
    }

    private final <Item, Aspect> void setFixedWidthForColumnFromItsName(int columnIndex, ColumnInfo<Item, Aspect> column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(columnIndex);
        int columnWidth = this.getFontMetrics(this.getFont()).stringWidth(column.getName()) + 15;
        tableColumn.setPreferredWidth(columnWidth);
    }

    private static final Unit _init_$lambda$0(SchemaCompareTreeTable this$0, SchemaCompareActionState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.setEnabled(it == SchemaCompareActionState.Enabled);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTable$SchemaCompareTreeTableViewMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "treeTableView", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTable;Lcom/intellij/openapi/project/Project;)V", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.rider.plugins.appender"})
    private static final class SchemaCompareTreeTableViewMouseAdapter
    extends MouseAdapter {
        @NotNull
        private final SchemaCompareTreeTable treeTableView;
        @NotNull
        private final Project project;

        public SchemaCompareTreeTableViewMouseAdapter(@NotNull SchemaCompareTreeTable treeTableView, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)((Object)treeTableView), (String)"treeTableView");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.treeTableView = treeTableView;
            this.project = project;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            int row;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.treeTableView.isEmpty()) {
                IdeFocusManager.getInstance((Project)this.project).requestFocusInProject((Component)((Object)this.treeTableView), this.project);
                return;
            }
            if (SwingUtilities.isRightMouseButton(e) && !this.treeTableView.isRowSelected(row = this.treeTableView.rowAtPoint(e.getPoint()))) {
                int col = this.treeTableView.columnAtPoint(e.getPoint());
                if (row >= 0 && col >= 0) {
                    this.treeTableView.changeSelection(row, col, false, false);
                }
            }
        }
    }
}

