/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.problems;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.PathUtil;
import com.jetbrains.rider.model.RdSqlProjWorkerProblemSeverity;
import com.jetbrains.rider.model.RdSqlProjectProblem;
import javax.swing.Icon;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J:\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0002H\u0003\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/problems/SchemaCompareProblemRenderer;", "Lcom/intellij/ui/SimpleListCellRenderer;", "Lcom/jetbrains/rider/model/RdSqlProjectProblem;", "<init>", "()V", "customize", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "getIcon", "Ljavax/swing/Icon;", "problem", "getProblemText", "", "intellij.rider.plugins.appender"})
public final class SchemaCompareProblemRenderer
extends SimpleListCellRenderer<RdSqlProjectProblem> {
    @NotNull
    public static final SchemaCompareProblemRenderer INSTANCE = new SchemaCompareProblemRenderer();

    private SchemaCompareProblemRenderer() {
    }

    public void customize(@NotNull JList<? extends RdSqlProjectProblem> list, @Nullable RdSqlProjectProblem value2, int index, boolean selected, boolean hasFocus) {
        block0: {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            RdSqlProjectProblem rdSqlProjectProblem = value2;
            if (rdSqlProjectProblem == null) break block0;
            RdSqlProjectProblem it = rdSqlProjectProblem;
            boolean bl = false;
            INSTANCE.setIcon(INSTANCE.getIcon(value2));
            INSTANCE.setText(INSTANCE.getProblemText(value2));
        }
    }

    private final Icon getIcon(RdSqlProjectProblem problem) {
        Icon icon;
        switch (WhenMappings.$EnumSwitchMapping$0[problem.getSeverity().ordinal()]) {
            case 1: {
                Icon icon2 = AllIcons.General.Error;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Error");
                break;
            }
            case 2: {
                Icon icon3 = AllIcons.General.Warning;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Warning");
                break;
            }
            case 3: {
                Icon icon4 = AllIcons.General.Information;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Information");
                break;
            }
            default: {
                throw new InvalidDataException("Unknown severity");
            }
        }
        return icon;
    }

    @NlsSafe
    private final String getProblemText(RdSqlProjectProblem problem) {
        StringBuilder builder = new StringBuilder();
        CharSequence charSequence = problem.getDocument();
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = problem.getDocument();
            Intrinsics.checkNotNull((Object)string);
            builder.append(PathUtil.getFileName((String)string));
        }
        if (problem.getLine() != null) {
            builder.append("(" + problem.getLine());
            StringBuilder stringBuilder = problem.getColumn() != null ? builder.append(", " + problem.getColumn() + ")") : builder.append(')');
        }
        if (((CharSequence)builder).length() > 0) {
            builder.append(": ");
        }
        if (problem.getErrorCode() != null) {
            builder.append("[SQL" + problem.getErrorCode() + "] ");
        }
        builder.append(problem.getText());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdSqlProjWorkerProblemSeverity.values().length];
            try {
                nArray[RdSqlProjWorkerProblemSeverity.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdSqlProjWorkerProblemSeverity.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdSqlProjWorkerProblemSeverity.Message.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

