/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database;

import com.intellij.database.Dbms;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBList;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.RdConnectionString;
import com.jetbrains.rider.model.RdSetSchemaCompareParticipantForDatabaseRequest;
import com.jetbrains.rider.model.RdSetSchemaCompareParticipantRequest;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.ConnectionStringsProvider;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.PotentialConnectionString;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.DatabaseConnectionDialog;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.ParticipantSelectionTab;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database.DataSourcesChangesListener;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database.DatabaseInDatasource;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database.ListWithDatabases;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database.LocalDataSourceToConnectionStringMapper;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/participants/tabs/database/DatabaseParticipantSelectionTab;", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/participants/tabs/ParticipantSelectionTab;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "list", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/participants/tabs/database/ListWithDatabases;", "getComponent", "Ljavax/swing/JComponent;", "getSelectedParticipant", "Lcom/jetbrains/rider/model/RdSetSchemaCompareParticipantRequest;", "getPreferableFocusComponent", "createNewDataSource", "", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDatabaseParticipantSelectionTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseParticipantSelectionTab.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/participants/tabs/database/DatabaseParticipantSelectionTab\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class DatabaseParticipantSelectionTab
extends ParticipantSelectionTab {
    @NotNull
    private final ListWithDatabases list;

    public DatabaseParticipantSelectionTab(@NotNull Lifetime lifetime, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, RiderDatabaseBundle.INSTANCE.getMessage("schemaCompare.participantSelection.databases.tabHeader", new Object[0]));
        this.list = new ListWithDatabases(project);
        DataSourcesChangesListener listener = new DataSourcesChangesListener(project, this.list);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        Topic topic = DataSourceManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return (JComponent)BuilderKt.panel(arg_0 -> DatabaseParticipantSelectionTab.getComponent$lambda$4(this, arg_0));
    }

    @Override
    @Nullable
    public RdSetSchemaCompareParticipantRequest getSelectedParticipant() {
        DatabaseInDatasource databaseInDatasource = this.list.getSelected();
        if (databaseInDatasource == null) {
            return null;
        }
        DatabaseInDatasource databaseInDatasource2 = databaseInDatasource;
        RdConnectionString rdConnectionString = LocalDataSourceToConnectionStringMapper.Companion.createConnectionString(databaseInDatasource2.getDataSource(), databaseInDatasource2.getDatabase());
        if (rdConnectionString == null) {
            return null;
        }
        RdConnectionString connectionString = rdConnectionString;
        String string = databaseInDatasource2.getDatabase().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return (RdSetSchemaCompareParticipantRequest)new RdSetSchemaCompareParticipantForDatabaseRequest(connectionString, string);
    }

    @Override
    @NotNull
    public JComponent getPreferableFocusComponent() {
        return (JComponent)this.list.getComponent();
    }

    private final void createNewDataSource() {
        Collection<PotentialConnectionString> connectionStrings = ConnectionStringsProvider.Companion.getInstance(this.getProject()).getConnectionStrings();
        DatabaseConnectionDialog.Builder $this$createNewDataSource_u24lambda_u245 = new DatabaseConnectionDialog.Builder(this.getProject());
        boolean bl = false;
        Dbms[] dbmsArray = new Dbms[]{Dbms.MSSQL, Dbms.MSSQL_LOCALDB};
        $this$createNewDataSource_u24lambda_u245.filterByDbms(dbmsArray);
        $this$createNewDataSource_u24lambda_u245.useConnectionStrings(connectionStrings);
        $this$createNewDataSource_u24lambda_u245.useConnectionType(!connectionStrings.isEmpty() ? ConnectionType.Url : ConnectionType.Manual);
        Dbms dbms = Dbms.MSSQL;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"MSSQL");
        $this$createNewDataSource_u24lambda_u245.selectDefaultDriverFor(dbms);
        DatabaseConnectionDialog dialog = $this$createNewDataSource_u24lambda_u245.build();
        dialog.show();
    }

    private static final Unit getComponent$lambda$4$lambda$1$lambda$0(DatabaseParticipantSelectionTab this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.createNewDataSource();
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$4$lambda$1(DatabaseParticipantSelectionTab this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(RiderDatabaseBundle.INSTANCE.getMessage("schemaCompare.participantSelection.databases.label", new Object[0])).bold().align((Align)AlignX.LEFT.INSTANCE).gap(RightGap.COLUMNS);
        $this$row.cell((JComponent)new ActionLink(RiderDatabaseBundle.INSTANCE.getMessage("schemaCompare.participantSelection.databases.create", new Object[0]), arg_0 -> DatabaseParticipantSelectionTab.getComponent$lambda$4$lambda$1$lambda$0(this$0, arg_0))).align((Align)AlignX.RIGHT.INSTANCE);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getComponent$lambda$4$lambda$3(DatabaseParticipantSelectionTab this$0, Row $this$row) {
        void $this$getComponent_u24lambda_u244_u24lambda_u243_u24lambda_u242;
        JBList<DatabaseInDatasource> jBList;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBList<DatabaseInDatasource> jBList2 = jBList = this$0.list.getComponent();
        Row row = $this$row;
        boolean bl = false;
        $this$getComponent_u24lambda_u244_u24lambda_u243_u24lambda_u242.setFixedCellWidth(40);
        row.scrollCell((JComponent)jBList).resizableColumn().align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$4(DatabaseParticipantSelectionTab this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseParticipantSelectionTab.getComponent$lambda$4$lambda$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseParticipantSelectionTab.getComponent$lambda$4$lambda$3(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }
}

