/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes;

import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.SqlProjectsProblemsViewToolsetPanel;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.grouping.GroupingService;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.problems.ProblemsStorage;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.problems.SqlProjectsProblem;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/nodes/SqlProjectsProblemRootNode;", "Lcom/intellij/analysis/problemsView/toolWindow/Root;", "Lcom/intellij/openapi/Disposable;", "problemsViewToolsetPanel", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/SqlProjectsProblemsViewToolsetPanel;", "problemsStorage", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/problems/ProblemsStorage;", "<init>", "(Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/SqlProjectsProblemsViewToolsetPanel;Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/problems/ProblemsStorage;)V", "groupingService", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/grouping/GroupingService;", "getChildren", "", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "problemAppeared", "", "problem", "Lcom/intellij/analysis/problemsView/Problem;", "problemDisappeared", "problemUpdated", "getProblemCount", "", "getProblemFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileProblemCount", "file", "getFileProblems", "getOtherProblemCount", "getOtherProblems", "intellij.rider.plugins.appender"})
public final class SqlProjectsProblemRootNode
extends Root
implements Disposable {
    @NotNull
    private final ProblemsStorage problemsStorage;
    @NotNull
    private final GroupingService groupingService;

    public SqlProjectsProblemRootNode(@NotNull SqlProjectsProblemsViewToolsetPanel problemsViewToolsetPanel, @NotNull ProblemsStorage problemsStorage) {
        Intrinsics.checkNotNullParameter((Object)((Object)problemsViewToolsetPanel), (String)"problemsViewToolsetPanel");
        Intrinsics.checkNotNullParameter((Object)problemsStorage, (String)"problemsStorage");
        super((ProblemsViewPanel)problemsViewToolsetPanel);
        this.problemsStorage = problemsStorage;
        this.groupingService = new GroupingService(this);
    }

    @NotNull
    public Collection<Node> getChildren() {
        if (this.getProject() == null) {
            return CollectionsKt.emptyList();
        }
        Collection<SqlProjectsProblem> problems = this.problemsStorage.getProblems();
        return this.groupingService.buildTree(problems);
    }

    public void problemAppeared(@NotNull Problem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (!(problem instanceof SqlProjectsProblem)) {
            return;
        }
        this.problemsStorage.addProblem((SqlProjectsProblem)problem);
    }

    public void problemDisappeared(@NotNull Problem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (!(problem instanceof SqlProjectsProblem)) {
            return;
        }
        this.problemsStorage.removeProblem((SqlProjectsProblem)problem);
    }

    public void problemUpdated(@NotNull Problem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
    }

    public int getProblemCount() {
        return this.problemsStorage.getProblemsCount();
    }

    @NotNull
    public Collection<VirtualFile> getProblemFiles() {
        return this.problemsStorage.getProblemFiles();
    }

    public int getFileProblemCount(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.problemsStorage.getFileProblemsCount();
    }

    @NotNull
    public Collection<Problem> getFileProblems(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.problemsStorage.getProblemsForFile(file);
    }

    public int getOtherProblemCount() {
        return this.problemsStorage.getNonFileProblemsCount();
    }

    @NotNull
    public Collection<Problem> getOtherProblems() {
        return this.problemsStorage.getNonFileProblems();
    }
}

