/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.grouping;

import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.groupings.SqlProjectsProblemFileGroupNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.groupings.SqlProjectsProblemProjectGroupNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.groupings.SqlProjectsProblemSchemaComparisonGroupNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.leafs.SchemaComparisonFileProblemLeafNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.leafs.SchemaComparisonProblemLeafNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.leafs.SqlProjectFileProblemLeafNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.leafs.SqlProjectProblemLeafNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.problems.SchemaComparisonFileProblem;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.problems.SchemaComparisonProblem;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.problems.SqlProjectFileProblem;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.problems.SqlProjectProblem;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.problems.SqlProjectsProblem;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.session.SchemaCompareSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007JF\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002JF\u0010\u0013\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\bH\u0002JF\u0010\u0016\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/grouping/GroupingService;", "", "root", "Lcom/intellij/analysis/problemsView/toolWindow/Root;", "<init>", "(Lcom/intellij/analysis/problemsView/toolWindow/Root;)V", "buildTree", "", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "problems", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/problems/SqlProjectsProblem;", "getOrCreateProjectGroupingNode", "groupingNodes", "", "childrenNodes", "", "rdProjectDescriptor", "Lcom/jetbrains/rider/model/RdProjectDescriptor;", "parent", "getOrCreateFileGroupingNode", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getOrCreateSchemaComparisonGroupingNode", "session", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/session/SchemaCompareSession;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nGroupingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupingService.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/grouping/GroupingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1863#2,2:118\n*S KotlinDebug\n*F\n+ 1 GroupingService.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/grouping/GroupingService\n*L\n26#1:118,2\n*E\n"})
public final class GroupingService {
    @NotNull
    private final Root root;

    public GroupingService(@NotNull Root root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    @NotNull
    public final Collection<Node> buildTree(@NotNull Collection<? extends SqlProjectsProblem> problems) {
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        Map groupingNodes = new LinkedHashMap();
        Map childrenNodes = new LinkedHashMap();
        childrenNodes.put(this.root, (List)new ArrayList());
        Set result2 = new LinkedHashSet();
        Iterable $this$forEach$iv = problems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node schemaComparisonNode;
            boolean bl;
            Node projectNode;
            SqlProjectsProblem problem = (SqlProjectsProblem)element$iv;
            boolean bl2 = false;
            SqlProjectsProblem sqlProjectsProblem = problem;
            if (sqlProjectsProblem instanceof SqlProjectFileProblem) {
                projectNode = this.getOrCreateProjectGroupingNode(groupingNodes, childrenNodes, ((SqlProjectFileProblem)problem).getRdProjectDescriptor(), (Node)this.root);
                Node fileNode = this.getOrCreateFileGroupingNode(groupingNodes, childrenNodes, ((SqlProjectFileProblem)problem).getFile(), projectNode);
                List list = (List)childrenNodes.get(fileNode);
                if (list != null) {
                    list.add(new SqlProjectFileProblemLeafNode((SqlProjectFileProblem)problem, fileNode));
                }
                bl = result2.add(projectNode);
                continue;
            }
            if (sqlProjectsProblem instanceof SqlProjectProblem) {
                projectNode = this.getOrCreateProjectGroupingNode(groupingNodes, childrenNodes, ((SqlProjectProblem)problem).getRdProjectDescriptor(), (Node)this.root);
                List list = (List)childrenNodes.get(projectNode);
                if (list != null) {
                    list.add(new SqlProjectProblemLeafNode((SqlProjectProblem)problem, projectNode));
                }
                bl = result2.add(projectNode);
                continue;
            }
            if (sqlProjectsProblem instanceof SchemaComparisonFileProblem) {
                schemaComparisonNode = this.getOrCreateSchemaComparisonGroupingNode(groupingNodes, childrenNodes, ((SchemaComparisonFileProblem)problem).getSession(), (Node)this.root);
                List list = (List)childrenNodes.get(schemaComparisonNode);
                if (list != null) {
                    list.add(new SchemaComparisonFileProblemLeafNode((SchemaComparisonFileProblem)problem, schemaComparisonNode));
                }
                bl = result2.add(schemaComparisonNode);
                continue;
            }
            if (sqlProjectsProblem instanceof SchemaComparisonProblem) {
                schemaComparisonNode = this.getOrCreateSchemaComparisonGroupingNode(groupingNodes, childrenNodes, ((SchemaComparisonProblem)problem).getSession(), (Node)this.root);
                List list = (List)childrenNodes.get(schemaComparisonNode);
                if (list != null) {
                    list.add(new SchemaComparisonProblemLeafNode((SchemaComparisonProblem)problem, schemaComparisonNode));
                }
                bl = result2.add(schemaComparisonNode);
                continue;
            }
            throw new IllegalArgumentException("Unknown problem received: " + problem);
        }
        return result2;
    }

    private final Node getOrCreateProjectGroupingNode(Map<Object, Node> groupingNodes, Map<Node, List<Node>> childrenNodes, RdProjectDescriptor rdProjectDescriptor, Node parent) {
        Node projectNode = groupingNodes.get(rdProjectDescriptor);
        if (projectNode == null) {
            List children = new ArrayList();
            projectNode = new SqlProjectsProblemProjectGroupNode(rdProjectDescriptor, (Collection<? extends Node>)children, parent);
            groupingNodes.put(rdProjectDescriptor, projectNode);
            childrenNodes.put(projectNode, children);
            List<Node> list = childrenNodes.get(parent);
            Intrinsics.checkNotNull(list);
            list.add(projectNode);
        }
        return projectNode;
    }

    private final Node getOrCreateFileGroupingNode(Map<Object, Node> groupingNodes, Map<Node, List<Node>> childrenNodes, VirtualFile file, Node parent) {
        Node fileNode = groupingNodes.get(file);
        if (fileNode == null) {
            List children = new ArrayList();
            fileNode = new SqlProjectsProblemFileGroupNode(file, (Collection<? extends Node>)children, parent);
            groupingNodes.put(file, fileNode);
            childrenNodes.put(fileNode, children);
            List<Node> list = childrenNodes.get(parent);
            Intrinsics.checkNotNull(list);
            list.add(fileNode);
        }
        return fileNode;
    }

    private final Node getOrCreateSchemaComparisonGroupingNode(Map<Object, Node> groupingNodes, Map<Node, List<Node>> childrenNodes, SchemaCompareSession session, Node parent) {
        Node schemaComparisonNode = groupingNodes.get(session);
        if (schemaComparisonNode == null) {
            List children = new ArrayList();
            schemaComparisonNode = new SqlProjectsProblemSchemaComparisonGroupNode(session, (Collection<? extends Node>)children, parent);
            groupingNodes.put(session, schemaComparisonNode);
            childrenNodes.put(schemaComparisonNode, children);
            List<Node> list = childrenNodes.get(parent);
            Intrinsics.checkNotNull(list);
            list.add(schemaComparisonNode);
        }
        return schemaComparisonNode;
    }
}

