/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView;

import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.groupings.SqlProjectsProblemFileGroupNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.groupings.SqlProjectsProblemProjectGroupNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.groupings.SqlProjectsProblemSchemaComparisonGroupNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.problemsView.nodes.leafs.SqlProjectsProblemLeafNodeBase;
import icons.ReSharperIcons;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0014\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fH\u0003\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/SqlProjectsColoredCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "<init>", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "constructLeafNode", "node", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/nodes/leafs/SqlProjectsProblemLeafNodeBase;", "constructFileGroupNode", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/nodes/groupings/SqlProjectsProblemFileGroupNode;", "constructProjectGroupNode", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/nodes/groupings/SqlProjectsProblemProjectGroupNode;", "constructSchemaComparisonGroupNode", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/nodes/groupings/SqlProjectsProblemSchemaComparisonGroupNode;", "countProblemsRecursively", "root", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "createProblemsCountMessage", "", "problemsCount", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nSqlProjectsColoredCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlProjectsColoredCellRenderer.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/SqlProjectsColoredCellRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1863#2,2:79\n*S KotlinDebug\n*F\n+ 1 SqlProjectsColoredCellRenderer.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/problemsView/SqlProjectsColoredCellRenderer\n*L\n64#1:79,2\n*E\n"})
public final class SqlProjectsColoredCellRenderer
extends ColoredTreeCellRenderer {
    public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        if (value2 != null && value2 instanceof Node) {
            Node node = (Node)value2;
            if (node instanceof SqlProjectsProblemLeafNodeBase) {
                this.constructLeafNode((SqlProjectsProblemLeafNodeBase)((Object)value2));
            } else if (node instanceof SqlProjectsProblemFileGroupNode) {
                this.constructFileGroupNode((SqlProjectsProblemFileGroupNode)((Object)value2));
            } else if (node instanceof SqlProjectsProblemSchemaComparisonGroupNode) {
                this.constructSchemaComparisonGroupNode((SqlProjectsProblemSchemaComparisonGroupNode)((Object)value2));
            } else if (node instanceof SqlProjectsProblemProjectGroupNode) {
                this.constructProjectGroupNode((SqlProjectsProblemProjectGroupNode)((Object)value2));
            }
        }
    }

    private final void constructLeafNode(SqlProjectsProblemLeafNodeBase<?> node) {
        this.setIcon(node.getProblemIcon());
        this.append(node.getText());
    }

    private final void constructFileGroupNode(SqlProjectsProblemFileGroupNode node) {
        this.setIcon(node.getFile().getFileType().getIcon());
        this.append(node.getName());
        int problemsCount = node.getChildren().size();
        this.append(this.createProblemsCountMessage(problemsCount), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private final void constructProjectGroupNode(SqlProjectsProblemProjectGroupNode node) {
        this.setIcon(ReSharperIcons.ProjectModel.DatabaseProject);
        this.append(node.getName());
        int problemsCount = this.countProblemsRecursively(node);
        this.append(this.createProblemsCountMessage(problemsCount), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private final void constructSchemaComparisonGroupNode(SqlProjectsProblemSchemaComparisonGroupNode node) {
        this.setIcon(AllIcons.FileTypes.Config);
        this.append(node.getName());
        int problemsCount = this.countProblemsRecursively(node);
        this.append(this.createProblemsCountMessage(problemsCount), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private final int countProblemsRecursively(Node root) {
        int count = 0;
        Iterable $this$forEach$iv = root.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            if (it instanceof SqlProjectsProblemLeafNodeBase) {
                int n = count;
                count = n + 1;
                continue;
            }
            count += this.countProblemsRecursively(it);
        }
        return count;
    }

    @Nls
    private final String createProblemsCountMessage(int problemsCount) {
        Object[] objectArray = new Object[]{problemsCount};
        return " " + RiderDatabaseBundle.message("sqlProjects.problemsView.tab.problems", objectArray);
    }
}

