/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.converters;

import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.ms.converters.ServerParser;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.connectionStrings.SqlServerConnectionString;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.converters.ConnectionPropertyTranslator;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.jdbcUrls.SqlServerJdbcUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/converters/ServerConnectionPropertyTranslator;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/converters/ConnectionPropertyTranslator;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/connectionStrings/SqlServerConnectionString;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/jdbcUrls/SqlServerJdbcUrl;", "<init>", "()V", "fromJdbcToConnectionString", "", "connectionString", "jdbcUrl", "fromConnectionStringToJdbc", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nServerConnectionPropertyTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerConnectionPropertyTranslator.kt\ncom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/converters/ServerConnectionPropertyTranslator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class ServerConnectionPropertyTranslator
implements ConnectionPropertyTranslator<SqlServerConnectionString, SqlServerJdbcUrl> {
    @NotNull
    public static final ServerConnectionPropertyTranslator INSTANCE = new ServerConnectionPropertyTranslator();

    private ServerConnectionPropertyTranslator() {
    }

    @Override
    public void fromJdbcToConnectionString(@NotNull SqlServerConnectionString connectionString, @NotNull SqlServerJdbcUrl jdbcUrl) {
        String it;
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
        StringBuilder serverNameBuilder = new StringBuilder();
        String string = jdbcUrl.getServerName();
        if (string != null) {
            it = string;
            boolean bl = false;
            serverNameBuilder.append(it);
        }
        String string2 = jdbcUrl.getInstance();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            serverNameBuilder.append("\\" + it);
        }
        Integer n = jdbcUrl.getPort();
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            serverNameBuilder.append("," + it2);
        }
        connectionString.setDataSource(serverNameBuilder.toString());
    }

    @Override
    public void fromConnectionStringToJdbc(@NotNull SqlServerConnectionString connectionString, @NotNull SqlServerJdbcUrl jdbcUrl) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
            String string = connectionString.getDataSource();
            if (string == null) break block2;
            String dataSource = string;
            boolean bl = false;
            ServerParser.DataSource serverInfo = ServerParser.INSTANCE.parseServerInfo(dataSource);
            jdbcUrl.setServerName(serverInfo.getServerName());
            String string2 = serverInfo.getInstanceName();
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                jdbcUrl.setInstance(it);
            }
            Integer n = serverInfo.getPort();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl3 = false;
                jdbcUrl.setPort(it);
            }
        }
    }
}

