/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.pg;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.pg.PostgresJdbcUrl;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.pg.UtilsKt;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.retrievers.AlwaysIncludedProperty;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.retrievers.JdbcUrlRetriever;
import java.sql.DriverPropertyInfo;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a2\u0006\u0002\u0010\u000fJ+\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J0\u0010\u001a\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001dH\u0094@\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/pg/PostgresUrlRetriever;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/retrievers/JdbcUrlRetriever;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/pg/PostgresJdbcUrl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getAlwaysIncludedProperties", "", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/retrievers/AlwaysIncludedProperty;", "()[Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/retrievers/AlwaysIncludedProperty;", "getTemplateProperties", "Ljava/sql/DriverPropertyInfo;", "driver", "Lcom/intellij/database/remote/jdbc/RemoteDriver;", "(Lcom/intellij/database/remote/jdbc/RemoteDriver;)[Ljava/sql/DriverPropertyInfo;", "getActualProperties", "url", "", "properties", "Ljava/util/Properties;", "(Lcom/intellij/database/remote/jdbc/RemoteDriver;Ljava/lang/String;Ljava/util/Properties;)[Ljava/sql/DriverPropertyInfo;", "accepts", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "createUrl", "", "environmentVariables", "", "(Ljava/util/Collection;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.plugins.appender"})
public final class PostgresUrlRetriever
extends JdbcUrlRetriever<PostgresJdbcUrl> {
    public PostgresUrlRetriever(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    protected AlwaysIncludedProperty[] getAlwaysIncludedProperties() {
        AlwaysIncludedProperty[] alwaysIncludedPropertyArray = new AlwaysIncludedProperty[]{new AlwaysIncludedProperty(PostgresJdbcUrl.Property.Host, "localhost")};
        return alwaysIncludedPropertyArray;
    }

    @Override
    @NotNull
    protected DriverPropertyInfo[] getTemplateProperties(@NotNull RemoteDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        DriverPropertyInfo[] driverPropertyInfoArray = driver.getPropertyInfo("jdbc:postgresql://someRandomServer/", new Properties());
        Intrinsics.checkNotNullExpressionValue((Object)driverPropertyInfoArray, (String)"getPropertyInfo(...)");
        return driverPropertyInfoArray;
    }

    @Override
    @NotNull
    protected DriverPropertyInfo[] getActualProperties(@NotNull RemoteDriver driver, @NotNull String url, @NotNull Properties properties) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        DriverPropertyInfo[] driverPropertyInfoArray = driver.getPropertyInfo(url, properties);
        Intrinsics.checkNotNullExpressionValue((Object)driverPropertyInfoArray, (String)"getPropertyInfo(...)");
        return driverPropertyInfoArray;
    }

    @Override
    public boolean accepts(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return Intrinsics.areEqual((Object)dataSource.getDbms(), (Object)Dbms.POSTGRES) && UtilsKt.isPostgresDriver(dataSource.getDatabaseDriver());
    }

    @Override
    @Nullable
    protected Object createUrl(@NotNull Collection<? extends DriverPropertyInfo> properties, @NotNull Map<String, String> environmentVariables, @NotNull Continuation<? super PostgresJdbcUrl> $completion) {
        return new PostgresJdbcUrl(properties);
    }
}

