/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.pg;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.DotnetDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.NpgsqlDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.pg.PostgresJdbcUrl;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.pg.UtilsKt;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.connectionStrings.ConnectionString;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.connectionStrings.PostgresConnectionString;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.converters.ConverterBase;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.jdbcUrls.JdbcUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/pg/PgConverter;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/converters/ConverterBase;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/connectionStrings/PostgresConnectionString;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/pg/PostgresJdbcUrl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "convert", "connectionString", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/connectionStrings/ConnectionString;", "databaseDriver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "accepts", "", "jdbcUrl", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/jdbcUrls/JdbcUrl;", "provider", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/dataProviders/DotnetDataProvider;", "getConnectionStringIfAccepts", "getUrlIfAccepts", "mapBasicProperties", "", "mapSecurityAndEncryptionProperties", "mapTimeoutsAndKeepAliveProperties", "mapMiscellaneousProperties", "mapObsoleteProperties", "mapFailoverAndLoadBalancingProperties", "mapPerformanceProperties", "intellij.rider.plugins.appender"})
public final class PgConverter
extends ConverterBase<PostgresConnectionString, PostgresJdbcUrl> {
    @NotNull
    private final Project project;

    public PgConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.mapBasicProperties();
        this.mapSecurityAndEncryptionProperties();
        this.mapTimeoutsAndKeepAliveProperties();
        this.mapPerformanceProperties();
        this.mapFailoverAndLoadBalancingProperties();
        this.mapMiscellaneousProperties();
        this.mapObsoleteProperties();
    }

    @Override
    @Nullable
    public PostgresJdbcUrl convert(@NotNull ConnectionString connectionString, @NotNull DatabaseDriver databaseDriver) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)databaseDriver, (String)"databaseDriver");
        PostgresConnectionString postgresConnectionString = this.getConnectionStringIfAccepts(connectionString, databaseDriver);
        if (postgresConnectionString == null) {
            return null;
        }
        PostgresConnectionString postgresConnectionString2 = postgresConnectionString;
        return (PostgresJdbcUrl)this.toJdbcUrl((ConnectionString)postgresConnectionString2, (JdbcUrl)new PostgresJdbcUrl());
    }

    @Override
    public boolean accepts(@NotNull ConnectionString connectionString, @NotNull DatabaseDriver databaseDriver) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)databaseDriver, (String)"databaseDriver");
        return this.getConnectionStringIfAccepts(connectionString, databaseDriver) != null;
    }

    @Override
    @Nullable
    public PostgresConnectionString convert(@NotNull JdbcUrl jdbcUrl, @NotNull DotnetDataProvider provider) {
        Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        PostgresJdbcUrl postgresJdbcUrl = this.getUrlIfAccepts(jdbcUrl, provider);
        if (postgresJdbcUrl == null) {
            return null;
        }
        PostgresJdbcUrl postgresJdbcUrl2 = postgresJdbcUrl;
        return (PostgresConnectionString)this.toConnectionString((ConnectionString)new PostgresConnectionString(this.project), (JdbcUrl)postgresJdbcUrl2);
    }

    @Override
    public boolean accepts(@NotNull JdbcUrl jdbcUrl, @NotNull DotnetDataProvider provider) {
        Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return this.getUrlIfAccepts(jdbcUrl, provider) != null;
    }

    private final PostgresConnectionString getConnectionStringIfAccepts(ConnectionString connectionString, DatabaseDriver databaseDriver) {
        if (connectionString instanceof PostgresConnectionString && UtilsKt.isPostgresDriver(databaseDriver)) {
            return (PostgresConnectionString)connectionString;
        }
        return null;
    }

    private final PostgresJdbcUrl getUrlIfAccepts(JdbcUrl jdbcUrl, DotnetDataProvider provider) {
        return jdbcUrl instanceof PostgresJdbcUrl && provider instanceof NpgsqlDataProvider ? (PostgresJdbcUrl)jdbcUrl : null;
    }

    private final void mapBasicProperties() {
        this.directMap(PostgresConnectionString.Property.Host, PostgresJdbcUrl.Property.Host);
        this.directMap(PostgresConnectionString.Property.Port, PostgresJdbcUrl.Property.Port);
        this.directMap(PostgresConnectionString.Property.Database, PostgresJdbcUrl.Property.Database);
        this.directMap(PostgresConnectionString.Property.Username, PostgresJdbcUrl.Property.User);
        this.directMap(PostgresConnectionString.Property.Password, PostgresJdbcUrl.Property.Password);
    }

    private final void mapSecurityAndEncryptionProperties() {
        this.directMap(PostgresConnectionString.Property.SslMode, PostgresJdbcUrl.Property.SslMode);
        this.directMap(PostgresConnectionString.Property.SslCertificate, PostgresJdbcUrl.Property.SslCert);
        this.directMap(PostgresConnectionString.Property.SslKey, PostgresJdbcUrl.Property.SslKey);
        this.directMap(PostgresConnectionString.Property.SslPassword, PostgresJdbcUrl.Property.SslPassword);
        this.directMap(PostgresConnectionString.Property.RootCertificate, PostgresJdbcUrl.Property.SslRootCert);
        this.directMap(PostgresConnectionString.Property.KerberosServiceName, PostgresJdbcUrl.Property.KerberosServerName);
        this.directMap(PostgresConnectionString.Property.IncludeErrorDetail, PostgresJdbcUrl.Property.LogServerErrorDetail);
    }

    private final void mapTimeoutsAndKeepAliveProperties() {
        this.directMap(PostgresConnectionString.Property.Timeout, PostgresJdbcUrl.Property.ConnectTimeout);
        this.directMap(PostgresConnectionString.Property.TcpKeepAlive, PostgresJdbcUrl.Property.TcpKeepAlive);
    }

    private final void mapMiscellaneousProperties() {
        this.directMap(PostgresConnectionString.Property.Options, PostgresJdbcUrl.Property.Options);
        this.directMap(PostgresConnectionString.Property.ApplicationName, PostgresJdbcUrl.Property.ApplicationName);
        this.directMap(PostgresConnectionString.Property.SearchPath, PostgresJdbcUrl.Property.CurrentSchema);
    }

    private final void mapObsoleteProperties() {
        this.directMap(PostgresConnectionString.Property.ClientCertificate, PostgresJdbcUrl.Property.SslCert);
        this.directMap(PostgresConnectionString.Property.ClientCertificateKey, PostgresJdbcUrl.Property.SslKey);
    }

    private final void mapFailoverAndLoadBalancingProperties() {
        this.directMap(PostgresConnectionString.Property.LoadBalanceHosts, PostgresJdbcUrl.Property.LoadBalanceHosts);
        this.directMap(PostgresConnectionString.Property.LoadBalanceTimeout, PostgresJdbcUrl.Property.HostRecheckSeconds);
    }

    private final void mapPerformanceProperties() {
        this.directMap(PostgresConnectionString.Property.SocketReceiveBufferSize, PostgresJdbcUrl.Property.ReceiveBufferSize);
        this.directMap(PostgresConnectionString.Property.SocketSendBufferSize, PostgresJdbcUrl.Property.SendBufferSize);
    }
}

