/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.ms;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.mssql.MsUtils;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.ms.SqlServerMsJdbcUrl;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.retrievers.AlwaysIncludedProperty;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.retrievers.JdbcUrlRetriever;
import java.sql.DriverPropertyInfo;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a2\u0006\u0002\u0010\u000fJ+\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a2\u0006\u0002\u0010\u0015J0\u0010\u0016\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0019H\u0094@\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/ms/MsUrlRetriever;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/retrievers/JdbcUrlRetriever;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/ms/SqlServerMsJdbcUrl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getAlwaysIncludedProperties", "", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/retrievers/AlwaysIncludedProperty;", "()[Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/retrievers/AlwaysIncludedProperty;", "getTemplateProperties", "Ljava/sql/DriverPropertyInfo;", "driver", "Lcom/intellij/database/remote/jdbc/RemoteDriver;", "(Lcom/intellij/database/remote/jdbc/RemoteDriver;)[Ljava/sql/DriverPropertyInfo;", "getActualProperties", "url", "", "properties", "Ljava/util/Properties;", "(Lcom/intellij/database/remote/jdbc/RemoteDriver;Ljava/lang/String;Ljava/util/Properties;)[Ljava/sql/DriverPropertyInfo;", "createUrl", "", "environmentVariables", "", "(Ljava/util/Collection;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "accepts", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "isSupportedDbms", "dbms", "Lcom/intellij/database/Dbms;", "PasswordRetriever", "intellij.rider.plugins.appender"})
public final class MsUrlRetriever
extends JdbcUrlRetriever<SqlServerMsJdbcUrl> {
    public MsUrlRetriever(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    protected AlwaysIncludedProperty[] getAlwaysIncludedProperties() {
        AlwaysIncludedProperty[] alwaysIncludedPropertyArray = new AlwaysIncludedProperty[]{new AlwaysIncludedProperty(SqlServerMsJdbcUrl.Property.Server, "localhost")};
        return alwaysIncludedPropertyArray;
    }

    @Override
    @NotNull
    protected DriverPropertyInfo[] getTemplateProperties(@NotNull RemoteDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        DriverPropertyInfo[] driverPropertyInfoArray = driver.getPropertyInfo("jdbc:sqlserver://someRandomServer", new Properties());
        Intrinsics.checkNotNullExpressionValue((Object)driverPropertyInfoArray, (String)"getPropertyInfo(...)");
        return driverPropertyInfoArray;
    }

    @Override
    @NotNull
    protected DriverPropertyInfo[] getActualProperties(@NotNull RemoteDriver driver, @NotNull String url, @NotNull Properties properties) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Object[] retrievedProperties = driver.getPropertyInfo(url, properties);
        DriverPropertyInfo passwordProperty = PasswordRetriever.INSTANCE.retrievePasswordIfExists(url);
        if (passwordProperty != null) {
            Intrinsics.checkNotNull((Object)retrievedProperties);
            objectArray = (DriverPropertyInfo[])ArraysKt.plus((Object[])retrievedProperties, (Object)passwordProperty);
        } else {
            Intrinsics.checkNotNull((Object)retrievedProperties);
            objectArray = retrievedProperties;
        }
        return objectArray;
    }

    @Override
    @Nullable
    protected Object createUrl(@NotNull Collection<? extends DriverPropertyInfo> properties, @NotNull Map<String, String> environmentVariables, @NotNull Continuation<? super SqlServerMsJdbcUrl> $completion) {
        return new SqlServerMsJdbcUrl(properties);
    }

    @Override
    public boolean accepts(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Dbms dbms = dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return this.isSupportedDbms(dbms) && MsUtils.isMs((DatabaseDriver)dataSource.getDatabaseDriver());
    }

    private final boolean isSupportedDbms(Dbms dbms) {
        return dbms.in(Dbms.MSSQL_LIKE) || dbms.in(Dbms.AZURE_LIKE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/ms/MsUrlRetriever$PasswordRetriever;", "", "<init>", "()V", "passwordRegex", "Lkotlin/text/Regex;", "retrievePasswordIfExists", "Ljava/sql/DriverPropertyInfo;", "url", "", "getUnescapedPasswordValue", "getUnescapedValue", "getValue", "intellij.rider.plugins.appender"})
    private static final class PasswordRetriever {
        @NotNull
        public static final PasswordRetriever INSTANCE = new PasswordRetriever();
        @NotNull
        private static final Regex passwordRegex = new Regex(";\\s*password\\s*=(.*)", RegexOption.IGNORE_CASE);

        private PasswordRetriever() {
        }

        @Nullable
        public final DriverPropertyInfo retrievePasswordIfExists(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            MatchResult matchResult = Regex.find$default((Regex)passwordRegex, (CharSequence)url, (int)0, (int)2, null);
            Object object = matchResult;
            if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
                return null;
            }
            Object passwordValue = object;
            String string = this.getUnescapedPasswordValue((String)passwordValue);
            if (string == null) {
                return null;
            }
            String password = string;
            String propertyName = SqlServerMsJdbcUrl.Property.Password.getNames()[0];
            return new DriverPropertyInfo(propertyName, password);
        }

        private final String getUnescapedPasswordValue(String url) {
            String trimmed = ((Object)StringsKt.trim((CharSequence)url)).toString();
            boolean isEscaped = StringsKt.startsWith$default((CharSequence)trimmed, (char)'{', (boolean)false, (int)2, null);
            return isEscaped ? this.getUnescapedValue(trimmed) : this.getValue(trimmed);
        }

        private final String getUnescapedValue(String url) {
            StringBuilder builder = new StringBuilder();
            int numberOfClosingBracketsInARow = 0;
            int n = url.length();
            for (int i = 1; i < n; ++i) {
                if (url.charAt(i) == '}') {
                    if (++numberOfClosingBracketsInARow % 2 != 0) continue;
                    builder.append(url.charAt(i));
                    continue;
                }
                if (numberOfClosingBracketsInARow % 2 != 0) {
                    return builder.toString();
                }
                numberOfClosingBracketsInARow = 0;
                builder.append(url.charAt(i));
            }
            return numberOfClosingBracketsInARow % 2 != 0 ? builder.toString() : null;
        }

        private final String getValue(String url) {
            int n = ((CharSequence)url).length();
            for (int i = 0; i < n; ++i) {
                if (url.charAt(i) == '{') {
                    return null;
                }
                if (url.charAt(i) != ';') continue;
                String string = url.substring(0, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return url;
        }
    }
}

