/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.jtds.converters;

import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.drivers.jtds.SqlServerJtdsJdbcUrl;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.connectionStrings.SqlServerConnectionString;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.converters.ConnectionPropertyTranslator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/jtds/converters/SslConnectionPropertyTranslator;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/converters/ConnectionPropertyTranslator;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/shared/connectionStrings/SqlServerConnectionString;", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/drivers/jtds/SqlServerJtdsJdbcUrl;", "<init>", "()V", "fromJdbcToConnectionString", "", "connectionString", "jdbcUrl", "fromConnectionStringToJdbc", "intellij.rider.plugins.appender"})
public final class SslConnectionPropertyTranslator
implements ConnectionPropertyTranslator<SqlServerConnectionString, SqlServerJtdsJdbcUrl> {
    @NotNull
    public static final SslConnectionPropertyTranslator INSTANCE = new SslConnectionPropertyTranslator();

    private SslConnectionPropertyTranslator() {
    }

    @Override
    public void fromJdbcToConnectionString(@NotNull SqlServerConnectionString connectionString, @NotNull SqlServerJtdsJdbcUrl jdbcUrl) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
        String string = jdbcUrl.getSsl();
        if (string == null) {
            return;
        }
        String ssl = string;
        if (StringsKt.equals((String)ssl, (String)"off", (boolean)true) || StringsKt.equals((String)ssl, (String)"request", (boolean)true)) {
            connectionString.setEncrypt("False");
        } else if (StringsKt.equals((String)ssl, (String)"require", (boolean)true)) {
            connectionString.setEncrypt("True");
        } else if (StringsKt.equals((String)ssl, (String)"authenticate", (boolean)true)) {
            connectionString.setEncrypt("True");
            connectionString.setTrustServerCertificate(false);
        }
    }

    @Override
    public void fromConnectionStringToJdbc(@NotNull SqlServerConnectionString connectionString, @NotNull SqlServerJtdsJdbcUrl jdbcUrl) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
        String string = connectionString.getEncrypt();
        if (string == null) {
            return;
        }
        String encrypt = string;
        if (StringsKt.equals((String)encrypt, (String)"False", (boolean)true) || StringsKt.equals((String)encrypt, (String)"No", (boolean)true)) {
            jdbcUrl.setSsl("off");
        } else if (StringsKt.equals((String)encrypt, (String)"Optional", (boolean)true)) {
            jdbcUrl.setSsl("request");
        } else if (StringsKt.equals((String)encrypt, (String)"True", (boolean)true) || StringsKt.equals((String)encrypt, (String)"Mandatory", (boolean)true)) {
            jdbcUrl.setSsl(Intrinsics.areEqual((Object)connectionString.getTrustServerCertificate(), (Object)true) ? "require" : "authenticate");
        }
    }
}

